/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.mibs.MibNode;
import com.adventnet.snmp.ui.BaseColumnClass;
import com.adventnet.snmp.ui.SnmpTableModel;
import com.adventnet.snmp.ui.Utils;
import com.adventnet.utils.SnmpUtils;
import java.applet.Applet;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableBean
extends JTable
implements Serializable,
VetoableChangeListener {
    String[] columns = null;
    SnmpTableModel dataTable;
    boolean model_flag = true;
    boolean isFromUI = false;
    String host = null;
    String community = "public";
    String mibs = null;
    String tableOID = null;
    int port = 161;
    int retries = 0;
    int timeout = 5;

    public TableBean() {
        this((Applet)null);
    }

    public TableBean(Applet applet) {
        this.dataTable = new SnmpTableModel(applet);
    }

    private void checkPropertyChange() {
        boolean bl = false;
        if (this.host != null && this.host.trim().length() > 0 && this.tableOID != null && this.mibs != null) {
            bl = true;
        }
        if (bl) {
            this.init();
        }
    }

    public void editHeader(int n, String string) {
        String string2 = this.dataTable.getColumnName(n);
        if (string2 == null) {
            return;
        }
        this.getColumn(string2).setHeaderValue(string);
    }

    public String getCharacterEncoding() {
        return this.dataTable.getCharacterEncoding();
    }

    public String getCommunity() {
        return this.community;
    }

    public boolean getDebug() {
        return this.dataTable.getDebug();
    }

    public String getHost() {
        return this.dataTable.getTargetHost();
    }

    public String getMibModules() {
        return this.mibs;
    }

    public String getMibPath() {
        return this.dataTable.getMibPath();
    }

    public String[] getObjectIDList() {
        return this.dataTable.getObjectIDList();
    }

    public boolean getOverwriteCMI() {
        return this.dataTable.getOverwriteCMI();
    }

    public int getPollInterval() {
        return this.dataTable.getPollInterval();
    }

    public int getPort() {
        return this.dataTable.getTargetPort();
    }

    public int getRetries() {
        return this.retries;
    }

    public boolean getRetrievalMode() {
        return this.dataTable.getRetrievalMode();
    }

    public String getSerializedMibFileName() {
        return this.dataTable.getSerializedMibFileName();
    }

    public SnmpTableModel getSnmpTableModel() {
        return this.dataTable;
    }

    public String getTableOID() {
        return this.tableOID;
    }

    public String getTargetHost() {
        return this.dataTable.getTargetHost();
    }

    public int getTargetPort() {
        return this.dataTable.getTargetPort();
    }

    public int getTimeout() {
        return this.timeout;
    }

    private boolean init() {
        try {
            if (this.mibs != null) {
                this.dataTable.loadMibs(this.mibs);
            }
            if (this.tableOID != null) {
                this.dataTable.setTableOID(this.tableOID);
            }
            if (this.columns != null) {
                this.dataTable.setObjectIDList(this.columns);
            }
        }
        catch (Exception exception) {
            Utils.err(String.valueOf(SnmpUtils.getString("Error :")) + " " + exception);
            return false;
        }
        this.setModel1(this.dataTable);
        this.setMinimumSize(new Dimension(this.dataTable.getColumnCount() * 100, super.getMinimumSize().height));
        this.sizeColumnsToFit(-1);
        int n = 0;
        while (n < this.dataTable.getColumnCount()) {
            MibNode mibNode = this.dataTable.getColumnMibNode(n);
            JComponent jComponent = BaseColumnClass.getCellEditor(mibNode.getSyntax());
            if (jComponent != null && jComponent instanceof JComboBox) {
                this.getColumnModel().getColumn(n).setCellEditor(new DefaultCellEditor((JComboBox)jComponent));
            }
            ++n;
        }
        return true;
    }

    public void initJdbcParams(String string, String string2, String string3, String string4) {
        try {
            this.dataTable.initJdbcParams(string, string2, string3, string4);
        }
        catch (Exception exception) {
            System.out.println(String.valueOf(SnmpUtils.getString("Error :")) + " " + exception);
        }
    }

    public boolean isLoadFromCompiledMibs() {
        return this.dataTable.isLoadFromCompiledMibs();
    }

    public boolean isLoadFromSerializedMibs() {
        return this.dataTable.isLoadFromSerializedMibs();
    }

    public boolean isLoadMibsFromDatabase() {
        return this.dataTable.isLoadMibsFromDatabase();
    }

    public boolean isOverwriteMibsInDatabase() {
        return this.dataTable.isOverwriteMibsInDatabase();
    }

    public boolean isReadDesc() {
        return this.dataTable.isReadDesc();
    }

    public boolean isSerializeMibs() {
        return this.dataTable.isSerializeMibs();
    }

    public void refreshTable() {
        this.init();
    }

    public void setCharacterEncoding(String string) {
        this.dataTable.setCharacterEncoding(string);
    }

    public void setColumnsPolled(Vector vector) {
        this.dataTable.setColumnsPolled(vector);
    }

    public void setCommunity(String string) {
        this.community = string;
        this.dataTable.setCommunity(string);
    }

    public void setDebug(boolean bl) {
        this.dataTable.setDebug(bl);
    }

    public void setFromUI(boolean bl) {
        this.isFromUI = bl;
    }

    public void setHost(String string) {
        this.host = string;
        this.dataTable.setTargetHost(string);
        this.checkPropertyChange();
    }

    public void setLoadFromCompiledMibs(boolean bl) {
        this.dataTable.setLoadFromCompiledMibs(bl);
    }

    public void setLoadFromSerializedMibs(boolean bl) {
        this.dataTable.setLoadFromSerializedMibs(bl);
    }

    public void setLoadMibsFromDatabase(boolean bl) {
        this.dataTable.setLoadMibsFromDatabase(bl);
    }

    public void setMibModules(String string) {
        this.mibs = string;
        this.checkPropertyChange();
    }

    public void setMibPath(String string) {
        this.dataTable.setMibPath(string);
    }

    protected void setModel1(TableModel tableModel) {
        TableModel tableModel2 = tableModel;
        if (tableModel2 != null) {
            int n;
            int[] nArray;
            TableColumnModel tableColumnModel = this.getColumnModel();
            if (tableModel2.getColumnCount() == tableColumnModel.getColumnCount()) {
                nArray = new int[tableColumnModel.getColumnCount()];
                n = 0;
                while (n < nArray.length) {
                    nArray[n] = tableColumnModel.getColumn(n).getWidth();
                    ++n;
                }
            } else {
                nArray = new int[tableModel2.getColumnCount()];
                if (nArray != null && nArray.length != 0) {
                    n = tableColumnModel.getTotalColumnWidth() == 0 ? this.getWidth() / nArray.length : tableColumnModel.getTotalColumnWidth() / nArray.length;
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        nArray[n2] = n;
                        ++n2;
                    }
                }
            }
            tableColumnModel.removeColumnModelListener(this);
            while (tableColumnModel.getColumnCount() > 0) {
                tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
            }
            n = 0;
            while (n < tableModel2.getColumnCount()) {
                TableColumn tableColumn = new TableColumn(n);
                tableColumn.setWidth(nArray[n]);
                this.addColumn(tableColumn);
                ++n;
            }
            tableColumnModel.addColumnModelListener(this);
        }
        this.setModel(tableModel2);
    }

    public void setObjectIDList(String[] stringArray) {
        this.columns = stringArray;
        try {
            if (this.mibs != null) {
                this.dataTable.loadMibs(this.mibs);
            }
        }
        catch (Exception exception) {
            Utils.err(String.valueOf(SnmpUtils.getString("Error :")) + " " + exception);
        }
        this.dataTable.setObjectIDList(stringArray);
        this.setModel1(this.dataTable);
        int n = 0;
        while (n < this.dataTable.getColumnCount()) {
            MibNode mibNode = this.dataTable.getColumnMibNode(n);
            if (mibNode == null) break;
            JComponent jComponent = BaseColumnClass.getCellEditor(mibNode.getSyntax());
            if (jComponent != null && jComponent instanceof JComboBox) {
                this.getColumnModel().getColumn(n).setCellEditor(new DefaultCellEditor((JComboBox)jComponent));
            }
            ++n;
        }
    }

    public void setOverwriteCMI(boolean bl) {
        this.dataTable.setOverwriteCMI(bl);
    }

    public void setOverwriteMibsInDatabase(boolean bl) {
        this.dataTable.setOverwriteMibsInDatabase(bl);
    }

    public void setParams(String string, String string2, String string3) {
        if (string != null) {
            this.setTargetHost(string);
        }
        if (string2 != null) {
            this.setMibModules(string2);
        }
        if (string3 != null) {
            this.setTableOIDWoStart(string3);
        }
    }

    public void setPollInterval(int n) {
        if (n < 0) {
            System.out.println(SnmpUtils.getString("Error : Polling interval cannot be negative"));
            return;
        }
        this.dataTable.setPollInterval(n);
    }

    public void setPort(int n) {
        this.port = n;
        this.dataTable.setTargetPort(n);
        this.checkPropertyChange();
    }

    public void setReadDesc(boolean bl) {
        this.dataTable.setReadDesc(bl);
    }

    public void setRetries(int n) {
        if (n < 0) {
            System.out.println(SnmpUtils.getString("Error : Retries cannot be negative"));
        }
        this.retries = n;
        this.dataTable.setRetries(n);
    }

    public void setRetrievalMode(boolean bl) {
        this.dataTable.setRetrievalMode(bl);
    }

    public void setSerializeMibs(boolean bl) {
        this.dataTable.setSerializeMibs(bl);
    }

    public void setSerializedMibFileName(String string) {
        this.dataTable.setSerializedMibFileName(string);
    }

    public void setTableOID(String string) {
        this.columns = null;
        this.tableOID = string;
        this.checkPropertyChange();
    }

    public void setTableOIDWoStart(String string) {
        this.tableOID = string;
    }

    public void setTargetHost(String string) {
        this.host = string;
        this.dataTable.setTargetHost(string);
        this.checkPropertyChange();
    }

    public void setTargetPort(int n) {
        this.port = n;
        this.dataTable.setTargetPort(n);
        this.checkPropertyChange();
    }

    public void setTimeout(int n) {
        if (n < 0) {
            System.out.println(SnmpUtils.getString("Error : Timeout cannot be negative"));
        }
        this.timeout = n;
        this.dataTable.setTimeout(n);
    }

    public void startPolling() {
        if (this.getPollInterval() > 0) {
            this.dataTable.setPollInterval(this.getPollInterval());
        } else {
            this.dataTable.setPollInterval(5);
        }
    }

    public void stopPolling() {
        this.dataTable.setPollInterval(0);
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
        String string = (String)propertyChangeEvent.getOldValue();
        Hashtable hashtable = (Hashtable)propertyChangeEvent.getNewValue();
        if (string.equals("OLD INSTANCE")) {
            int n;
            String string2 = (String)hashtable.get("HOST");
            if (!string2.equals("")) {
                this.setTargetHost(string2);
            }
            if ((n = Integer.parseInt((String)hashtable.get("PORT"))) != -999) {
                this.setTargetPort(n);
            }
            if ((n = Integer.parseInt((String)hashtable.get("RETRIES"))) != -999) {
                this.setRetries(n);
            }
            if ((n = Integer.parseInt((String)hashtable.get("TIMEOUT"))) != -999) {
                this.setTimeout(n);
            }
        }
    }
}

