/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.beans.SnmpPoller;
import com.adventnet.snmp.ui.LineGraphBean;
import com.adventnet.snmp.ui.SnmpTablePanel;
import com.adventnet.snmp.ui.SnmpTablePanelModel;
import com.adventnet.utils.SnmpUIUtils;
import com.adventnet.utils.SnmpUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class TableGraph
extends JFrame
implements ActionListener,
ItemListener {
    LineGraphBean graph;
    SnmpPoller poller;
    SnmpTablePanel spanel;
    JButton close = null;
    JButton stop = null;
    JButton restart = null;
    JCheckBox avg;
    JCheckBox abs;
    JCheckBox timeSpan;
    JCheckBox graphLog;
    JCheckBox counter = null;
    JTextField interval;
    JTextField duration;
    JTextField logField = null;
    JTextField scale = null;
    boolean showVal;
    boolean storeVal = false;
    Font lfont = SnmpUIUtils.getFont();

    public TableGraph(SnmpTablePanelModel snmpTablePanelModel, String[] stringArray) {
        super(SnmpUtils.getString("SnmpTable LineGraph"));
        this.graph = new LineGraphBean();
        this.poller = new SnmpPoller();
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel(SnmpUtils.getString("Polling Interval (sec's.)"));
        jLabel.setFont(this.lfont);
        jLabel.setForeground(Color.black);
        JLabel jLabel2 = new JLabel(SnmpUtils.getString("Max Poll Duration(sec's.)"));
        jLabel2.setFont(this.lfont);
        jLabel2.setForeground(Color.black);
        JLabel jLabel3 = new JLabel(SnmpUtils.getString("Log FileName"));
        jLabel3.setFont(this.lfont);
        jLabel3.setForeground(Color.black);
        JLabel jLabel4 = new JLabel(SnmpUtils.getString("X-axis Scale  (>300)"));
        jLabel4.setFont(this.lfont);
        jLabel4.setForeground(Color.black);
        this.interval = new JTextField("5", 4);
        this.interval.addActionListener(this);
        this.duration = new JTextField("3600", 4);
        this.duration.setEnabled(false);
        this.duration.addActionListener(this);
        this.logField = new JTextField("graph.txt", 10);
        this.logField.setEnabled(false);
        this.logField.addActionListener(this);
        this.avg = new JCheckBox(SnmpUtils.getString("Average over Interval?"));
        this.avg.addItemListener(this);
        this.avg.setFont(this.lfont);
        this.abs = new JCheckBox(SnmpUtils.getString("Show Absolute Time?"));
        this.abs.addItemListener(this);
        this.abs.setFont(this.lfont);
        this.timeSpan = new JCheckBox(SnmpUtils.getString("Show Polled Values?"));
        this.timeSpan.addItemListener(this);
        this.timeSpan.setFont(this.lfont);
        this.graphLog = new JCheckBox(SnmpUtils.getString("Log Polled Values?"));
        this.graphLog.addItemListener(this);
        this.graphLog.setFont(this.lfont);
        this.counter = new JCheckBox(SnmpUtils.getString("Show Absolute Counters"));
        this.counter.addItemListener(this);
        this.counter.setFont(this.lfont);
        this.scale = new JTextField("300", 4);
        this.close = new JButton(SnmpUtils.getString("Close"));
        this.close.addActionListener(this);
        this.close.setFont(this.lfont);
        this.stop = new JButton(SnmpUtils.getString("Stop"));
        this.stop.addActionListener(this);
        this.stop.setFont(this.lfont);
        this.restart = new JButton(SnmpUtils.getString("Restart"));
        this.restart.addActionListener(this);
        this.restart.setFont(this.lfont);
        this.spanel = snmpTablePanelModel.getSnmpTablePanel();
        if (this.spanel.applet != null) {
            jLabel3.setEnabled(false);
            this.graphLog.setEnabled(false);
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.restart);
        jPanel2.add(this.stop);
        jPanel2.add(this.close);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(this.counter);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.interval, gridBagConstraints);
        jPanel.add(this.interval);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 20, 0, 10);
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.avg, gridBagConstraints);
        jPanel.add(this.avg);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jLabel4, gridBagConstraints);
        jPanel.add(jLabel4);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(10, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.scale, gridBagConstraints);
        jPanel.add(this.scale);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(10, 20, 0, 5);
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.abs, gridBagConstraints);
        jPanel.add(this.abs);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(10, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.duration, gridBagConstraints);
        jPanel.add(this.duration);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(10, 20, 0, 5);
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.timeSpan, gridBagConstraints);
        jPanel.add(this.timeSpan);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel.add(jLabel3);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(10, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.logField, gridBagConstraints);
        jPanel.add(this.logField);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(10, 20, 0, 5);
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.graphLog, gridBagConstraints);
        jPanel.add(this.graphLog);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        this.poller.setObjectIDList(stringArray);
        this.graph.setTitle(String.valueOf(SnmpUtils.getString("Graphing")) + " " + this.poller.getMibOperations().toShortString(this.poller.getSnmpOID()) + " " + SnmpUtils.getString(" on ") + " " + snmpTablePanelModel.getTargetHost());
        this.graph.setAbstime(false);
        this.scale.addActionListener(this);
        String string = "";
        int n = 0;
        while (n < stringArray.length) {
            string = String.valueOf(string) + this.poller.getMibOperations().toShortString(this.poller.getMibOperations().getSnmpOID(stringArray[n])) + " ";
            ++n;
        }
        this.graph.setLineLabels(string);
        this.graph.setValues();
        this.poller.setTargetHost(snmpTablePanelModel.getTargetHost());
        this.poller.setTargetPort(snmpTablePanelModel.getTargetPort());
        this.poller.setCommunity(snmpTablePanelModel.getCommunity());
        this.poller.setPollInterval(5);
        this.poller.addResultListener(this.graph);
        this.getContentPane().add("Center", this.graph);
        this.getContentPane().add("South", jPanel);
        this.pack();
        ((Component)this).setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block32: {
            int n;
            if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Close"))) {
                this.poller.stopPolling();
                this.poller.removeResultListener(this.graph);
                ((Component)this).setVisible(false);
            }
            if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Stop"))) {
                this.poller.stopPolling();
                this.timeSpan.setEnabled(true);
                if (this.spanel.applet == null) {
                    this.graphLog.setEnabled(true);
                }
                if (this.showVal) {
                    this.duration.setEnabled(true);
                }
                if (this.storeVal) {
                    this.logField.setEnabled(true);
                }
            }
            if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Restart"))) {
                this.poller.removeResultListener(this.graph);
                this.poller.stopPolling();
                if (this.showVal) {
                    try {
                        n = Integer.parseInt(this.duration.getText());
                        this.graph.setPollDuration(n);
                        this.scale.setEnabled(true);
                        if (this.graph.jsb != null) {
                            this.graph.jsb.setEnabled(true);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println(String.valueOf(SnmpUtils.getString("Non Numeric value:")) + " " + this.duration.getText());
                        this.duration.setText(String.valueOf(this.graph.getPollDuration()));
                        this.graph.setPollDuration(this.graph.getPollDuration());
                    }
                    n = 300;
                    try {
                        n = Integer.parseInt(this.scale.getText());
                        if (n < 300) {
                            System.err.println(String.valueOf(SnmpUtils.getString("Invalid X-axis Scale value:")) + " " + n);
                            this.scale.setText(String.valueOf(this.graph.getXscale()));
                            return;
                        }
                        this.graph.setXscale(n);
                        this.graph.repaint();
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.graph.setXscale(this.graph.getXscale());
                        System.err.println(SnmpUtils.getString("Scale value should be an integer"));
                        this.scale.setText(String.valueOf(this.graph.getXscale()));
                    }
                } else {
                    this.graph.setPollDuration(0);
                    if (this.graph.jsb != null) {
                        this.graph.jsb.setEnabled(false);
                    }
                    this.scale.setEnabled(false);
                }
                if (this.storeVal) {
                    try {
                        this.graph.setLogFileName(this.logField.getText());
                    }
                    catch (NullPointerException nullPointerException) {
                        this.graph.setLogFileName(this.graph.getLogFileName());
                        System.err.println(SnmpUtils.getString("FileName not specified"));
                    }
                }
                try {
                    n = Integer.parseInt(this.interval.getText());
                    this.poller.setPollInterval(n);
                }
                catch (NumberFormatException numberFormatException) {
                    this.poller.setPollInterval(this.poller.getPollInterval());
                    System.err.println(String.valueOf(SnmpUtils.getString("Invalid interval value: ")) + " " + this.interval.getText());
                    this.interval.setText(String.valueOf(this.poller.getPollInterval()));
                }
                this.graph.setValues();
                this.poller.addResultListener(this.graph);
                this.poller.restartPolling();
            }
            if (actionEvent.getSource().equals(this.interval)) {
                try {
                    n = Integer.parseInt(this.interval.getText());
                    this.poller.setPollInterval(n);
                }
                catch (NumberFormatException numberFormatException) {
                    this.poller.setPollInterval(this.poller.getPollInterval());
                    System.err.println(String.valueOf(SnmpUtils.getString("Invalid interval value: ")) + " " + this.interval.getText());
                    this.interval.setText(String.valueOf(this.poller.getPollInterval()));
                }
            }
            if (actionEvent.getSource().equals(this.duration)) {
                try {
                    n = Integer.parseInt(this.duration.getText());
                    this.graph.setPollDuration(n);
                    this.graph.setValues();
                    this.poller.restartPolling();
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println(String.valueOf(SnmpUtils.getString("Non Numeric value:")) + " " + this.duration.getText());
                    this.duration.setText(String.valueOf(this.graph.getPollDuration()));
                    this.graph.setPollDuration(this.graph.getPollDuration());
                    this.graph.setValues();
                    this.poller.restartPolling();
                }
            }
            if (actionEvent.getSource().equals(this.logField)) {
                try {
                    String string = this.logField.getText();
                    this.graph.setLogFileName(string);
                    this.graph.setValues();
                    this.poller.restartPolling();
                }
                catch (Exception exception) {
                    System.err.println(SnmpUtils.getString("FileName not specified"));
                }
            }
            if (!actionEvent.getSource().equals(this.scale)) break block32;
            int n2 = 300;
            try {
                n2 = Integer.parseInt(this.scale.getText());
                if (n2 < 300) {
                    System.err.println(String.valueOf(SnmpUtils.getString("Invalid X-axis Scale value:")) + " " + n2);
                    this.scale.setText(String.valueOf(this.graph.getXscale()));
                    return;
                }
                this.graph.setXscale(n2);
                this.graph.repaint();
                this.poller.restartPolling();
            }
            catch (NumberFormatException numberFormatException) {
                this.graph.setXscale(this.graph.getXscale());
                System.err.println(SnmpUtils.getString("Scale value should be an integer"));
                this.scale.setText(String.valueOf(this.graph.getXscale()));
            }
        }
    }

    public void exitAll() {
        this.poller.stopPolling();
        this.poller.removeResultListener(this.graph);
        this.poller = null;
        this.graph = null;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getItem();
        if (object instanceof JCheckBox) {
            String string = ((JCheckBox)object).getText();
            if (string.equals(SnmpUtils.getString("Show Absolute Counters"))) {
                this.graph.setAbsoluteCounters(((JCheckBox)object).isSelected());
                this.graph.repaint();
            }
            if (string.equals(SnmpUtils.getString("Average over Interval?"))) {
                this.graph.setTimeavg(((JCheckBox)object).isSelected());
                this.graph.repaint();
            }
            if (string.equals(SnmpUtils.getString("Show Absolute Time?"))) {
                this.graph.setAbstime(((JCheckBox)object).isSelected());
                this.graph.repaint();
            }
            if (string.equals(SnmpUtils.getString("Show Polled Values?"))) {
                if (((JCheckBox)object).isSelected()) {
                    this.duration.setEnabled(true);
                    try {
                        this.graph.setPollDuration(this.graph.getPollDuration());
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.out.println(SnmpUtils.getString("Non Numeric value:"));
                    }
                    if (this.graph.jsb != null) {
                        this.graph.jsb.setEnabled(true);
                    }
                    this.scale.setEnabled(true);
                    this.showVal = true;
                    this.graph.setValues();
                    this.poller.restartPolling();
                } else {
                    this.duration.setEnabled(false);
                    this.scale.setEnabled(false);
                    this.showVal = false;
                    if (this.graph.jsb != null) {
                        this.graph.jsb.setEnabled(false);
                    }
                    this.graph.setValues();
                    this.poller.restartPolling();
                }
            }
            if (string.equals(SnmpUtils.getString("Log Polled Values?"))) {
                if (((JCheckBox)object).isSelected()) {
                    this.graph.setLogEnabled(true);
                    this.logField.setEnabled(true);
                    this.poller.restartPolling();
                    this.storeVal = true;
                } else {
                    this.graph.setLogEnabled(false);
                    this.logField.setEnabled(false);
                    this.poller.restartPolling();
                    this.storeVal = false;
                }
            }
            return;
        }
    }
}

