/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.ui.BrowserDataModel;
import com.adventnet.snmp.ui.TableMap;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TableSorter
extends TableMap {
    Vector sortingColumns = new Vector();
    boolean ascending = true;
    int compares;
    int previouslySortedColumnIndex = -1;
    Vector trapList = null;
    Vector trapColors = null;

    public TableSorter(Vector vector, Vector vector2) {
        this.trapList = vector;
        this.trapColors = vector2;
    }

    public TableSorter(TableModel tableModel, Vector vector, Vector vector2) {
        this.setModel(tableModel);
        this.trapList = vector;
        this.trapColors = vector2;
    }

    public void addMouseListenerToHeaderInTable(JTable jTable) {
        TableSorter tableSorter = this;
        final JTable jTable2 = jTable;
        jTable2.setColumnSelectionAllowed(false);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = jTable2.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n2 = jTable2.convertColumnIndexToModel(n);
                if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                    if (previouslySortedColumnIndex == n2) {
                        ascending = false;
                        previouslySortedColumnIndex = -1;
                    } else {
                        ascending = true;
                        previouslySortedColumnIndex = n2;
                    }
                    jTable2.setCursor(new Cursor(3));
                    TableSorter.this.sortByColumn(n2, ascending);
                    jTable2.setCursor(new Cursor(0));
                    jTable2.getSelectionModel().setSelectionInterval(0, 0);
                }
            }
        };
        JTableHeader jTableHeader = jTable2.getTableHeader();
        jTableHeader.addMouseListener(mouseAdapter);
    }

    public void addRow(Object[] objectArray, Image[] imageArray, Color color) {
        ((BrowserDataModel)this.model).addRow(objectArray, imageArray, color);
    }

    public void deleteRow(int n) {
        ((BrowserDataModel)this.model).deleteRow(n);
    }

    public Object getValueAt(int n, int n2) {
        return this.model.getValueAt(n, n2);
    }

    private int partition(int n, int n2, int n3) {
        Object e;
        Vector vector = ((BrowserDataModel)this.model).getTableDataVec();
        int n4 = (n + n2) / 2;
        String string = (String)this.model.getValueAt(n4, n3);
        Object e2 = vector.elementAt(n4);
        vector.setElementAt(vector.elementAt(n), n4);
        vector.setElementAt(e2, n);
        e2 = this.trapList.elementAt(n4);
        this.trapList.setElementAt(this.trapList.elementAt(n), n4);
        this.trapList.setElementAt(e2, n);
        e2 = this.trapColors.elementAt(n4);
        this.trapColors.setElementAt(this.trapColors.elementAt(n), n4);
        this.trapColors.setElementAt(e2, n);
        int n5 = n;
        int n6 = n + 1;
        while (n6 <= n2) {
            String string2 = (String)this.model.getValueAt(n6, n3);
            if (this.ascending) {
                if (string2.compareTo((Object)string) < 0) {
                    e = vector.elementAt(++n5);
                    vector.setElementAt(vector.elementAt(n6), n5);
                    vector.setElementAt(e, n6);
                    e = this.trapList.elementAt(n5);
                    this.trapList.setElementAt(this.trapList.elementAt(n6), n5);
                    this.trapList.setElementAt(e, n6);
                    e = this.trapColors.elementAt(n5);
                    this.trapColors.setElementAt(this.trapColors.elementAt(n6), n5);
                    this.trapColors.setElementAt(e, n6);
                }
            } else if (string2.compareTo((Object)string) > 0) {
                e = vector.elementAt(++n5);
                vector.setElementAt(vector.elementAt(n6), n5);
                vector.setElementAt(e, n6);
                e = this.trapList.elementAt(n5);
                this.trapList.setElementAt(this.trapList.elementAt(n6), n5);
                this.trapList.setElementAt(e, n6);
                e = this.trapColors.elementAt(n5);
                this.trapColors.setElementAt(this.trapColors.elementAt(n6), n5);
                this.trapColors.setElementAt(e, n6);
            }
            ++n6;
        }
        e = vector.elementAt(n);
        vector.setElementAt(vector.elementAt(n5), n);
        vector.setElementAt(e, n5);
        e = this.trapList.elementAt(n);
        this.trapList.setElementAt(this.trapList.elementAt(n5), n);
        this.trapList.setElementAt(e, n5);
        e = this.trapColors.elementAt(n);
        this.trapColors.setElementAt(this.trapColors.elementAt(n5), n);
        this.trapColors.setElementAt(e, n5);
        return n5;
    }

    private void qsort(int n, int n2, int n3) {
        if (n < n2) {
            int n4 = this.partition(n, n2, n3);
            this.qsort(n, n4 - 1, n3);
            this.qsort(n4 + 1, n2, n3);
        }
    }

    public void setModel(TableModel tableModel) {
        super.setModel(tableModel);
    }

    public void setValueAt(Object object, int n, int n2) {
        this.model.setValueAt(object, n, n2);
    }

    public void sort(Object object) {
        int n = (Integer)this.sortingColumns.elementAt(0);
        this.qsort(0, this.model.getRowCount() - 1, n);
    }

    public void sortByColumn(int n) {
        this.sortByColumn(n, true);
    }

    public void sortByColumn(int n, boolean bl) {
        this.ascending = bl;
        this.sortingColumns.removeAllElements();
        this.sortingColumns.addElement(new Integer(n));
        this.sort(this);
        super.tableChanged(new TableModelEvent(this));
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
    }
}

