/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.ui.Utils;
import com.adventnet.utils.SnmpUIUtils;
import com.adventnet.utils.SnmpUtils;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.util.StringTokenizer;
import javax.swing.text.Document;

class TextPrinter
extends Thread {
    Graphics m_pg;
    PrintJob m_prnJob;
    Document m_doc;
    Font plainFont;
    static final int BUFFER_SIZE = 4096;
    static final int MAX_CHARS = 100;
    static final int TAB_SIZE_PIXELS = 90;

    public TextPrinter(Graphics graphics, PrintJob printJob, Document document) {
        this.setPriority(10);
        this.plainFont = SnmpUIUtils.getFont();
        new Font("SansSerif", 0, 12);
        this.m_pg = graphics;
        this.m_prnJob = printJob;
        this.m_doc = document;
        this.m_pg.setFont(this.plainFont);
    }

    protected static void drawTabbedString(Graphics graphics, FontMetrics fontMetrics, String string, int n, int n2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            graphics.drawString(string2, n, n2);
            n += fontMetrics.stringWidth(string2);
            n = (n / 90 + 1) * 90;
        }
    }

    public void run() {
        try {
            Thread.sleep(100L);
            Dimension dimension = this.m_prnJob.getPageDimension();
            int n = dimension.height;
            FontMetrics fontMetrics = this.m_pg.getFontMetrics();
            int n2 = fontMetrics.getHeight();
            int n3 = 0;
            int n4 = n2;
            boolean bl = false;
            String string = "";
            int n5 = 0;
            int n6 = this.m_doc.getLength();
            block2: do {
                String string2 = this.m_doc.getText(n5, Math.min(n6, 4096));
                int n7 = string2.length();
                n5 += n7;
                n6 -= n7;
                bl = n7 < 4096;
                string2 = String.valueOf(string) + string2;
                while (true) {
                    int n8 = string2.indexOf(10);
                    if ((n8 = Math.min(n8, 100)) < 0) {
                        string = string2;
                        if (!bl) continue block2;
                        TextPrinter.drawTabbedString(this.m_pg, fontMetrics, string, n3, n4);
                        n4 += n2;
                        continue block2;
                    }
                    String string3 = string2.substring(0, n8);
                    string2 = string2.substring(n8 + 1);
                    TextPrinter.drawTabbedString(this.m_pg, fontMetrics, string3, n3, n4);
                    if ((n4 += n2) < n - 2 * n2) continue;
                    this.m_pg.dispose();
                    this.m_pg = this.m_prnJob.getGraphics();
                    this.m_pg.setFont(this.plainFont);
                    n4 = n2;
                }
            } while (!bl);
            this.m_pg.dispose();
            this.m_prnJob.end();
        }
        catch (Exception exception) {
            Utils.err(String.valueOf(SnmpUtils.getString("Print error: ")) + " " + exception.getMessage());
        }
    }
}

