/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class ToolBar
extends JPanel
implements MouseListener,
FocusListener {
    private JToolBar toolBar = new JToolBar();
    private boolean borderPaintedFlag = true;
    Vector components = new Vector();

    public ToolBar() {
        JLabel jLabel = new JLabel();
        this.toolBar.setFloatable(false);
        this.toolBar.setBorderPainted(false);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.toolBar, gridBagConstraints);
        this.add(this.toolBar);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 100, 0);
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
    }

    public ToolBar(boolean bl) {
        this();
        this.borderPaintedFlag = bl;
    }

    public JButton addButton(String string, ImageIcon imageIcon, String string2) {
        JButton jButton = (JButton)this.toolBar.add(new JButton(imageIcon));
        if (!this.borderPaintedFlag) {
            jButton.setBorderPainted(false);
        }
        jButton.setFocusPainted(false);
        jButton.setToolTipText(string2);
        jButton.setMargin(new Insets(0, 1, 0, 1));
        jButton.getAccessibleContext().setAccessibleName(string);
        jButton.setActionCommand(string);
        jButton.addMouseListener(this);
        jButton.addFocusListener(this);
        this.components.addElement(jButton);
        return jButton;
    }

    public JButton addButton(String string, ImageIcon imageIcon, ImageIcon imageIcon2, String string2) {
        JButton jButton = this.addButton(string, imageIcon, string2);
        jButton.setDisabledIcon(imageIcon2);
        this.components.addElement(jButton);
        return jButton;
    }

    public JButton addButton(JButton jButton) {
        JButton jButton2 = (JButton)this.toolBar.add(jButton);
        this.components.addElement(jButton2);
        return jButton2;
    }

    public JButton addButton(JButton jButton, int n) {
        JButton jButton2 = (JButton)this.toolBar.add((Component)jButton, n);
        this.components.addElement(jButton2);
        return jButton2;
    }

    public void addLineSeparator() {
        this.components.addElement(null);
        ToolBarSeparatorLine toolBarSeparatorLine = new ToolBarSeparatorLine(this.toolBar);
        this.toolBar.add(toolBarSeparatorLine);
    }

    public JRadioButton addRadioButton(String string, ImageIcon imageIcon, ImageIcon imageIcon2, String string2, boolean bl) {
        JRadioButton jRadioButton = (JRadioButton)this.toolBar.add(new JRadioButton(imageIcon, bl));
        jRadioButton.setSelectedIcon(imageIcon2);
        if (!this.borderPaintedFlag) {
            jRadioButton.setBorderPainted(false);
        }
        jRadioButton.setFocusPainted(false);
        jRadioButton.setToolTipText(string2);
        jRadioButton.setMargin(new Insets(0, 0, 0, 0));
        jRadioButton.getAccessibleContext().setAccessibleName(string);
        jRadioButton.setActionCommand(string);
        this.components.addElement(jRadioButton);
        return jRadioButton;
    }

    public void addSeparator() {
        this.toolBar.addSeparator();
    }

    public JToggleButton addToggleButton(String string, ImageIcon imageIcon, ImageIcon imageIcon2, String string2) {
        JToggleButton jToggleButton = (JToggleButton)this.toolBar.add(new JToggleButton());
        if (!this.borderPaintedFlag) {
            jToggleButton.setBorderPainted(false);
        }
        jToggleButton.setFocusPainted(false);
        jToggleButton.setIcon(imageIcon);
        jToggleButton.setSelectedIcon(imageIcon2);
        jToggleButton.setToolTipText(string2);
        jToggleButton.setMargin(new Insets(0, 1, 0, 1));
        jToggleButton.getAccessibleContext().setAccessibleName(string);
        jToggleButton.setActionCommand(string);
        jToggleButton.addMouseListener(this);
        jToggleButton.addFocusListener(this);
        this.components.addElement(jToggleButton);
        return jToggleButton;
    }

    private void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    public void focusGained(FocusEvent focusEvent) {
        AbstractButton abstractButton;
        if (this.borderPaintedFlag) {
            return;
        }
        Object object = focusEvent.getSource();
        if (object instanceof AbstractButton && (abstractButton = (AbstractButton)object).isEnabled()) {
            abstractButton.setBorderPainted(true);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.borderPaintedFlag) {
            return;
        }
        Object object = focusEvent.getSource();
        if (object instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)object;
            abstractButton.setBorderPainted(false);
        }
    }

    public Component getComponent(String string) {
        Component component = null;
        String string2 = "";
        int n = this.components.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = this.components.elementAt(n2);
            if (e != null) {
                string2 = ((JComponent)e).getToolTipText();
            }
            if (string2.equals(string)) {
                component = (Component)this.components.elementAt(n2);
                break;
            }
            ++n2;
        }
        return component;
    }

    public int getElementCount() {
        return this.components.size();
    }

    public Enumeration getElements() {
        return this.components.elements();
    }

    public ImageIcon getImageIcon(String string) {
        return new ImageIcon(this.getClass().getResource(String.valueOf(string)));
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        AbstractButton abstractButton;
        if (this.borderPaintedFlag) {
            return;
        }
        Object object = mouseEvent.getSource();
        if (object instanceof AbstractButton && (abstractButton = (AbstractButton)object).isEnabled()) {
            abstractButton.setBorderPainted(true);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.borderPaintedFlag) {
            return;
        }
        Object object = mouseEvent.getSource();
        if (object instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)object;
            abstractButton.setBorderPainted(false);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void remove(Component component) {
        int n;
        if (component != null && (n = this.toolBar.getComponentIndex(component)) != -1) {
            this.toolBar.remove(n);
            if (this.components.contains(component)) {
                this.components.removeElement(component);
            }
        }
    }

    public void removeComponentAt(int n) {
        this.toolBar.remove(this.toolBar.getComponentAtIndex(n));
        this.components.removeElementAt(n);
    }

    private class ToolBarSeparatorLine
    extends JPanel {
        private JToolBar tb;
        private int height;

        public ToolBarSeparatorLine(JToolBar jToolBar) {
            this.tb = jToolBar;
        }

        public void paint(Graphics graphics) {
            this.height = this.tb.getSize().height;
            graphics.setColor(Color.gray);
            graphics.drawLine(2, 0, 2, this.height - 4);
            graphics.setColor(Color.white);
            graphics.drawLine(3, 0, 3, this.height - 4);
        }
    }
}

