/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.beans.ParsedTrapEvent;
import com.adventnet.snmp.mibs.MibOperations;
import com.adventnet.snmp.snmp2.SnmpOID;
import com.adventnet.snmp.ui.BrowserDataModel;
import com.adventnet.snmp.ui.TableSorter;
import com.adventnet.snmp.ui.TrapViewer;
import com.adventnet.utils.SnmpUIUtils;
import com.adventnet.utils.SnmpUtils;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class TrapBrowser
extends JPanel
implements ActionListener {
    JTable table = null;
    private JPopupMenu menu = null;
    private JMenuItem delRow = null;
    private JMenuItem trapDetails = null;
    private JFrame frame = null;
    private ParsedTrapEvent tpEvt = null;
    private JTextArea porT;
    private JTextArea sevT;
    private JTextArea tmUpT;
    private JTextArea tmRecvT;
    private JTextArea sourceT;
    private JTextArea catT;
    private JTextArea domT;
    private JTextArea netT;
    private JTextArea nodT;
    private JTextArea entT;
    private JTextArea helpUT;
    private JTextArea nameT;
    private JTextArea specT;
    private JTextArea genT;
    private JTextArea textT;
    private JTextArea entprT;
    private JScrollPane porTp;
    private JScrollPane sevTp;
    private JScrollPane tmUpTp;
    private JScrollPane tmRecvTp;
    private JScrollPane sourceTp;
    private JScrollPane catTp;
    private JScrollPane nodTp;
    private JScrollPane entTp;
    private JScrollPane helpUTp;
    private JScrollPane nameTp;
    private JScrollPane specTp;
    private JScrollPane genTp;
    private JScrollPane entprTp;
    private BrowserDataModel dataModel = null;
    private TableSorter sorter = null;
    private Vector traps = null;
    private Vector colors = null;
    Applet applet = null;
    private boolean colourSingleColumn = false;
    private boolean columnSelectionDone = false;
    private int selectedColumn = 0;
    private MibOperations mibOps;
    Font lfont = SnmpUIUtils.getFont();
    boolean b = false;
    private String[] columnNames = new String[]{SnmpUtils.getString("Class"), SnmpUtils.getString("Source"), SnmpUtils.getString("Date"), SnmpUtils.getString("Message")};

    public TrapBrowser() {
        this((Applet)null);
    }

    public TrapBrowser(Applet applet) {
        this.applet = applet;
        this.init();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Delete"))) {
            this.deleteTrap();
        } else if (actionEvent.getActionCommand().equals(SnmpUtils.getString("Trap Details"))) {
            this.getTrapDetails();
        }
    }

    public void addRow(Object[] objectArray, Image[] imageArray, Color color) {
        this.addRow(objectArray, imageArray, color, null);
    }

    public void addRow(Object[] objectArray, Image[] imageArray, Color color, ParsedTrapEvent parsedTrapEvent) {
        if (this.columnNames == null) {
            return;
        }
        this.traps.addElement(parsedTrapEvent);
        if (color != null) {
            this.colors.addElement(color);
        } else {
            this.colors.addElement(Color.white);
        }
        this.sorter.addRow(objectArray, imageArray, color);
        int n = 0;
        while (n < this.table.getColumnCount()) {
            this.table.setDefaultRenderer(this.table.getColumnClass(n), new TableCell());
            ++n;
        }
        this.table.revalidate();
        this.table.sizeColumnsToFit(-1);
        this.delRow.setEnabled(true);
        this.trapDetails.setEnabled(true);
        Object object = new Object();
        if (this.getParent() instanceof TrapViewer) {
            ((TrapViewer)this.getParent()).actionPerformed(new ActionEvent(object, 200, "EnableDeleteButtons"));
            ((TrapViewer)this.getParent()).actionPerformed(new ActionEvent(object, 201, "EnableDetailsButtons"));
        }
    }

    private void addToGBLayout(GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, JComponent jComponent, JComponent jComponent2, JPanel jPanel) {
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 2.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 0, 0, 5);
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        jPanel.add(jComponent);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        gridBagLayout.setConstraints(jComponent2, gridBagConstraints);
        jPanel.add(jComponent2);
    }

    public void deleteTrap() {
        int[] nArray = this.table.getSelectedRows();
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == 0) {
                this.b = true;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < nArray.length) {
            this.sorter.deleteRow(nArray[n3] - n);
            this.traps.removeElementAt(nArray[n3] - n);
            this.colors.removeElementAt(nArray[n3] - n);
            ++n;
            int n4 = 0;
            while (n4 < this.table.getColumnCount()) {
                this.table.setDefaultRenderer(this.table.getColumnClass(n4), new TableCell());
                ++n4;
            }
            this.table.revalidate();
            this.table.sizeColumnsToFit(-1);
            ++n3;
        }
        this.table.clearSelection();
        if (this.b) {
            this.table.getSelectionModel().addSelectionInterval(0, 0);
            this.b = false;
        } else {
            this.table.getSelectionModel().addSelectionInterval(nArray[0] - 1, nArray[0] - 1);
        }
        if (this.table.getSelectedRowCount() == 1) {
            Object object = new Object();
            if (this.getParent() instanceof TrapViewer) {
                ((TrapViewer)this.getParent()).actionPerformed(new ActionEvent(object, 301, "EnableDetailsButton"));
            }
        }
        if (this.table.getRowCount() == 0) {
            this.delRow.setEnabled(false);
            this.trapDetails.setEnabled(false);
            Object object = new Object();
            if (this.getParent() instanceof TrapViewer) {
                ((TrapViewer)this.getParent()).actionPerformed(new ActionEvent(object, 200, "DisableTrapButtons"));
            }
        }
    }

    public void displayEvent(ParsedTrapEvent parsedTrapEvent) {
        if (this.columnNames == null) {
            return;
        }
        Object[] objectArray = new Object[this.columnNames.length];
        try {
            objectArray[0] = new String(parsedTrapEvent.getStr("severity"));
            objectArray[1] = new String(parsedTrapEvent.getStr("source"));
            objectArray[2] = new String(parsedTrapEvent.getStr("timeReceived"));
            objectArray[3] = new String(parsedTrapEvent.getStr("text"));
            if (this.mibOps != null) {
                StringTokenizer stringTokenizer = new StringTokenizer((String)objectArray[3], ":");
                String string = "";
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (string2.indexOf(".1.3.") == 0) {
                        SnmpOID snmpOID = new SnmpOID(string2);
                        string = String.valueOf(string) + " " + this.mibOps.toString(snmpOID) + ": " + string2 + ": ";
                    } else {
                        string = String.valueOf(string) + string2;
                    }
                    objectArray[3] = string;
                    parsedTrapEvent.text = string;
                }
            }
        }
        catch (Exception exception) {}
        this.addRow(objectArray, null, parsedTrapEvent.getColor(), parsedTrapEvent);
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public boolean getShowSeverityColumnColor() {
        return this.colourSingleColumn;
    }

    public void getTrapDetails() {
        int n = this.table.getSelectedRow();
        if (n == -1) {
            return;
        }
        if (!this.traps.isEmpty() && this.table.getSelectedRows() != null && this.table.isRowSelected(this.table.getSelectedRow())) {
            this.tpEvt = (ParsedTrapEvent)this.traps.elementAt(n);
            if (this.tpEvt == null) {
                return;
            }
        } else {
            return;
        }
        if (this.frame == null) {
            this.frame = new JFrame(SnmpUtils.getString("Trap Details"));
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(Color.white, Color.gray), ""));
            JLabel jLabel = new JLabel(SnmpUtils.getString("RemotePort"));
            jLabel.setFont(this.lfont);
            jLabel.setForeground(Color.black);
            this.porT = new JTextArea(this.tpEvt.getStr("remoteport"));
            this.porT.setEditable(false);
            JLabel jLabel2 = new JLabel(SnmpUtils.getString("Severity"));
            jLabel2.setFont(this.lfont);
            jLabel2.setForeground(Color.black);
            this.sevT = new JTextArea(this.tpEvt.getStr("severity"));
            this.sevT.setEditable(false);
            JLabel jLabel3 = new JLabel(SnmpUtils.getString("TimeReceived"));
            jLabel3.setFont(this.lfont);
            jLabel3.setForeground(Color.black);
            this.tmRecvT = new JTextArea(String.valueOf(this.tpEvt.getStr("timeReceived")));
            this.tmRecvT.setEditable(false);
            JLabel jLabel4 = new JLabel(SnmpUtils.getString("TimeStamp"));
            jLabel4.setFont(this.lfont);
            jLabel4.setForeground(Color.black);
            this.tmUpT = new JTextArea(String.valueOf(this.tpEvt.getStr("timeStamp")));
            this.tmUpT.setEditable(false);
            JLabel jLabel5 = new JLabel(SnmpUtils.getString("Source"));
            jLabel5.setFont(this.lfont);
            jLabel5.setForeground(Color.black);
            this.sourceT = new JTextArea(this.tpEvt.getStr("source"));
            this.sourceT.setEditable(false);
            JLabel jLabel6 = new JLabel(SnmpUtils.getString("Community"));
            jLabel6.setFont(this.lfont);
            jLabel6.setForeground(Color.black);
            this.catT = new JTextArea(this.tpEvt.getStr("category"));
            this.catT.setEditable(false);
            JLabel jLabel7 = new JLabel(SnmpUtils.getString("Node"));
            jLabel7.setFont(this.lfont);
            jLabel7.setForeground(Color.black);
            this.nodT = new JTextArea(this.tpEvt.getStr("node"));
            this.nodT.setEditable(false);
            JLabel jLabel8 = new JLabel(SnmpUtils.getString("Name"));
            jLabel8.setFont(this.lfont);
            jLabel8.setForeground(Color.black);
            this.nameT = new JTextArea(this.tpEvt.getStr("name"));
            this.nameT.setEditable(false);
            JLabel jLabel9 = new JLabel(SnmpUtils.getString("Specific Type"));
            jLabel9.setFont(this.lfont);
            jLabel9.setForeground(Color.black);
            this.specT = new JTextArea(this.tpEvt.getStr("ST"));
            this.specT.setEditable(false);
            JLabel jLabel10 = new JLabel(SnmpUtils.getString("Generic Type"));
            jLabel10.setFont(this.lfont);
            jLabel10.setForeground(Color.black);
            this.genT = new JTextArea(this.tpEvt.getStr("GT"));
            this.genT.setEditable(false);
            JLabel jLabel11 = new JLabel(SnmpUtils.getString("Message"));
            jLabel11.setFont(this.lfont);
            jLabel11.setForeground(Color.black);
            this.textT = new JTextArea(this.tpEvt.getStr("text"));
            this.textT.setEditable(false);
            this.textT.setLineWrap(true);
            JLabel jLabel12 = new JLabel(SnmpUtils.getString("Enterprise"));
            jLabel12.setFont(this.lfont);
            jLabel12.setForeground(Color.black);
            this.entprT = new JTextArea(this.tpEvt.getStr("enterprise"));
            this.entprT.setEditable(false);
            JLabel jLabel13 = new JLabel(SnmpUtils.getString("Entity"));
            jLabel13.setFont(this.lfont);
            jLabel13.setForeground(Color.black);
            this.entT = new JTextArea(this.tpEvt.getStr("entity"));
            this.entT.setEditable(false);
            JLabel jLabel14 = new JLabel(SnmpUtils.getString("HelpURL"));
            jLabel14.setFont(this.lfont);
            jLabel14.setForeground(Color.black);
            this.helpUT = new JTextArea(this.tpEvt.getStr("helpURL"));
            this.helpUT.setEditable(false);
            this.porTp = new JScrollPane(this.porT);
            this.sevTp = new JScrollPane(this.sevT);
            this.tmUpTp = new JScrollPane(this.tmUpT);
            this.tmRecvTp = new JScrollPane(this.tmRecvT);
            this.sourceTp = new JScrollPane(this.sourceT);
            this.catTp = new JScrollPane(this.catT);
            this.nodTp = new JScrollPane(this.nodT);
            this.entTp = new JScrollPane(this.entT);
            this.helpUTp = new JScrollPane(this.helpUT);
            this.nameTp = new JScrollPane(this.nameT);
            this.specTp = new JScrollPane(this.specT);
            this.genTp = new JScrollPane(this.genT);
            this.entprTp = new JScrollPane(this.entprT);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel.setLayout(gridBagLayout);
            this.addToGBLayout(gridBagLayout, gridBagConstraints, jLabel4, this.tmUpTp, jPanel);
            this.addToGBLayout(gridBagLayout, gridBagConstraints, jLabel12, this.entprTp, jPanel);
            this.addToGBLayout(gridBagLayout, gridBagConstraints, jLabel10, this.genTp, jPanel);
            this.addToGBLayout(gridBagLayout, gridBagConstraints, jLabel9, this.specTp, jPanel);
            this.addToGBLayout(gridBagLayout, gridBagConstraints, jLabel11, this.textT, jPanel);
            this.addToGBLayout(gridBagLayout, gridBagConstraints, jLabel2, this.sevTp, jPanel);
            this.addToGBLayout(gridBagLayout, gridBagConstraints, jLabel13, this.entTp, jPanel);
            this.addToGBLayout(gridBagLayout, gridBagConstraints, jLabel, this.porTp, jPanel);
            this.addToGBLayout(gridBagLayout, gridBagConstraints, jLabel6, this.catTp, jPanel);
            this.addToGBLayout(gridBagLayout, gridBagConstraints, jLabel7, this.nodTp, jPanel);
            this.addToGBLayout(gridBagLayout, gridBagConstraints, jLabel5, this.sourceTp, jPanel);
            this.addToGBLayout(gridBagLayout, gridBagConstraints, jLabel3, this.tmRecvTp, jPanel);
            this.addToGBLayout(gridBagLayout, gridBagConstraints, jLabel14, this.helpUTp, jPanel);
            this.frame.getContentPane().add(new JScrollPane(jPanel));
            ((Component)this.frame).setSize(400, 450);
            ((Component)this.frame).setVisible(true);
        } else {
            this.updatePanel();
        }
    }

    public void init() {
        this.removeAll();
        this.traps = new Vector();
        this.colors = new Vector();
        this.dataModel = new BrowserDataModel(this);
        this.dataModel.setColumnNames(this.columnNames);
        this.sorter = new TableSorter(this.dataModel, this.traps, this.colors);
        this.table = new JTable(this.sorter);
        this.sorter.addMouseListenerToHeaderInTable(this.table);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        this.add(jScrollPane);
        this.menu = new JPopupMenu();
        this.delRow = new JMenuItem(SnmpUtils.getString("Delete the Selected Rows"));
        this.trapDetails = new JMenuItem(SnmpUtils.getString("View Trap Details"));
        this.delRow.setActionCommand(SnmpUtils.getString("Delete"));
        this.delRow.addActionListener(this);
        this.delRow.setEnabled(false);
        this.trapDetails.setActionCommand(SnmpUtils.getString("Trap Details"));
        this.trapDetails.addActionListener(this);
        this.trapDetails.setEnabled(false);
        this.menu.add(this.delRow);
        this.menu.add(this.trapDetails);
        this.table.addMouseListener(new detailsListener(this));
        this.addMouseListener(new detailsListener(this));
        int n = 0;
        while (n < this.table.getColumnCount()) {
            if (this.table.getColumnModel().getColumn(n).getHeaderRenderer() != null) {
                ((DefaultTableCellRenderer)this.table.getColumnModel().getColumn(n).getHeaderRenderer()).setToolTipText(SnmpUtils.getString("Click here to sort column"));
            }
            ++n;
        }
        this.table.setSelectionBackground(Color.pink);
        this.table.getSelectionModel().addSelectionInterval(0, 0);
    }

    public void loadMibs(String string) {
        try {
            if (this.mibOps == null) {
                this.mibOps = new MibOperations();
            }
            this.mibOps.loadMibModules(string);
        }
        catch (Exception exception) {
            System.out.println(SnmpUtils.getString("Exception occured while loading the mibs:"));
        }
    }

    public void setColumnNames(String[] stringArray) {
        this.columnNames = stringArray;
        this.init();
    }

    public void setShowSeverityColumnColor(boolean bl) {
        this.colourSingleColumn = bl;
        if (bl) {
            this.columnSelectionDone = false;
        }
    }

    private void updatePanel() {
        this.porT.setText(this.tpEvt.getStr("remoteport"));
        this.entprT.setText(this.tpEvt.getStr("enterprise"));
        this.sevT.setText(this.tpEvt.getStr("severity"));
        this.tmUpT.setText(String.valueOf(this.tpEvt.getStr("timeStamp")));
        this.tmRecvT.setText(String.valueOf(this.tpEvt.getStr("timeReceived")));
        this.sourceT.setText(this.tpEvt.getStr("source"));
        this.catT.setText(this.tpEvt.getStr("category"));
        this.nodT.setText(this.tpEvt.getStr("node"));
        this.entT.setText(this.tpEvt.getStr("entity"));
        this.helpUT.setText(this.tpEvt.getStr("helpURL"));
        this.specT.setText(this.tpEvt.getStr("ST"));
        this.genT.setText(this.tpEvt.getStr("GT"));
        this.textT.setText(this.tpEvt.getStr("text"));
        this.nameT.setText(this.tpEvt.getStr("name"));
        ((Component)this.frame).setVisible(true);
        this.validate();
    }

    class TableCell
    implements TableCellRenderer {
        TableCell() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                object = "";
            }
            JLabel jLabel = new JLabel(object.toString());
            jLabel.setHorizontalAlignment(0);
            jLabel.setOpaque(true);
            if (bl) {
                jLabel.setBackground(jTable.getSelectionBackground());
            } else if (TrapBrowser.this.colourSingleColumn) {
                if (TrapBrowser.this.columnSelectionDone) {
                    if (jTable.convertColumnIndexToModel(n2) == TrapBrowser.this.selectedColumn) {
                        jLabel.setBackground((Color)TrapBrowser.this.colors.elementAt(n));
                    } else {
                        jLabel.setBackground(Color.white);
                    }
                } else {
                    String[] stringArray = new String[]{SnmpUtils.getString("Critical"), SnmpUtils.getString("Major"), SnmpUtils.getString("Clear"), SnmpUtils.getString("Minor"), SnmpUtils.getString("Warning"), SnmpUtils.getString("All"), SnmpUtils.getString("Clear"), SnmpUtils.getString("Info")};
                    Vector vector = TrapBrowser.this.dataModel.getTableDataVec();
                    Object[] objectArray = (Object[])vector.elementAt(0);
                    int n3 = 0;
                    while (n3 < objectArray.length) {
                        int n4 = 0;
                        while (n4 < stringArray.length) {
                            if (((String)objectArray[n3]).equals(stringArray[n4])) {
                                TrapBrowser.this.selectedColumn = n3;
                                TrapBrowser.this.columnSelectionDone = true;
                                break;
                            }
                            ++n4;
                        }
                        if (TrapBrowser.this.columnSelectionDone) {
                            if (jTable.convertColumnIndexToModel(n2) == TrapBrowser.this.selectedColumn) {
                                jLabel.setBackground((Color)TrapBrowser.this.colors.elementAt(n));
                            } else {
                                jLabel.setBackground(Color.white);
                            }
                            break;
                        }
                        jLabel.setBackground(Color.white);
                        ++n3;
                    }
                }
            } else {
                jLabel.setBackground((Color)TrapBrowser.this.colors.elementAt(n));
            }
            return jLabel;
        }
    }

    class detailsListener
    extends MouseAdapter {
        TrapBrowser trapbr;
        ParsedTrapEvent tpEvt = null;
        JTextArea porT;
        JTextArea sevT;
        JTextArea tmUpT;
        JTextArea tmRecvT;
        JTextArea sourceT;
        JTextArea catT;
        JTextArea domT;
        JTextArea netT;
        JTextArea nodT;
        JTextArea entT;
        JTextArea helpUT;
        JTextArea nameT;
        JTextArea specT;
        JTextArea genT;
        JTextArea textT;
        JTextArea entprT;
        JScrollPane porTp;
        JScrollPane sevTp;
        JScrollPane tmUpTp;
        JScrollPane tmRecvTp;
        JScrollPane sourceTp;
        JScrollPane catTp;
        JScrollPane nodTp;
        JScrollPane entTp;
        JScrollPane helpUTp;
        JScrollPane nameTp;
        JScrollPane specTp;
        JScrollPane genTp;
        JScrollPane entprTp;

        detailsListener(TrapBrowser trapBrowser2) {
            this.trapbr = trapBrowser2;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (TrapBrowser.this.table.getRowCount() == 0) {
                return;
            }
            int n = this.trapbr.table.getSelectedRowCount();
            boolean bl = false;
            if (n > 0 && TrapBrowser.this.traps.elementAt(this.trapbr.table.getSelectedRow()) != null) {
                bl = true;
            }
            if (this.trapbr.getParent() instanceof TrapViewer) {
                TrapViewer trapViewer = (TrapViewer)this.trapbr.getParent();
                Object object = new Object();
                trapViewer.actionPerformed(new ActionEvent(object, 200, "DisableTrapButtons"));
                if (n > 0) {
                    trapViewer.actionPerformed(new ActionEvent(object, 300, "EnableDeleteButton"));
                    if (n == 1 && bl) {
                        trapViewer.actionPerformed(new ActionEvent(object, 301, "EnableDetailsButton"));
                    }
                }
            }
            if (mouseEvent.getModifiers() == 8 || mouseEvent.getModifiers() == 4) {
                this.trapbr.delRow.setEnabled(false);
                this.trapbr.trapDetails.setEnabled(false);
                if (n > 0) {
                    this.trapbr.delRow.setEnabled(true);
                    if (n == 1 && bl) {
                        this.trapbr.trapDetails.setEnabled(true);
                    }
                }
                this.trapbr.menu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                return;
            }
        }
    }
}

