/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.beans.ParsedTrapEvent;
import com.adventnet.snmp.beans.Parsers;
import com.adventnet.snmp.beans.TrapEvent;
import com.adventnet.snmp.mibs.MibOperations;
import com.adventnet.snmp.snmp2.SnmpPDU;
import com.adventnet.snmp.ui.TrapParserBean;
import com.adventnet.utils.SnmpUtils;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

class TrapParser {
    TrapParserBean ti = null;
    String name = "New Trap Parser";
    String enterprise = "";
    int GT = 6;
    int ST = 0;
    int severity = 6;
    String color = "-1";
    String textDefn = "$*";
    String entityDefn = "$Source";
    String categoryDefn = "$Community";
    String domainDefn = "";
    String networkDefn = "";
    String nodeDefn = "$Source";
    String sourceDefn = "$Source";
    String helpDefn = "$GenericType-$SpecificType.html";
    String customOIDDefn = "";
    String agentDefn = "";
    Properties trapParserProperties;
    long d;
    long dE;
    long last = new Date().getTime();
    int count = 0;
    long totalTime = 0L;

    public TrapParser() {
        this.trapParserProperties = new Properties();
    }

    public String getCategory() {
        return (String)((Hashtable)this.trapParserProperties).get("categoryDefn");
    }

    public String getColor() {
        return (String)((Hashtable)this.trapParserProperties).get("color");
    }

    public String getDomain() {
        return (String)((Hashtable)this.trapParserProperties).get("domainDefn");
    }

    public String getEnterpriseOID() {
        return (String)((Hashtable)this.trapParserProperties).get("enterprise");
    }

    public String getFailureObject() {
        return (String)((Hashtable)this.trapParserProperties).get("entityDefn");
    }

    public String getGenericType() {
        return (String)((Hashtable)this.trapParserProperties).get("GT");
    }

    public String getHelpURL() {
        return (String)((Hashtable)this.trapParserProperties).get("helpDefn");
    }

    public String getMessage() {
        return (String)((Hashtable)this.trapParserProperties).get("textDefn");
    }

    public String getNetwork() {
        return (String)((Hashtable)this.trapParserProperties).get("networkDefn");
    }

    public String getNode() {
        return (String)((Hashtable)this.trapParserProperties).get("nodeDefn");
    }

    public String getParserName() {
        return (String)((Hashtable)this.trapParserProperties).get("name");
    }

    public String getSeverity() {
        return (String)((Hashtable)this.trapParserProperties).get("severity");
    }

    public String getSource() {
        return (String)((Hashtable)this.trapParserProperties).get("sourceDefn");
    }

    public String getSpecificType() {
        return (String)((Hashtable)this.trapParserProperties).get("ST");
    }

    public ParsedTrapEvent parseTrap(MibOperations mibOperations, ParsedTrapEvent parsedTrapEvent, SnmpPDU snmpPDU) {
        String string;
        parsedTrapEvent.severity = this.severity;
        parsedTrapEvent.text = Parsers.parseTrapDefn(mibOperations, this.textDefn, snmpPDU);
        parsedTrapEvent.entity = !this.entityDefn.trim().equals("$Source") && !TrapParserBean.fileName.equals("") ? Parsers.parseTrapDefn(mibOperations, this.entityDefn, snmpPDU).trim() : ((string = ((TrapEvent)parsedTrapEvent.getSource()).getAgentAddress()) == null ? Parsers.source : string);
        parsedTrapEvent.category = !this.categoryDefn.equals("$Source") ? Parsers.parseTrapDefn(mibOperations, this.categoryDefn, snmpPDU) : Parsers.source;
        parsedTrapEvent.domain = !this.domainDefn.trim().equals("$Source") ? Parsers.parseTrapDefn(mibOperations, this.domainDefn, snmpPDU) : Parsers.source;
        parsedTrapEvent.network = !this.networkDefn.trim().equals("$Source") ? Parsers.parseTrapDefn(mibOperations, this.networkDefn, snmpPDU).trim() : Parsers.source;
        parsedTrapEvent.node = !this.nodeDefn.trim().equals("$Source") ? Parsers.parseTrapDefn(mibOperations, this.nodeDefn, snmpPDU).trim() : Parsers.source;
        parsedTrapEvent.source = !this.sourceDefn.trim().equals("$Source") ? Parsers.parseTrapDefn(mibOperations, this.sourceDefn, snmpPDU).toLowerCase().trim() : Parsers.source;
        parsedTrapEvent.helpURL = !this.helpDefn.trim().equals("$Source") ? Parsers.parseTrapDefn(mibOperations, this.helpDefn, snmpPDU) : Parsers.source;
        return parsedTrapEvent;
    }

    public void setCategory(String string) {
        if (!(string = string.trim()).equals("") && !string.equalsIgnoreCase("null")) {
            ((Hashtable)this.trapParserProperties).put("categoryDefn", string);
        }
    }

    public void setColor(String string) {
        if (!(string = string.trim()).equals("") && !string.equalsIgnoreCase("null")) {
            ((Hashtable)this.trapParserProperties).put("color", string);
        }
    }

    public void setDomain(String string) {
        if (!(string = string.trim()).equals("") && !string.equalsIgnoreCase("null")) {
            ((Hashtable)this.trapParserProperties).put("domainDefn", string);
        }
    }

    public void setEnterpriseOID(String string) {
        if (!(string = string.trim()).equals("") && !string.equalsIgnoreCase("null")) {
            ((Hashtable)this.trapParserProperties).put("enterprise", string);
        }
    }

    public void setFailureObject(String string) {
        if (!(string = string.trim()).equals("") && !string.equalsIgnoreCase("null")) {
            ((Hashtable)this.trapParserProperties).put("entityDefn", string);
        }
    }

    public void setGenericType(String string) {
        if (!(string = string.trim()).equals("") && !string.equalsIgnoreCase("null")) {
            ((Hashtable)this.trapParserProperties).put("GT", string);
        }
    }

    public void setHelpURL(String string) {
        if (!(string = string.trim()).equals("") && !string.equalsIgnoreCase("null")) {
            ((Hashtable)this.trapParserProperties).put("helpDefn", string);
        }
    }

    public void setMessage(String string) {
        if (!(string = string.trim()).equals("") && !string.equalsIgnoreCase("null")) {
            ((Hashtable)this.trapParserProperties).put("textDefn", string);
        }
    }

    public void setNetwork(String string) {
        if (!(string = string.trim()).equals("") && !string.equalsIgnoreCase("null")) {
            ((Hashtable)this.trapParserProperties).put("networkDefn", string);
        }
    }

    public void setNode(String string) {
        if (!(string = string.trim()).equals("") && !string.equalsIgnoreCase("null")) {
            ((Hashtable)this.trapParserProperties).put("nodeDefn", string);
        }
    }

    public void setParserName(String string) {
        if (!(string = string.trim()).equals("") && !string.equalsIgnoreCase("null")) {
            ((Hashtable)this.trapParserProperties).put("name", string);
        }
    }

    public void setProperties(Properties properties, Vector vector) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            try {
                String string = (String)enumeration.nextElement();
                String string2 = (String)((Hashtable)properties).get(string);
                if (string.equals("name")) {
                    this.name = string2;
                    vector.addElement(string2);
                    continue;
                }
                if (string.equals("enterprise")) {
                    this.enterprise = string2;
                    continue;
                }
                if (string.equals("GT")) {
                    try {
                        this.GT = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.GT = -1;
                    }
                    continue;
                }
                if (string.equals("ST")) {
                    try {
                        this.ST = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.ST = 0;
                    }
                    continue;
                }
                if (string.equals("severity")) {
                    try {
                        this.severity = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.severity = 6;
                    }
                    continue;
                }
                if (string.equals("textDefn")) {
                    this.textDefn = string2;
                    continue;
                }
                if (string.equals("entityDefn")) {
                    this.entityDefn = string2;
                    continue;
                }
                if (string.equals("categoryDefn")) {
                    this.categoryDefn = string2;
                    continue;
                }
                if (string.equals("domainDefn")) {
                    this.domainDefn = string2;
                    continue;
                }
                if (string.equals("networkDefn")) {
                    this.networkDefn = string2;
                    continue;
                }
                if (string.equals("nodeDefn")) {
                    this.nodeDefn = string2;
                    continue;
                }
                if (string.equals("sourceDefn")) {
                    this.sourceDefn = string2;
                    continue;
                }
                if (string.equals("helpDefn")) {
                    this.helpDefn = string2;
                    continue;
                }
                if (string.equals("customMatchDefn")) {
                    this.customOIDDefn = string2;
                    continue;
                }
                if (string.equals("agentAddressDefn")) {
                    this.agentDefn = string2;
                    continue;
                }
                if (!string.equals("color")) continue;
                this.color = string2;
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println(String.valueOf(SnmpUtils.getString("Invalid value for trap parser definition:")) + " " + numberFormatException);
            }
        }
    }

    public void setSeverity(String string) {
        if (!(string = string.trim()).equals("") && !string.equalsIgnoreCase("null")) {
            ((Hashtable)this.trapParserProperties).put("severity", string);
        }
    }

    public void setSource(String string) {
        if (!(string = string.trim()).equals("") && !string.equalsIgnoreCase("null")) {
            ((Hashtable)this.trapParserProperties).put("sourceDefn", string);
        }
    }

    public void setSpecificType(String string) {
        if (!(string = string.trim()).equals("") && !string.equalsIgnoreCase("null")) {
            ((Hashtable)this.trapParserProperties).put("ST", string);
        }
    }

    public void setValues() {
        if (this.ti.trapParsers.size() != 0) {
            int n = 0;
            while (n < this.ti.trapParsers.size()) {
                TrapParser trapParser = (TrapParser)this.ti.trapParsers.elementAt(n);
                if (trapParser.GT == this.GT && trapParser.ST == this.ST && trapParser.enterprise.equals(this.enterprise) && trapParser.customOIDDefn.equals(this.customOIDDefn) && trapParser.agentDefn.equals(this.agentDefn)) {
                    this.ti.trapParsers.removeElement(trapParser);
                }
                ++n;
            }
        }
        this.ti.trapParsers.addElement(this);
    }

    public String toString() {
        return this.getParserName();
    }
}

