/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.beans.ParsedTrapEvent;
import com.adventnet.snmp.beans.Parsers;
import com.adventnet.snmp.beans.SnmpTrapReceiver;
import com.adventnet.snmp.beans.TrapEvent;
import com.adventnet.snmp.beans.TrapParserListener;
import com.adventnet.snmp.mibs.MibModule;
import com.adventnet.snmp.mibs.MibNode;
import com.adventnet.snmp.mibs.MibOperations;
import com.adventnet.snmp.mibs.MibTrap;
import com.adventnet.snmp.snmp2.SASClient;
import com.adventnet.snmp.snmp2.SnmpAPI;
import com.adventnet.snmp.snmp2.SnmpPDU;
import com.adventnet.snmp.snmp2.SnmpVarBind;
import com.adventnet.snmp.ui.TrapParser;
import com.adventnet.utils.SnmpUtils;
import java.applet.Applet;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;

public class TrapParserBean {
    Applet applet = null;
    Vector trapParsers = new Vector();
    Vector eventListeners = new Vector();
    Vector parserNameVec = new Vector();
    Vector parserPropVec = new Vector();
    Properties currentParserVal = null;
    String currentName = "newParser";
    static String fileName = "";
    private int currentParserIndex = 0;
    private Vector editorVec = null;
    String enterprise = "";
    int GT = -1;
    int ST = 0;
    int severity = 6;
    String color = new String("-1");
    String textDefn = "$*";
    String entityDefn = "$Source";
    String categoryDefn = "$Community";
    String nodeDefn = "$Source";
    String sourceDefn = "$Source";
    String helpDefn = "$GenericType-$SpecificType.html";
    String domainDefn = "";
    String networkDefn = "";
    String customOIDDefn = "";
    String agentDefn = "";
    boolean loading = false;
    MibOperations mibOps = null;

    public TrapParserBean() {
        this(null);
    }

    public TrapParserBean(Applet applet) {
        this.applet = applet;
    }

    public synchronized void addParserListener(TrapParserListener trapParserListener) {
        this.eventListeners.addElement(trapParserListener);
    }

    private boolean compare(int[] nArray, int[] nArray2, int n) {
        int n2 = nArray.length;
        int n3 = nArray2.length;
        if (n2 < n || n3 < n) {
            return false;
        }
        int n4 = 0;
        while (n4 < n) {
            if (nArray[n4] == nArray2[n4++]) continue;
            return false;
        }
        return true;
    }

    TrapParser createParser(String string, MibNode mibNode) {
        if (mibNode == null) {
            return null;
        }
        TrapParser trapParser = new TrapParser();
        trapParser.setParserName(string);
        trapParser.setGenericType("6");
        int[] nArray = mibNode.getOID();
        int n = nArray.length - 1;
        if (nArray[nArray.length - 2] == 0) {
            n = nArray.length - 2;
        }
        String string2 = "";
        int n2 = 0;
        while (n2 < n) {
            string2 = String.valueOf(string2) + "." + nArray[n2];
            ++n2;
        }
        trapParser.setEnterpriseOID(string2);
        trapParser.setSpecificType(String.valueOf(nArray[nArray.length - 1]));
        if (mibNode.getDescription() != null) {
            if (trapParser.getMessage() != null) {
                trapParser.setMessage(String.valueOf(mibNode.getDescription()) + trapParser.getMessage());
            } else {
                trapParser.setMessage(mibNode.getDescription());
            }
        }
        return trapParser;
    }

    TrapParser createParser(String string, MibTrap mibTrap) {
        if (mibTrap == null) {
            return null;
        }
        TrapParser trapParser = new TrapParser();
        trapParser.setParserName(string);
        if (mibTrap.getEnterprise() != null) {
            trapParser.setEnterpriseOID(mibTrap.getEnterprise().toString());
        } else {
            trapParser.setEnterpriseOID(mibTrap.getEnterpriseString());
        }
        trapParser.setGenericType("6");
        trapParser.setSpecificType("0");
        String string2 = trapParser.getEnterpriseOID();
        if (string2 != null) {
            if (string2.equals("snmp") || string2.equals("11") || string2.equals(".1.3.6.1.2.1.11")) {
                trapParser.setGenericType(String.valueOf(mibTrap.getValue()));
            } else {
                trapParser.setSpecificType(String.valueOf(mibTrap.getValue()));
            }
        }
        if (trapParser.getMessage() != null) {
            trapParser.setMessage(String.valueOf(mibTrap.getDescription()) + "  " + trapParser.getMessage());
        } else {
            trapParser.setMessage(mibTrap.getDescription());
        }
        return trapParser;
    }

    protected void fileWrite(String string) {
        try {
            Object object;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("#\n#@(#)" + string + "\n#\n");
            stringBuffer.append("# This file was generated by AdventNet Snmp  \n#\n\n");
            int n = 0;
            while (n < this.parserPropVec.size()) {
                object = new ByteArrayOutputStream();
                ((Properties)this.parserPropVec.elementAt(n)).save((OutputStream)object, "");
                stringBuffer.append("\n{\n" + ((ByteArrayOutputStream)object).toString() + "}\n\n");
                ++n;
            }
            if (this.applet == null) {
                object = new DataOutputStream(new FileOutputStream(new File(string)));
                ((DataOutputStream)object).writeBytes(stringBuffer.toString());
                ((FilterOutputStream)object).close();
            } else {
                object = null;
                object = SnmpAPI.getSASClient();
                if (object == null) {
                    object = new SASClient(this.applet, true);
                }
                if (object != null) {
                    ((SASClient)object).saveFile(string, stringBuffer.toString().getBytes());
                } else {
                    this.loading = false;
                    JOptionPane.showMessageDialog(null, SnmpUtils.getString("SAS server not connected"), SnmpUtils.getString("Warning Message"), 1);
                    return;
                }
            }
            this.loading = true;
        }
        catch (Exception exception) {
            System.out.println(String.valueOf(SnmpUtils.getString("File Not found : ")) + " " + string);
            this.loading = false;
        }
    }

    private void fireEvent(ParsedTrapEvent parsedTrapEvent) {
        Vector vector;
        TrapParserBean trapParserBean = this;
        synchronized (trapParserBean) {
            if (this.eventListeners == null) {
                Object var4_4 = null;
                return;
            }
            vector = (Vector)this.eventListeners.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            TrapParserListener trapParserListener = (TrapParserListener)vector.elementAt(n);
            trapParserListener.eventParsed(parsedTrapEvent);
            ++n;
        }
    }

    private void formProperty(Properties properties) {
        ((Hashtable)properties).put("enterprise", this.enterprise);
        ((Hashtable)properties).put("GT", new Integer(this.GT).toString());
        ((Hashtable)properties).put("ST", new Integer(this.ST).toString());
        ((Hashtable)properties).put("severity", new Integer(this.severity).toString());
        ((Hashtable)properties).put("textDefn", this.textDefn);
        ((Hashtable)properties).put("entityDefn", this.entityDefn);
        ((Hashtable)properties).put("nodeDefn", this.nodeDefn);
        ((Hashtable)properties).put("name", this.currentName);
        ((Hashtable)properties).put("sourceDefn", this.sourceDefn);
        ((Hashtable)properties).put("networkDefn", this.networkDefn);
        ((Hashtable)properties).put("domainDefn", this.domainDefn);
        ((Hashtable)properties).put("helpDefn", this.helpDefn);
        ((Hashtable)properties).put("customMatchDefn", this.customOIDDefn);
        ((Hashtable)properties).put("agentAddressDefn", this.agentDefn);
        ((Hashtable)properties).put("color", new Integer(this.color).toString());
    }

    public String getCharacterEncoding() {
        return SnmpAPI.ENCODING;
    }

    public Object getEditParser() {
        try {
            if (this.editorVec != null) {
                this.editorVec.removeAllElements();
            }
            if (this.currentParserIndex >= this.parserPropVec.size()) {
                this.currentParserIndex = 0;
            }
            this.currentParserVal = (Properties)this.parserPropVec.elementAt(this.currentParserIndex);
            this.setProperties(this.currentParserVal);
            this.formProperty(this.currentParserVal);
            this.editorVec = new Vector();
            this.editorVec.addElement(fileName);
            this.editorVec.addElement(this.parserNameVec);
            this.editorVec.addElement(this.getParserContentsVec(this.currentParserVal));
            return this.editorVec;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return this.editorVec;
        }
    }

    public String getFileName() {
        return fileName;
    }

    public MibOperations getMibOperations() {
        return this.mibOps;
    }

    private Vector getParserContentsVec(Properties properties) {
        Vector<String> vector = new Vector<String>();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            try {
                String string = (String)enumeration.nextElement();
                String string2 = (String)((Hashtable)properties).get(string);
                if (string.equals("name")) {
                    vector.addElement("Name");
                } else if (string.equals("enterprise")) {
                    vector.addElement("Enterprise");
                } else if (string.equals("GT")) {
                    vector.addElement("Generic Type");
                } else if (string.equals("ST")) {
                    vector.addElement("Specific Type");
                } else if (string.equals("severity")) {
                    vector.addElement("Severity");
                } else if (string.equals("textDefn")) {
                    vector.addElement("TextDefn");
                } else if (string.equals("entityDefn")) {
                    vector.addElement("EntityDefn");
                } else if (string.equals("categoryDefn")) {
                    vector.addElement("CategoryDefn");
                } else if (string.equals("domainDefn")) {
                    vector.addElement("DomainDefn");
                } else if (string.equals("networkDefn")) {
                    vector.addElement("NetworkDefn");
                } else if (string.equals("nodeDefn")) {
                    vector.addElement("NodeDefn");
                } else if (string.equals("sourceDefn")) {
                    vector.addElement("SourceDefn");
                } else if (string.equals("helpDefn")) {
                    vector.addElement("HelpDefn");
                } else if (string.equals("customMatchDefn")) {
                    vector.addElement("CustomMatchDefn");
                } else if (string.equals("agentAddressDefn")) {
                    vector.addElement("AgentAddressDefn");
                } else if (string.equals("color")) {
                    vector.addElement("Color");
                }
                if (string2 == null) {
                    vector.addElement("");
                    continue;
                }
                vector.addElement(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println(String.valueOf(SnmpUtils.getString("Invalid value for trap parser definition:")) + " " + numberFormatException);
            }
        }
        return vector;
    }

    public String[] getParserName() {
        String[] stringArray = null;
        if (this.parserNameVec != null && this.parserNameVec.size() > 0) {
            stringArray = new String[this.parserNameVec.size()];
            int n = 0;
            while (n < this.parserNameVec.size()) {
                stringArray[n] = (String)this.parserNameVec.elementAt(n);
                ++n;
            }
        }
        return stringArray;
    }

    public void initJdbcParams(String string, String string2, String string3, String string4) {
        if (this.mibOps != null) {
            this.mibOps = new MibOperations();
        }
        try {
            this.mibOps.initJdbcParams(string, string2, string3, string4);
        }
        catch (Exception exception) {
            System.out.println(String.valueOf(SnmpUtils.getString("Error :")) + " " + exception);
        }
    }

    public boolean isLoadMibsFromDatabase() {
        return this.mibOps.isLoadFromDatabase();
    }

    public boolean isOverwriteMibsInDatabase() {
        return this.mibOps.isOverwriteDatabase();
    }

    public boolean isParserLoaded() {
        return this.loading;
    }

    public void loadDefinedTraps() {
        if (this.mibOps == null) {
            return;
        }
        try {
            Enumeration enumeration = this.mibOps.getMibModules();
            while (enumeration.hasMoreElements()) {
                MibModule mibModule = (MibModule)enumeration.nextElement();
                this.loadTrapsFromModule(mibModule);
            }
        }
        catch (Exception exception) {
            this.loading = false;
            System.out.println(String.valueOf(SnmpUtils.getString("Error Reading MIB File:")) + " " + exception);
        }
    }

    public boolean loadParsers(String string) {
        Object object;
        this.loading = true;
        URL uRL = null;
        BufferedReader bufferedReader = null;
        String string2 = null;
        fileName = string;
        this.parserPropVec.removeAllElements();
        this.parserNameVec.removeAllElements();
        try {
            if (string == null || string.trim().equals("")) {
                this.loading = false;
                return false;
            }
            try {
                uRL = this.getClass().getResource(string);
                object = uRL.openStream();
            }
            catch (Exception exception) {
                if (this.applet == null) {
                    object = new FileInputStream(string);
                }
                try {
                    uRL = new URL(this.applet.getCodeBase().getProtocol(), this.applet.getDocumentBase().getHost(), this.applet.getDocumentBase().getPort(), "/" + string);
                    object = uRL.openStream();
                }
                catch (Exception exception2) {
                    try {
                        uRL = new URL(this.applet.getDocumentBase().getProtocol(), this.applet.getDocumentBase().getHost(), this.applet.getDocumentBase().getPort(), "/" + string);
                        object = uRL.openStream();
                    }
                    catch (Exception exception3) {
                        try {
                            uRL = new URL(this.applet.getDocumentBase().getProtocol(), this.applet.getDocumentBase().getHost(), this.applet.getDocumentBase().getPort(), "/SASusers/" + string);
                            object = uRL.openStream();
                        }
                        catch (Exception exception4) {
                            try {
                                uRL = new URL(String.valueOf(String.valueOf(this.applet.getDocumentBase())) + "SASusers/" + string);
                                object = uRL.openStream();
                            }
                            catch (Exception exception5) {
                                this.loading = false;
                                System.err.println(String.valueOf(SnmpUtils.getString("Parser file not found : ")) + " " + string);
                                return false;
                            }
                        }
                    }
                }
            }
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
        }
        catch (Exception exception) {
            this.loading = false;
            System.err.println(String.valueOf(SnmpUtils.getString("Parser file not found : ")) + " " + string);
            return false;
        }
        try {
            string2 = bufferedReader.readLine();
            while (string2 != null) {
                if ((string2 = string2.trim()).equals("{")) {
                    object = this.readParser(bufferedReader, this.parserNameVec);
                    ((TrapParser)object).setValues();
                }
                string2 = bufferedReader.readLine();
            }
            return true;
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(SnmpUtils.getString("Error Reading File. ")) + "  " + exception.getMessage());
            this.loading = false;
            return false;
        }
    }

    public void loadParsersFromMib(String string) {
        this.loading = true;
        try {
            if (string == null || string.trim().equals("")) {
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            int n = stringTokenizer.countTokens();
            fileName = string;
            MibModule mibModule = null;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringTokenizer.nextToken();
                if (this.mibOps == null) {
                    this.mibOps = new MibOperations();
                }
                if (this.applet != null) {
                    this.mibOps.loadMibModules(this.applet, string2);
                    Enumeration enumeration = this.mibOps.getMibModules();
                    while (enumeration.hasMoreElements()) {
                        mibModule = (MibModule)enumeration.nextElement();
                        if (mibModule.getFileName().trim().indexOf(string2.trim()) == -1) continue;
                        this.loadTrapsFromModule(mibModule);
                    }
                } else {
                    mibModule = this.mibOps.loadMibModule(string2);
                    this.loadTrapsFromModule(mibModule);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            this.loading = false;
            System.out.println(String.valueOf(SnmpUtils.getString("Error Reading MIB File:")) + " " + exception);
        }
    }

    private void loadTrapsFromModule(MibModule mibModule) {
        if (mibModule != null) {
            Enumeration enumeration = mibModule.getDefinedTraps();
            block0: while (enumeration.hasMoreElements()) {
                MibTrap mibTrap = (MibTrap)enumeration.nextElement();
                int n = 0;
                while (n < this.parserNameVec.size()) {
                    if (this.createParser(mibTrap.getName(), mibTrap).toString().equals(this.parserNameVec.elementAt(n))) continue block0;
                    ++n;
                }
                TrapParser trapParser = this.createParser(mibTrap.getName(), mibTrap);
                this.parserPropVec.addElement(trapParser.trapParserProperties);
                trapParser.setProperties(trapParser.trapParserProperties, this.parserNameVec);
                trapParser.ti = this;
                trapParser.setValues();
            }
        }
    }

    public boolean parseEvtAndFire(TrapEvent trapEvent) {
        try {
            SnmpPDU snmpPDU = trapEvent.getTrapPDU();
            if (snmpPDU == null) {
                return false;
            }
            if (snmpPDU.getCommand() == -92) {
                Object object;
                String string;
                SnmpTrapReceiver snmpTrapReceiver = (SnmpTrapReceiver)trapEvent.getSource();
                String string2 = null;
                if (snmpPDU.getEnterprise() != null) {
                    string2 = snmpPDU.getEnterprise().toString();
                }
                if ((string = trapEvent.getAgentAddress()) == null) {
                    string = trapEvent.getRemoteHost().toLowerCase().trim();
                }
                int n = snmpPDU.getTrapType();
                int n2 = snmpPDU.getSpecificType();
                ParsedTrapEvent parsedTrapEvent = new ParsedTrapEvent(trapEvent);
                Enumeration enumeration = this.trapParsers.elements();
                while (enumeration.hasMoreElements()) {
                    Object object2;
                    String string3;
                    String string4;
                    StringTokenizer stringTokenizer;
                    String string5;
                    StringTokenizer stringTokenizer2;
                    object = (TrapParser)enumeration.nextElement();
                    boolean bl = true;
                    boolean bl2 = true;
                    if (!((TrapParser)object).customOIDDefn.equals("")) {
                        stringTokenizer2 = new StringTokenizer(((TrapParser)object).customOIDDefn, ";");
                        while (stringTokenizer2.hasMoreTokens()) {
                            string5 = stringTokenizer2.nextToken();
                            stringTokenizer = new StringTokenizer(string5, ":");
                            string4 = stringTokenizer.nextToken();
                            string3 = stringTokenizer.nextToken();
                            object2 = snmpPDU.getVariableBindings();
                            boolean bl3 = false;
                            int n3 = 0;
                            while (n3 < ((Vector)object2).size()) {
                                SnmpVarBind snmpVarBind = (SnmpVarBind)((Vector)object2).elementAt(n3);
                                String string6 = snmpVarBind.getObjectID().toString();
                                if (string4.equals(string6)) {
                                    Object object3 = snmpVarBind.getVariable().getVarObject();
                                    if (object3 != null && string3.equalsIgnoreCase(object3.toString())) {
                                        bl3 = true;
                                        break;
                                    }
                                    if (object3 == null && (string3.equals("") || string3.equalsIgnoreCase("null"))) {
                                        bl3 = true;
                                        break;
                                    }
                                }
                                ++n3;
                            }
                            if (bl3) continue;
                            bl = false;
                            break;
                        }
                    }
                    if (!((TrapParser)object).agentDefn.equals("")) {
                        stringTokenizer2 = new StringTokenizer(((TrapParser)object).agentDefn, ";");
                        while (stringTokenizer2.hasMoreTokens()) {
                            string5 = stringTokenizer2.nextToken();
                            stringTokenizer = new StringTokenizer(string5, ":");
                            string4 = stringTokenizer.nextToken();
                            if (string4.equals(string3 = snmpPDU.getRemoteHost()) || string4.equals(snmpPDU.getAgentAddr())) {
                                object2 = stringTokenizer.nextToken();
                                if (!((String)object2).equals(String.valueOf(snmpPDU.getRemotePort())) && !((String)object2).equals("0")) continue;
                                bl2 = true;
                                break;
                            }
                            bl2 = false;
                        }
                    }
                    if (((TrapParser)object).enterprise != null && !((TrapParser)object).enterprise.equals("") && !string2.toString().startsWith(((TrapParser)object).enterprise) || ((TrapParser)object).GT != n && ((TrapParser)object).GT >= 0 || (((TrapParser)object).GT != n || ((TrapParser)object).GT != 6 || ((TrapParser)object).ST != n2) && (((TrapParser)object).GT != n || ((TrapParser)object).GT == 6) && ((TrapParser)object).ST >= 0 || (!((TrapParser)object).customOIDDefn.equals("") || !((TrapParser)object).agentDefn.equals("")) && (!bl || !bl2)) continue;
                    Parsers.source = trapEvent.getRemoteHost().toLowerCase().trim();
                    parsedTrapEvent = snmpTrapReceiver == null ? ((TrapParser)object).parseTrap(null, parsedTrapEvent, snmpPDU) : ((TrapParser)object).parseTrap(snmpTrapReceiver.getMibOperations(), parsedTrapEvent, snmpPDU);
                    parsedTrapEvent.eoid = trapEvent.getEnterprise();
                    parsedTrapEvent.specificType = snmpPDU.getSpecificType();
                    parsedTrapEvent.trapType = snmpPDU.getTrapType();
                    parsedTrapEvent.remotePort = trapEvent.getRemotePort();
                    parsedTrapEvent.color = ((TrapParser)object).color;
                    this.fireEvent(parsedTrapEvent);
                    break;
                }
                if (this.trapParsers.size() == 0) {
                    Parsers.source = trapEvent.getRemoteHost().toLowerCase().trim();
                    parsedTrapEvent = snmpTrapReceiver == null ? new TrapParser().parseTrap(null, parsedTrapEvent, snmpPDU) : new TrapParser().parseTrap(snmpTrapReceiver.getMibOperations(), parsedTrapEvent, snmpPDU);
                    object = trapEvent.getAgentAddress();
                    parsedTrapEvent.entity = object == null ? Parsers.source : object;
                    parsedTrapEvent.eoid = trapEvent.getEnterprise();
                    parsedTrapEvent.specificType = snmpPDU.getSpecificType();
                    parsedTrapEvent.trapType = snmpPDU.getTrapType();
                    parsedTrapEvent.remotePort = trapEvent.getRemotePort();
                    this.fireEvent(parsedTrapEvent);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    private TrapParser readParser(BufferedReader bufferedReader, Vector vector) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            if (string.equals("}")) break;
            stringBuffer.append(String.valueOf(string) + "\n");
        }
        byte[] byArray = new byte[stringBuffer.length()];
        stringBuffer.toString().getBytes(0, byArray.length, byArray, 0);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Properties properties = new Properties();
        properties.load(byteArrayInputStream);
        this.parserPropVec.addElement(properties);
        TrapParser trapParser = new TrapParser();
        trapParser.setProperties(properties, vector);
        trapParser.ti = this;
        return trapParser;
    }

    public synchronized void removeParserListener(TrapParserListener trapParserListener) {
        this.eventListeners.removeElement(trapParserListener);
    }

    public void setCharacterEncoding(String string) {
        SnmpAPI.ENCODING = string;
    }

    public void setEditParser(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            if (stringArray[0].equals("select")) {
                Properties properties = new Properties();
                try {
                    this.currentParserIndex = Integer.parseInt(stringArray[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println(SnmpUtils.getString("Error in parsing int"));
                }
            } else if (stringArray[0].equals("delete")) {
                try {
                    this.currentParserIndex = Integer.parseInt(stringArray[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                this.parserPropVec.removeElementAt(this.currentParserIndex);
                this.parserNameVec.removeElementAt(this.currentParserIndex);
                Properties properties = new Properties();
                if (this.parserNameVec.size() > 0) {
                    this.currentParserIndex = 0;
                    this.currentParserVal = (Properties)this.parserPropVec.elementAt(this.currentParserIndex);
                    this.setProperties(this.currentParserVal);
                    this.formProperty(this.currentParserVal);
                } else {
                    this.editorVec = null;
                }
            }
        } else if (object instanceof Vector) {
            Vector vector = (Vector)object;
            if (((String)vector.elementAt(0)).equals("add")) {
                this.currentParserIndex = this.parserNameVec.size();
                Properties properties = new Properties();
                if ((Vector)vector.elementAt(1) == null) {
                    System.out.println(SnmpUtils.getString("Content vector is null"));
                }
                this.setParserContents((Vector)vector.elementAt(1));
                this.formProperty(properties);
                this.parserPropVec.addElement(properties);
                this.parserNameVec.addElement(this.currentName);
            } else if (((String)vector.elementAt(0)).equals("modify")) {
                try {
                    this.currentParserIndex = Integer.parseInt((String)vector.elementAt(1));
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println(SnmpUtils.getString("Error in parsing int"));
                }
                Properties properties = new Properties();
                this.setParserContents((Vector)vector.elementAt(2));
                this.formProperty(properties);
                this.parserPropVec.setElementAt(properties, this.currentParserIndex);
            }
        }
    }

    public void setFileName(String string) {
        this.trapParsers.removeAllElements();
        if (this.parserNameVec == null) {
            this.parserNameVec = new Vector();
        } else {
            this.parserNameVec.removeAllElements();
        }
        if (this.parserPropVec == null) {
            this.parserPropVec = new Vector();
        } else {
            this.parserPropVec.removeAllElements();
        }
        if (string.endsWith(".parser")) {
            fileName = string;
            this.loadParsers(string);
        } else if (string.trim().equals("")) {
            this.loadDefinedTraps();
        } else {
            this.loadParsersFromMib(string);
        }
        if (!this.loading) {
            this.editorVec = null;
            return;
        }
    }

    public void setLoadMibsFromDatabase(boolean bl) {
        this.mibOps.setLoadFromDatabase(bl);
    }

    public void setMibOperations(MibOperations mibOperations) {
        this.mibOps = mibOperations;
    }

    public void setOverwriteMibsInDatabase(boolean bl) {
        this.mibOps.setOverwriteDatabase(bl);
    }

    private void setParserContents(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            String string2 = (String)vector.elementAt(n + 1);
            if (string.equals("Name")) {
                this.currentName = string2;
                if (this.currentParserIndex < this.parserNameVec.size()) {
                    this.parserNameVec.setElementAt(string2, this.currentParserIndex);
                }
            } else if (string.equals("Enterprise")) {
                this.enterprise = string2;
            } else if (string.equals("Generic Type")) {
                try {
                    this.GT = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    this.GT = -1;
                }
            } else if (string.equals("Specific Type")) {
                try {
                    this.ST = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    this.ST = 0;
                }
            } else if (string.equals("Severity")) {
                this.severity = ParsedTrapEvent.severityInt(string2);
            } else if (string.equals("TextDefn")) {
                this.textDefn = string2;
            } else if (string.equals("EntityDefn")) {
                this.entityDefn = string2;
            } else if (string.equals("CategoryDefn")) {
                this.categoryDefn = string2;
            } else if (string.equals("DomainDefn")) {
                this.domainDefn = string2;
            } else if (string.equals("NetworkDefn")) {
                this.networkDefn = string2;
            } else if (string.equals("NodeDefn")) {
                this.nodeDefn = string2;
            } else if (string.equals("SourceDefn")) {
                this.sourceDefn = string2;
            } else if (string.equals("HelpDefn")) {
                this.helpDefn = string2;
            } else if (string.equals("Custom Match")) {
                this.customOIDDefn = string2;
            } else if (string.equals("AgentAddress")) {
                this.agentDefn = string2;
            } else if (string.equals("Color")) {
                this.color = string2;
            }
            n += 2;
        }
    }

    public void setParserName(String[] stringArray) {
        if (this.parserNameVec != null && this.parserNameVec.size() > 0) {
            int n = 0;
            while (n < this.parserNameVec.size()) {
                this.parserNameVec.setElementAt(stringArray[n], n);
                ++n;
            }
        }
    }

    private void setProperties(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            try {
                String string = (String)enumeration.nextElement();
                String string2 = (String)((Hashtable)properties).get(string);
                if (string.equals("name")) {
                    this.currentName = string2;
                    continue;
                }
                if (string.equals("enterprise")) {
                    this.enterprise = string2;
                    continue;
                }
                if (string.equals("GT")) {
                    try {
                        this.GT = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.GT = -1;
                    }
                    continue;
                }
                if (string.equals("ST")) {
                    try {
                        this.ST = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.ST = 0;
                    }
                    continue;
                }
                if (string.equals("severity")) {
                    try {
                        this.severity = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.severity = 6;
                    }
                    continue;
                }
                if (string.equals("textDefn")) {
                    this.textDefn = string2;
                    continue;
                }
                if (string.equals("entityDefn")) {
                    this.entityDefn = string2;
                    continue;
                }
                if (string.equals("categoryDefn")) {
                    this.categoryDefn = string2;
                    continue;
                }
                if (string.equals("domainDefn")) {
                    this.domainDefn = string2;
                    continue;
                }
                if (string.equals("networkDefn")) {
                    this.networkDefn = string2;
                    continue;
                }
                if (string.equals("nodeDefn")) {
                    this.nodeDefn = string2;
                    continue;
                }
                if (string.equals("sourceDefn")) {
                    this.sourceDefn = string2;
                    continue;
                }
                if (string.equals("helpDefn")) {
                    this.helpDefn = string2;
                    continue;
                }
                if (string.equals("customMatchDefn")) {
                    this.customOIDDefn = string2;
                    continue;
                }
                if (string.equals("agentAddressDefn")) {
                    this.agentDefn = string2;
                    continue;
                }
                if (!string.equals("color")) continue;
                this.color = string2;
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println(String.valueOf(SnmpUtils.getString("Invalid value for trap parser definition:")) + " " + numberFormatException);
            }
        }
    }
}

