/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.ui.SasFileDialog;
import com.adventnet.snmp.ui.TrapParserBean;
import com.adventnet.snmp.ui.Utils;
import com.adventnet.utils.CustomFileFilter;
import com.adventnet.utils.FileUtils;
import com.adventnet.utils.NumericTextField;
import com.adventnet.utils.OidTextField;
import com.adventnet.utils.SnmpUIUtils;
import com.adventnet.utils.SnmpUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TrapParserCustomizer
extends JPanel
implements Customizer,
ActionListener {
    private String[] help = new String[]{SnmpUtils.getString("Shows the list of currently defined traps"), SnmpUtils.getString("Label for the Trap parser. This is used only for administration purposes and not for parsing"), SnmpUtils.getString("Specifies the Enterprise Object Id corresponding to this trap"), SnmpUtils.getString("Specifies the Generic Type value of the Trap. The acceptable value range is 0-6"), SnmpUtils.getString("Specifies the Specific Type value of a trap with Generic Type 6. Enabled only when Generic type values is 6."), SnmpUtils.getString("Specifies the Severity value for this trap"), SnmpUtils.getString("This failure object is used for correlation of events for a given Network element. Use this field to group events based on the Network element generating the Trap"), SnmpUtils.getString("Specifies community string of the trap "), SnmpUtils.getString("Specifies the node that originated the trap"), SnmpUtils.getString("Specifies the source Field value for the trap"), SnmpUtils.getString("Specifies the help url for this trap. The help button in the \"Event Details\" screen of the product will  bring up this page"), SnmpUtils.getString("Specifies the Message associated with this Trap"), SnmpUtils.getString("Displays the detailed description of the trap"), SnmpUtils.getString("Brings up a dialog for entering traps from a File or Mib")};
    Font lfont = SnmpUIUtils.getFont();
    private String[] genericValues = new String[]{" - ", SnmpUtils.getString("coldStart"), SnmpUtils.getString("warmStart"), SnmpUtils.getString("linkDown"), SnmpUtils.getString("linkUp"), SnmpUtils.getString("authenticationFailure"), SnmpUtils.getString("egpNeighborLoss"), SnmpUtils.getString("enterpriseSpecific")};
    private String[] severeValues = new String[]{"  -  ", SnmpUtils.getString("All"), SnmpUtils.getString("Critical"), SnmpUtils.getString("Major"), SnmpUtils.getString("Minor"), SnmpUtils.getString("Warning"), SnmpUtils.getString("Clear"), SnmpUtils.getString("Info")};
    private JPanel centerPanel;
    private JPanel westPanel;
    JList parserList;
    JTextField nameField = new JTextField(10);
    OidTextField enterpriseField = new OidTextField(10, true);
    JComboBox genericBox = new JComboBox<String>(this.genericValues);
    NumericTextField specificField = new NumericTextField(10);
    JComboBox severityBox = new JComboBox<String>(this.severeValues);
    JColorChooser colorChooser = new JColorChooser();
    JPanel colorPanel;
    String colorString = new String("-1");
    JTextField failureField = new JTextField(10);
    JTextField categoryField = new JTextField(10);
    JTextField nodeField = new JTextField(10);
    JTextField sourceField = new JTextField(10);
    JTextField helpUrlField = new JTextField(10);
    JTextArea messageField = new JTextArea();
    OidTextField customOIDField = new OidTextField(10, true);
    JTextField customValueField = new JTextField(10);
    JTextField agentField = new JTextField(10);
    NumericTextField portField = new NumericTextField(10);
    JButton addButton;
    JButton modButton;
    JButton delButton;
    JButton saveButton;
    JButton varbindAddButton;
    JButton varbindDelButton;
    JButton agentAddButton;
    JButton agentDelButton;
    JButton colorButton;
    JList varbindList;
    JList agentList;
    DefaultListModel varbindModel;
    DefaultListModel agentListModel;
    private TrapParserBean trapParser;
    protected PropertyChangeSupport listeners;
    Vector parserVec = new Vector();
    Vector contentsVec = new Vector();
    String fileName;
    int index = 0;
    int genericIndex = 0;
    JPanel bottomPanel;
    JButton fileBrowse = null;
    JButton mibBrowse = null;
    JButton newButton = null;
    JTextField loadMibField = null;
    JTextField loadFileField = null;
    JTabbedPane propPane = null;
    SasFileDialog mibSasDialog = null;
    SasFileDialog fileSasDialog = null;

    public TrapParserCustomizer() {
        this.listeners = new PropertyChangeSupport(this);
        this.genericBox.addActionListener(this);
        this.genericBox.setFont(this.lfont);
        this.severityBox.addActionListener(this);
        this.severityBox.setFont(this.lfont);
        this.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(SnmpUtils.getString("Configuration of Trap Parsers"));
        jLabel.setFont(this.lfont);
        jLabel.setForeground(Color.black);
        jLabel.setHorizontalAlignment(0);
        jLabel.setBorder(new EtchedBorder(2));
        jLabel.setPreferredSize(new Dimension(0, 22));
        this.setupWestPanel();
        this.setupCenterPanel();
        this.add((Component)this.westPanel, "West");
        this.add((Component)this.bottomPanel, "North");
        this.add((Component)this.centerPanel, "Center");
        this.setBorder(new BevelBorder(2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (object.equals(this.mibSasDialog)) {
            if (!string.equals(SnmpUtils.getString("Open"))) return;
            this.loadMibField.setText(this.mibSasDialog.getSelectedFileUrl());
            this.loadMibFile();
            return;
        }
        if (object.equals(this.fileSasDialog)) {
            if (!string.equals(SnmpUtils.getString("Open"))) return;
            String string2 = this.fileSasDialog.getSelectedFileUrl();
            if (string2 != null && !string2.endsWith(".parser")) {
                Utils.err("file must have .parser extension");
                return;
            }
            this.loadFileField.setText(this.fileSasDialog.getSelectedFileUrl());
            this.trapParser.loadParsers(this.loadFileField.getText());
            Vector vector = (Vector)this.trapParser.getEditParser();
            if (vector == null || vector.size() <= 2) return;
            this.fileName = (String)vector.elementAt(0);
            this.parserVec = (Vector)vector.elementAt(1);
            this.contentsVec = (Vector)vector.elementAt(2);
            this.parserList.setListData(this.parserVec);
            this.setPropertyValues(this.contentsVec);
            this.parserList.setSelectedIndex(0);
            return;
        }
        if (string.equals("genericBox")) {
            if (this.genericBox.getSelectedIndex() == 6) {
                if (!this.enterpriseField.getText().trim().equals(".1.3.6.1.2.11")) return;
                this.enterpriseField.setText("");
                this.enterpriseField.requestFocus();
                return;
            } else {
                this.enterpriseField.setText(".1.3.6.1.2.11");
                this.specificField.setText("0");
            }
            return;
        }
        if (string.equals("mibBrowse") || string.equals("fileBrowse")) {
            if (this.trapParser.applet == null) {
                block82: {
                    JFileChooser jFileChooser = new JFileChooser();
                    if (string.equals("fileBrowse")) {
                        jFileChooser.setDialogTitle(SnmpUtils.getString("Load Parser File"));
                        jFileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
                        CustomFileFilter customFileFilter = new CustomFileFilter("parser");
                        jFileChooser.addChoosableFileFilter(customFileFilter);
                    } else {
                        jFileChooser.setDialogTitle(SnmpUtils.getString("Load Mib File"));
                        jFileChooser.setCurrentDirectory(new File("../mibs"));
                        jFileChooser.addChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
                    }
                    jFileChooser.setVisible(true);
                    int n = jFileChooser.showOpenDialog(this);
                    if (n != 0) return;
                    File file = jFileChooser.getSelectedFile();
                    if (file == null) {
                        return;
                    }
                    try {
                        String string3 = file.getCanonicalPath();
                        String string4 = System.getProperty("user.dir");
                        String string5 = FileUtils.getRelativePath(string4, string3, ".");
                        if (string.equals("mibBrowse")) {
                            this.loadMibField.setText(string5.toString());
                        }
                        if (string.equals("fileBrowse")) {
                            if (!string5.endsWith(".parser")) {
                                Utils.err(SnmpUtils.getString("Parser file must have .parser extension"));
                                return;
                            }
                            this.loadFileField.setText(string5.toString());
                        }
                    }
                    catch (Exception exception) {
                        String string6 = file.getName();
                        String string7 = jFileChooser.getCurrentDirectory().toString();
                        if (string7 == null || string6 == null) return;
                        if (string.equals("mibBrowse")) {
                            this.loadMibField.setText(String.valueOf(string7.trim()) + File.separator + string6);
                        }
                        if (!string.equals("fileBrowse")) break block82;
                        if (!string6.endsWith(".parser")) {
                            Utils.err(SnmpUtils.getString("Parser file must have .parser extension"));
                            return;
                        }
                        this.loadFileField.setText(String.valueOf(string7.trim()) + File.separator + string6);
                    }
                }
                if (string.equals("mibBrowse")) {
                    if (this.loadMibField.getText().trim().equals("")) {
                        return;
                    }
                    this.loadMibFile();
                    return;
                } else {
                    if (!string.equals("fileBrowse")) return;
                    if (this.loadFileField.getText().trim().equals("")) {
                        return;
                    }
                    this.loadParserFile();
                }
                return;
            }
            if (string.equals("mibBrowse")) {
                this.mibSasDialog = new SasFileDialog(this.trapParser.applet);
                this.mibSasDialog.addActionListener(this);
                this.mibSasDialog.init();
                this.mibSasDialog.setDirectory("/mibs");
                ((Component)this.mibSasDialog).setSize(new Dimension(500, 380));
                Utils.centerWindow(this.mibSasDialog);
                this.mibSasDialog.show();
                return;
            } else {
                if (!string.equals("fileBrowse")) return;
                this.fileSasDialog = new SasFileDialog(this.trapParser.applet);
                this.fileSasDialog.addActionListener(this);
                this.fileSasDialog.init();
                this.fileSasDialog.setDirectory("/");
                this.fileSasDialog.setFileExtension(".parser");
                this.fileSasDialog.FileType.setSelectedItem("Parser Files(*.parser)");
                ((Component)this.fileSasDialog).setSize(new Dimension(500, 380));
                Utils.centerWindow(this.fileSasDialog);
                this.fileSasDialog.show();
            }
            return;
        }
        if (string.equals("loadMibFile")) {
            this.loadMibFile();
            return;
        } else if (string.equals("loadParserFile")) {
            this.loadParserFile();
            return;
        } else if (string.equals(SnmpUtils.getString("Add"))) {
            if (this.nameField.getText().trim().equals("")) {
                JOptionPane.showMessageDialog(null, SnmpUtils.getString("Enter ParserName"), SnmpUtils.getString("Warning Message"), 1);
                return;
            }
            int n = 0;
            int n2 = 0;
            while (n2 < this.parserVec.size()) {
                if (this.nameField.getText().trim().equals(this.parserVec.elementAt(n2))) {
                    ++n;
                }
                ++n2;
            }
            if (n > 0) {
                JOptionPane.showMessageDialog(null, SnmpUtils.getString("Parser Name duplication "), SnmpUtils.getString("Warning Message"), 1);
                return;
            }
            Vector vector = new Vector();
            vector.addElement("add");
            vector.addElement(this.getPropertyValues());
            this.trapParser.setEditParser(vector);
            vector = (Vector)this.trapParser.getEditParser();
            if (vector == null) return;
            this.fileName = (String)vector.elementAt(0);
            this.parserVec = (Vector)vector.elementAt(1);
            this.contentsVec = (Vector)vector.elementAt(2);
            this.parserList.setListData(this.parserVec);
            this.setPropertyValues(this.contentsVec);
            this.parserList.setSelectedIndex(this.parserList.getModel().getSize() - 1);
            return;
        } else if (string.equals(SnmpUtils.getString("Mod"))) {
            if (this.parserList.isSelectionEmpty() || this.parserVec.size() == 0) {
                return;
            }
            this.index = this.parserList.getSelectedIndex();
            int n = 0;
            int n3 = 0;
            while (n3 < this.parserVec.size()) {
                if (n3 != this.index) {
                    if (this.nameField.getText().trim().equals(this.parserVec.elementAt(n3))) {
                        ++n;
                    }
                    if (n > 0) {
                        JOptionPane.showMessageDialog(null, SnmpUtils.getString("Parser Name duplication "), SnmpUtils.getString("Warning Message"), 1);
                        return;
                    }
                }
                ++n3;
            }
            Vector vector = new Vector();
            vector.addElement("modify");
            vector.addElement(String.valueOf(this.index));
            vector.addElement(this.getPropertyValues());
            this.trapParser.setEditParser(vector);
            vector = (Vector)this.trapParser.getEditParser();
            if (vector == null) return;
            this.fileName = (String)vector.elementAt(0);
            this.parserVec = (Vector)vector.elementAt(1);
            this.contentsVec = (Vector)vector.elementAt(2);
            this.parserList.setListData(this.parserVec);
            this.setPropertyValues(this.contentsVec);
            this.parserList.setSelectedIndex(this.index);
            return;
        } else if (string.equals(SnmpUtils.getString("Del"))) {
            this.index = this.parserList.getSelectedIndex();
            Vector vector = this.parserVec;
            if (this.index < 0) {
                if (vector.size() <= 0) return;
                this.index = 0;
            } else if (this.index >= vector.size()) {
                return;
            }
            String[] stringArray = new String[]{"delete", String.valueOf(this.index)};
            this.trapParser.setEditParser(stringArray);
            vector = (Vector)this.trapParser.getEditParser();
            if (vector != null) {
                this.fileName = (String)vector.elementAt(0);
                this.parserVec = (Vector)vector.elementAt(1);
                this.contentsVec = (Vector)vector.elementAt(2);
                this.parserList.setListData(this.parserVec);
                this.setPropertyValues(this.contentsVec);
                if (this.index < this.parserVec.size()) {
                    this.parserList.setSelectedIndex(this.index);
                } else if (this.parserVec.size() != 0) {
                    this.parserList.setSelectedIndex(this.index - 1);
                }
            }
            this.parserList.updateUI();
            return;
        } else if (string.equals(SnmpUtils.getString("Save"))) {
            if (this.trapParser.applet == null) {
                File file;
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setDialogTitle(SnmpUtils.getString("Save File As"));
                jFileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
                CustomFileFilter customFileFilter = new CustomFileFilter("parser");
                jFileChooser.addChoosableFileFilter(customFileFilter);
                jFileChooser.setVisible(true);
                int n = jFileChooser.showSaveDialog(this);
                if (n != 0) return;
                if (!jFileChooser.getSelectedFile().getName().endsWith(".parser")) {
                    jFileChooser.setSelectedFile(new File(String.valueOf(String.valueOf(jFileChooser.getSelectedFile())) + ".parser"));
                }
                if ((file = jFileChooser.getSelectedFile()) == null) {
                    try {
                        String string8 = file.getCanonicalPath();
                        String string9 = System.getProperty("user.dir");
                        String string10 = FileUtils.getRelativePath(string9, string8, ".");
                        this.loadFileField.setText(string10.toString());
                    }
                    catch (Exception exception) {
                        String string11 = file.getName();
                        String string12 = jFileChooser.getCurrentDirectory().toString();
                        if (string12 != null && string11 != null) {
                            if (!string11.endsWith(".parser")) {
                                Utils.err(SnmpUtils.getString("Parser file must have .parser extension"));
                                return;
                            }
                            this.loadFileField.setText(String.valueOf(string12.trim()) + File.separator + string11);
                        }
                    }
                } else {
                    this.loadFileField.setText(file.toString());
                }
                this.trapParser.fileWrite(this.loadFileField.getText());
                this.trapParser.setFileName(this.loadFileField.getText());
                return;
            } else {
                String string13 = this.loadFileField.getText();
                StringTokenizer stringTokenizer = new StringTokenizer(string13, "/");
                int n = stringTokenizer.countTokens();
                int n4 = 0;
                while (n4 < n) {
                    string13 = (String)stringTokenizer.nextElement();
                    ++n4;
                }
                this.trapParser.fileWrite(string13);
                if (string13.equals("")) {
                    Utils.err(SnmpUtils.getString("Specify the FileName in the ParserFile TextField"));
                    return;
                } else {
                    this.trapParser.fileWrite(string13);
                }
            }
            return;
        } else if (string.equals("customAdd")) {
            if (!this.customOIDField.getText().equals("") && !this.customValueField.getText().equals("")) {
                this.varbindModel.addElement(String.valueOf(this.customOIDField.getText()) + ":" + this.customValueField.getText());
                return;
            } else {
                JOptionPane.showMessageDialog(null, SnmpUtils.getString("Enter OID and Value fields"), SnmpUtils.getString("Error Message"), 1);
            }
            return;
        } else if (string.equals("customRemove")) {
            int[] nArray = this.varbindList.getSelectedIndices();
            if (nArray == null) return;
            int n = 0;
            while (n < nArray.length) {
                this.varbindModel.remove(nArray[0]);
                if (nArray[0] + 1 <= this.varbindModel.size()) {
                    this.varbindList.setSelectedIndex(nArray[0]);
                } else if (!this.varbindModel.isEmpty()) {
                    this.varbindList.setSelectedIndex(nArray[0] - 1);
                }
                ++n;
            }
            return;
        } else if (string.equals("agentAdd")) {
            if (!this.agentField.getText().equals("")) {
                this.agentListModel.addElement(String.valueOf(this.agentField.getText().trim()) + ":" + (this.portField.getText().trim().equals("") ? "0" : this.portField.getText().trim()));
                return;
            } else {
                JOptionPane.showMessageDialog(null, SnmpUtils.getString("Enter Agent Name"), SnmpUtils.getString("Error Message"), 1);
            }
            return;
        } else {
            int[] nArray;
            if (!string.equals("agentRem") || (nArray = this.agentList.getSelectedIndices()) == null) return;
            int n = 0;
            while (n < nArray.length) {
                this.agentListModel.remove(nArray[0]);
                if (nArray[0] + 1 <= this.agentListModel.size()) {
                    this.agentList.setSelectedIndex(nArray[0]);
                } else if (!this.agentListModel.isEmpty()) {
                    this.agentList.setSelectedIndex(nArray[0] - 1);
                }
                ++n;
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.addPropertyChangeListener(propertyChangeListener);
    }

    private Vector getPropertyValues() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("Severity");
        vector.addElement(String.valueOf(this.severityBox.getSelectedIndex()));
        vector.addElement("TextDefn");
        vector.addElement(this.messageField.getText());
        vector.addElement("EntityDefn");
        vector.addElement(this.failureField.getText());
        vector.addElement("CategoryDefn");
        vector.addElement(this.categoryField.getText());
        vector.addElement("NodeDefn");
        vector.addElement(this.nodeField.getText());
        vector.addElement("SourceDefn");
        vector.addElement(this.sourceField.getText());
        vector.addElement("HelpDefn");
        vector.addElement(this.helpUrlField.getText());
        vector.addElement("Name");
        vector.addElement(this.nameField.getText());
        vector.addElement("Generic Type");
        vector.addElement(String.valueOf(this.genericBox.getSelectedIndex() - 1));
        vector.addElement("Specific Type");
        vector.addElement(this.specificField.getText());
        vector.addElement("Enterprise");
        vector.addElement(this.enterpriseField.getText());
        vector.addElement("Custom Match");
        Enumeration enumeration = this.varbindModel.elements();
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(String.valueOf((String)enumeration.nextElement()) + ";");
        }
        vector.addElement(stringBuffer.toString());
        vector.addElement("AgentAddress");
        enumeration = this.agentListModel.elements();
        stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(String.valueOf((String)enumeration.nextElement()) + ";");
        }
        vector.addElement(stringBuffer.toString());
        vector.addElement("Color");
        Integer n = new Integer(this.colorButton.getBackground().getRGB());
        String string = n.toString();
        vector.addElement(string);
        return vector;
    }

    private void loadMibFile() {
        this.trapParser.loadParsersFromMib(this.loadMibField.getText());
        Vector vector = (Vector)this.trapParser.getEditParser();
        if (vector != null) {
            this.fileName = (String)vector.elementAt(0);
            this.parserVec = (Vector)vector.elementAt(1);
            this.contentsVec = (Vector)vector.elementAt(2);
            this.parserList.setListData(this.parserVec);
            this.setPropertyValues(this.contentsVec);
            this.parserList.setSelectedIndex(this.index);
        }
    }

    private void loadParserFile() {
        Object object;
        File file = new File(this.loadFileField.getText());
        if (!file.exists()) {
            try {
                object = new FileOutputStream(file);
                ((FileOutputStream)object).close();
            }
            catch (IOException iOException) {
                Utils.err(SnmpUtils.getString("Unable to create file"));
                return;
            }
        }
        this.trapParser.loadParsers(this.loadFileField.getText());
        object = (Vector)this.trapParser.getEditParser();
        if (object != null) {
            this.fileName = (String)((Vector)object).elementAt(0);
            this.parserVec = (Vector)((Vector)object).elementAt(1);
            this.contentsVec = (Vector)((Vector)object).elementAt(2);
            this.parserList.setListData(this.parserVec);
            this.setPropertyValues(this.contentsVec);
            this.parserList.setSelectedIndex(0);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.removePropertyChangeListener(propertyChangeListener);
    }

    public void setObject(Object object) {
        Vector vector;
        this.trapParser = (TrapParserBean)object;
        Object object2 = this.trapParser.getEditParser();
        if (object2 instanceof Vector && (vector = (Vector)object2).size() == 3) {
            this.fileName = (String)vector.elementAt(0);
            if (vector.elementAt(1) instanceof Vector) {
                this.parserVec = (Vector)vector.elementAt(1);
                this.contentsVec = (Vector)vector.elementAt(2);
            }
        }
        this.listeners.firePropertyChange(null, null, null);
    }

    private void setPropertyValues(Vector vector) {
        StringTokenizer stringTokenizer;
        this.severityBox.setSelectedIndex(Integer.parseInt((String)vector.elementAt(vector.indexOf("Severity") + 1)));
        if (((String)vector.elementAt(vector.indexOf("TextDefn") + 1)).equals("")) {
            this.messageField.setText("$*");
        } else {
            this.messageField.setText(((String)vector.elementAt(vector.indexOf("TextDefn") + 1)).trim());
        }
        this.failureField.setText((String)vector.elementAt(vector.indexOf("EntityDefn") + 1));
        if (((String)vector.elementAt(vector.indexOf("CategoryDefn") + 1)).equals("")) {
            this.categoryField.setText("$Community");
        } else {
            this.categoryField.setText((String)vector.elementAt(vector.indexOf("CategoryDefn") + 1));
        }
        if (((String)vector.elementAt(vector.indexOf("NodeDefn") + 1)).equals("")) {
            this.nodeField.setText("$Source");
        } else {
            this.nodeField.setText((String)vector.elementAt(vector.indexOf("NodeDefn") + 1));
        }
        if (((String)vector.elementAt(vector.indexOf("SourceDefn") + 1)).equals("")) {
            this.sourceField.setText("$Source");
        } else {
            this.sourceField.setText((String)vector.elementAt(vector.indexOf("SourceDefn") + 1));
        }
        if (((String)vector.elementAt(vector.indexOf("HelpDefn") + 1)).equals("")) {
            this.helpUrlField.setText("$GenericType-$SpecificType.html");
        } else {
            this.helpUrlField.setText((String)vector.elementAt(vector.indexOf("HelpDefn") + 1));
        }
        this.nameField.setText((String)vector.elementAt(vector.indexOf("Name") + 1));
        this.genericBox.setSelectedIndex(Integer.parseInt((String)vector.elementAt(vector.indexOf("Generic Type") + 1)) + 1);
        this.specificField.setText((String)vector.elementAt(vector.indexOf("Specific Type") + 1));
        this.enterpriseField.setText((String)vector.elementAt(vector.indexOf("Enterprise") + 1));
        if (!((String)vector.elementAt(vector.indexOf("CustomMatchDefn") + 1)).equals("")) {
            stringTokenizer = new StringTokenizer(((String)vector.elementAt(vector.indexOf("CustomMatchDefn") + 1)).substring(0, ((String)vector.elementAt(vector.indexOf("CustomMatchDefn") + 1)).lastIndexOf(";") + 1), ";");
            this.varbindModel.removeAllElements();
            while (stringTokenizer.hasMoreTokens()) {
                this.varbindModel.addElement(stringTokenizer.nextToken());
            }
        } else {
            this.varbindModel.clear();
        }
        if (!((String)vector.elementAt(vector.indexOf("AgentAddressDefn") + 1)).equals("")) {
            stringTokenizer = new StringTokenizer(((String)vector.elementAt(vector.indexOf("AgentAddressDefn") + 1)).substring(0, ((String)vector.elementAt(vector.indexOf("AgentAddressDefn") + 1)).lastIndexOf(";") + 1), ";");
            this.agentListModel.removeAllElements();
            while (stringTokenizer.hasMoreTokens()) {
                this.agentListModel.addElement(stringTokenizer.nextToken());
            }
        } else {
            this.agentListModel.clear();
        }
        int n = Integer.valueOf((String)vector.elementAt(vector.indexOf("Color") + 1));
        Color color = new Color(n);
        this.colorButton.setBackground(color);
    }

    private void setUpTabs() {
        JLabel jLabel = new JLabel(SnmpUtils.getString("Trap Parser Name"));
        jLabel.setFont(this.lfont);
        jLabel.setForeground(Color.black);
        JLabel jLabel2 = new JLabel(SnmpUtils.getString("Enterprise OID"));
        jLabel2.setFont(this.lfont);
        jLabel2.setForeground(Color.black);
        JLabel jLabel3 = new JLabel(SnmpUtils.getString("Generic Type"));
        jLabel3.setFont(this.lfont);
        jLabel3.setForeground(Color.black);
        JLabel jLabel4 = new JLabel(SnmpUtils.getString("Specific Type"));
        jLabel4.setFont(this.lfont);
        jLabel4.setForeground(Color.black);
        JLabel jLabel5 = new JLabel(SnmpUtils.getString("Severity"));
        jLabel5.setFont(this.lfont);
        jLabel5.setForeground(Color.black);
        JLabel jLabel6 = new JLabel(SnmpUtils.getString("Severity Color"));
        jLabel6.setFont(this.lfont);
        jLabel6.setForeground(Color.black);
        JLabel jLabel7 = new JLabel(SnmpUtils.getString("Failure Object"));
        jLabel7.setFont(this.lfont);
        jLabel7.setForeground(Color.black);
        JLabel jLabel8 = new JLabel(SnmpUtils.getString("Community"));
        jLabel8.setFont(this.lfont);
        jLabel8.setForeground(Color.black);
        JLabel jLabel9 = new JLabel(SnmpUtils.getString("Node"));
        jLabel9.setFont(this.lfont);
        jLabel9.setForeground(Color.black);
        JLabel jLabel10 = new JLabel(SnmpUtils.getString("Source"));
        jLabel10.setFont(this.lfont);
        jLabel10.setForeground(Color.black);
        JLabel jLabel11 = new JLabel(SnmpUtils.getString("Help URL"));
        jLabel11.setFont(this.lfont);
        jLabel11.setForeground(Color.black);
        JLabel jLabel12 = new JLabel(SnmpUtils.getString("Message"));
        jLabel12.setFont(this.lfont);
        jLabel12.setForeground(Color.black);
        this.nameField.setToolTipText(this.help[1]);
        this.enterpriseField.setToolTipText(this.help[2]);
        this.genericBox.setToolTipText(this.help[3]);
        this.specificField.setToolTipText(this.help[4]);
        this.severityBox.setToolTipText(this.help[5]);
        this.failureField.setToolTipText(this.help[6]);
        this.categoryField.setToolTipText(this.help[7]);
        this.nodeField.setToolTipText(this.help[10]);
        this.sourceField.setToolTipText(this.help[11]);
        this.helpUrlField.setToolTipText(this.help[12]);
        this.messageField.setToolTipText(this.help[13]);
        this.propPane = new JTabbedPane(1);
        this.propPane.setFont(this.lfont);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.nameField, gridBagConstraints);
        jPanel2.add(this.nameField);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel2.add(jLabel3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        this.genericBox.setActionCommand("genericBox");
        this.genericBox.setSelectedIndex(0);
        gridBagLayout.setConstraints(this.genericBox, gridBagConstraints);
        jPanel2.add(this.genericBox);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(jLabel4, gridBagConstraints);
        jPanel2.add(jLabel4);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        this.specificField.addActionListener(this);
        gridBagLayout.setConstraints(this.specificField, gridBagConstraints);
        jPanel2.add(this.specificField);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel2.add(jLabel2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        this.enterpriseField.setText(".1.3.6.1.2.11");
        gridBagLayout.setConstraints(this.enterpriseField, gridBagConstraints);
        jPanel2.add(this.enterpriseField);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel();
        JLabel jLabel13 = new JLabel(String.valueOf(SnmpUtils.getString("OID ")) + " ");
        jLabel13.setFont(this.lfont);
        jLabel13.setForeground(Color.black);
        this.varbindAddButton = new JButton(">>");
        this.varbindAddButton.setFont(this.lfont);
        this.varbindAddButton.setActionCommand("customAdd");
        this.varbindAddButton.addActionListener(this);
        this.varbindDelButton = new JButton("<<");
        this.varbindDelButton.setFont(this.lfont);
        this.varbindDelButton.setActionCommand("customRemove");
        this.varbindDelButton.addActionListener(this);
        this.agentAddButton = new JButton(">>");
        this.agentAddButton.setFont(this.lfont);
        this.agentAddButton.setActionCommand("agentAdd");
        this.agentAddButton.addActionListener(this);
        this.agentDelButton = new JButton("<<");
        this.agentDelButton.setFont(this.lfont);
        this.agentDelButton.setActionCommand("agentRem");
        this.agentDelButton.addActionListener(this);
        JLabel jLabel14 = new JLabel(SnmpUtils.getString("Value"));
        jLabel14.setFont(this.lfont);
        jLabel14.setForeground(Color.black);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        gridBagConstraints = new GridBagConstraints();
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(gridBagLayout2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagLayout2.setConstraints(jLabel13, gridBagConstraints);
        jPanel4.add(jLabel13);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagLayout2.setConstraints(this.customOIDField, gridBagConstraints);
        jPanel4.add(this.customOIDField);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagLayout2.setConstraints(jLabel14, gridBagConstraints);
        jPanel4.add(jLabel14);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagLayout2.setConstraints(this.customValueField, gridBagConstraints);
        jPanel4.add(this.customValueField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 75, 0, 5);
        gridBagLayout2.setConstraints(this.varbindDelButton, gridBagConstraints);
        jPanel4.add(this.varbindDelButton);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        gridBagLayout2.setConstraints(this.varbindAddButton, gridBagConstraints);
        jPanel4.add(this.varbindAddButton);
        JScrollPane jScrollPane = new JScrollPane(this.varbindList);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.add((Component)jPanel4, "West");
        jPanel5.add((Component)jScrollPane, "Center");
        gridBagLayout2 = new GridBagLayout();
        gridBagConstraints = new GridBagConstraints();
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(gridBagLayout2);
        JLabel jLabel15 = new JLabel(SnmpUtils.getString("Agent"));
        jLabel15.setFont(this.lfont);
        jLabel15.setForeground(Color.black);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagLayout2.setConstraints(jLabel15, gridBagConstraints);
        jPanel6.add(jLabel15);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagLayout2.setConstraints(this.agentField, gridBagConstraints);
        jPanel6.add(this.agentField);
        JLabel jLabel16 = new JLabel(SnmpUtils.getString("Port"));
        jLabel16.setFont(this.lfont);
        jLabel16.setForeground(Color.black);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagLayout2.setConstraints(jLabel16, gridBagConstraints);
        jPanel6.add(jLabel16);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagLayout2.setConstraints(this.portField, gridBagConstraints);
        jPanel6.add(this.portField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 75, 0, 5);
        gridBagLayout2.setConstraints(this.agentDelButton, gridBagConstraints);
        jPanel6.add(this.agentDelButton);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        gridBagLayout2.setConstraints(this.agentAddButton, gridBagConstraints);
        jPanel6.add(this.agentAddButton);
        JScrollPane jScrollPane2 = new JScrollPane(this.agentList);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout());
        jPanel7.add((Component)jPanel6, "West");
        jPanel7.add((Component)jScrollPane2, "Center");
        this.bottomPanel = new JPanel();
        this.bottomPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(Color.white, Color.gray), SnmpUtils.getString("Load/Save TrapParsers"), 1, 2, this.lfont, Color.black));
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        this.bottomPanel.setLayout(gridBagLayout3);
        JLabel jLabel17 = new JLabel(SnmpUtils.getString("MIB File"));
        jLabel17.setFont(this.lfont);
        jLabel17.setForeground(Color.black);
        this.loadMibField = new JTextField(5);
        this.loadMibField.addActionListener(this);
        this.loadMibField.setActionCommand("loadMibFile");
        this.mibBrowse = new JButton(SnmpUtils.getString("Load"));
        this.mibBrowse.setFont(this.lfont);
        this.mibBrowse.addActionListener(this);
        this.mibBrowse.setActionCommand("mibBrowse");
        JLabel jLabel18 = new JLabel(SnmpUtils.getString("Parser File"));
        jLabel18.setFont(this.lfont);
        jLabel18.setForeground(Color.black);
        this.loadFileField = new JTextField(this.fileName, 5);
        this.loadFileField.addActionListener(this);
        this.loadFileField.setActionCommand("loadParserFile");
        this.fileBrowse = new JButton(SnmpUtils.getString("Load"));
        this.fileBrowse.setFont(this.lfont);
        this.fileBrowse.addActionListener(this);
        this.fileBrowse.setActionCommand("fileBrowse");
        this.newButton = new JButton(SnmpUtils.getString("New"));
        this.newButton.setFont(this.lfont);
        this.newButton.addActionListener(this);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
        gridBagLayout3.setConstraints(jLabel18, gridBagConstraints2);
        this.bottomPanel.add(jLabel18);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.insets = new Insets(0, 5, 5, 0);
        gridBagLayout3.setConstraints(this.loadFileField, gridBagConstraints2);
        this.bottomPanel.add(this.loadFileField);
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets = new Insets(0, 5, 5, 0);
        gridBagLayout3.setConstraints(this.fileBrowse, gridBagConstraints2);
        this.bottomPanel.add(this.fileBrowse);
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets = new Insets(0, 5, 5, 5);
        gridBagLayout3.setConstraints(this.saveButton, gridBagConstraints2);
        this.bottomPanel.add(this.saveButton);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
        gridBagLayout3.setConstraints(jLabel17, gridBagConstraints2);
        this.bottomPanel.add(jLabel17);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.insets = new Insets(0, 5, 5, 0);
        gridBagLayout3.setConstraints(this.loadMibField, gridBagConstraints2);
        this.bottomPanel.add(this.loadMibField);
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets = new Insets(0, 5, 5, 0);
        gridBagLayout3.setConstraints(this.mibBrowse, gridBagConstraints2);
        this.bottomPanel.add(this.mibBrowse);
        gridBagLayout3 = new GridBagLayout();
        gridBagConstraints2 = new GridBagConstraints();
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(gridBagLayout3);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
        gridBagLayout3.setConstraints(jPanel5, gridBagConstraints2);
        jPanel8.add(jPanel5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagLayout.setConstraints(jPanel7, gridBagConstraints);
        jPanel8.add(jPanel7);
        jPanel.add(jPanel5);
        jPanel.add((Component)jPanel7, "South");
        JPanel jPanel9 = new JPanel();
        gridBagLayout = new GridBagLayout();
        jPanel9.setLayout(gridBagLayout);
        this.colorButton = new JButton("            ");
        this.colorButton.setFont(this.lfont);
        this.colorPanel = new JPanel();
        this.colorPanel.setLayout(new BorderLayout());
        this.colorButton.setBackground(Color.white);
        this.colorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == TrapParserCustomizer.this.colorButton) {
                    Color color = TrapParserCustomizer.this.colorButton.getBackground();
                    Color color2 = JColorChooser.showDialog(TrapParserCustomizer.this.colorChooser, " Select a color", color);
                    TrapParserCustomizer.this.colorChooser.setPreviewPanel(new JPanel());
                    if (color2 == null) {
                        TrapParserCustomizer.this.colorButton.setBackground(color);
                        return;
                    }
                    TrapParserCustomizer.this.colorButton.setBackground(color2);
                    TrapParserCustomizer.this.colorString = new Integer(color2.getRGB()).toString();
                }
            }
        });
        this.colorPanel.add((Component)this.colorButton, "West");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(jLabel5, gridBagConstraints);
        jPanel9.add(jLabel5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.severityBox, gridBagConstraints);
        jPanel9.add(this.severityBox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(jLabel7, gridBagConstraints);
        jPanel9.add(jLabel7);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.failureField, gridBagConstraints);
        jPanel9.add(this.failureField);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(jLabel8, gridBagConstraints);
        jPanel9.add(jLabel8);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.categoryField, gridBagConstraints);
        jPanel9.add(this.categoryField);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(jLabel9, gridBagConstraints);
        jPanel9.add(jLabel9);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.nodeField, gridBagConstraints);
        jPanel9.add(this.nodeField);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(jLabel10, gridBagConstraints);
        jPanel9.add(jLabel10);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.sourceField, gridBagConstraints);
        jPanel9.add(this.sourceField);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(jLabel11, gridBagConstraints);
        jPanel9.add(jLabel11);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.helpUrlField, gridBagConstraints);
        jPanel9.add(this.helpUrlField);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(jLabel12, gridBagConstraints);
        jPanel9.add(jLabel12);
        JScrollPane jScrollPane3 = new JScrollPane(this.messageField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 4.0;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jScrollPane3, gridBagConstraints);
        jPanel9.add(jScrollPane3);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(jLabel6, gridBagConstraints);
        jPanel9.add(jLabel6);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.colorPanel, gridBagConstraints);
        jPanel9.add(this.colorPanel);
        this.propPane.add(SnmpUtils.getString("MatchCriteria"), jPanel);
        this.propPane.add(SnmpUtils.getString("OutPut Event Parameters"), jPanel9);
    }

    private void setupCenterPanel() {
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new BorderLayout());
        this.setUpTabs();
        this.centerPanel.add((Component)this.propPane, "Center");
    }

    private void setupWestPanel() {
        this.westPanel = new JPanel();
        this.westPanel.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(SnmpUtils.getString("Parser List"));
        jLabel.setFont(this.lfont);
        jLabel.setForeground(Color.black);
        jLabel.setHorizontalAlignment(0);
        jLabel.setPreferredSize(new Dimension(0, 23));
        this.parserList = new JList(this.parserVec);
        this.parserList.setToolTipText(this.help[0]);
        this.parserList.addListSelectionListener(new ListSelectionListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = TrapParserCustomizer.this.parserList.getSelectedIndex();
                if (n < 0) {
                    if (TrapParserCustomizer.this.parserVec.size() <= 0) return;
                    n = 0;
                } else if (n >= TrapParserCustomizer.this.parserVec.size()) {
                    return;
                }
                String[] stringArray = new String[]{"select", String.valueOf(n)};
                TrapParserCustomizer.this.trapParser.setEditParser(stringArray);
                Vector vector = (Vector)TrapParserCustomizer.this.trapParser.getEditParser();
                if (vector == null) return;
                TrapParserCustomizer.this.fileName = (String)vector.elementAt(0);
                TrapParserCustomizer.this.parserVec = (Vector)vector.elementAt(1);
                TrapParserCustomizer.this.contentsVec = (Vector)vector.elementAt(2);
                TrapParserCustomizer.this.setPropertyValues(TrapParserCustomizer.this.contentsVec);
                TrapParserCustomizer.this.parserList.validate();
                TrapParserCustomizer.this.parserList.invalidate();
            }
        });
        this.varbindModel = new DefaultListModel();
        this.varbindList = new JList(this.varbindModel);
        this.varbindList.setVisibleRowCount(5);
        this.varbindList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                String string = (String)TrapParserCustomizer.this.varbindList.getSelectedValue();
                StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                TrapParserCustomizer.this.customOIDField.setText(stringTokenizer.nextToken());
                TrapParserCustomizer.this.customValueField.setText(stringTokenizer.nextToken());
            }
        });
        this.agentListModel = new DefaultListModel();
        this.agentList = new JList(this.agentListModel);
        this.agentList.setVisibleRowCount(5);
        this.agentList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                String string = (String)TrapParserCustomizer.this.agentList.getSelectedValue();
                StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                TrapParserCustomizer.this.agentField.setText(stringTokenizer.nextToken());
                TrapParserCustomizer.this.portField.setText(stringTokenizer.nextToken());
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.parserList);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(Color.white, Color.gray), ""));
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        this.addButton = new JButton(SnmpUtils.getString("Add"));
        this.addButton.setFont(this.lfont);
        this.addButton.setSize(15, 15);
        this.addButton.addActionListener(this);
        this.modButton = new JButton(SnmpUtils.getString("Mod"));
        this.modButton.setFont(this.lfont);
        this.modButton.setSize(15, 15);
        this.modButton.addActionListener(this);
        this.delButton = new JButton(SnmpUtils.getString("Del"));
        this.delButton.setFont(this.lfont);
        this.delButton.setSize(15, 15);
        this.delButton.addActionListener(this);
        this.saveButton = new JButton(SnmpUtils.getString("Save"));
        this.saveButton.setFont(this.lfont);
        this.saveButton.addActionListener(this);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 2);
        gridBagLayout.setConstraints(this.addButton, gridBagConstraints);
        jPanel.add(this.addButton);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 2);
        gridBagLayout.setConstraints(this.modButton, gridBagConstraints);
        jPanel.add(this.modButton);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        gridBagLayout.setConstraints(this.delButton, gridBagConstraints);
        jPanel.add(this.delButton);
        this.westPanel.add((Component)jLabel, "North");
        this.westPanel.add((Component)jScrollPane, "Center");
        this.westPanel.add((Component)jPanel, "South");
        this.westPanel.setPreferredSize(new Dimension(185, 0));
    }
}

