/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.beans.SnmpTrapReceiver;
import com.adventnet.snmp.ui.TrapViewer;
import com.adventnet.utils.LedPanel;
import com.adventnet.utils.SnmpUtils;
import java.applet.Applet;

class TrapTasks
extends SnmpTrapReceiver {
    TrapViewer trapviewer = null;

    public TrapTasks(TrapViewer trapViewer) {
        this(trapViewer, null);
    }

    public TrapTasks(TrapViewer trapViewer, Applet applet) {
        super(applet);
        this.trapviewer = trapViewer;
    }

    public void debugPrint(String string) {
        if (this.trapviewer.getDebugInterface() != null) {
            this.trapviewer.di.debugPrint(string);
        } else {
            System.err.println(string);
        }
    }

    private void setV3Values() {
    }

    void startReceiver() {
        this.setV3Values();
        int n = 0;
        try {
            n = Integer.parseInt(this.trapviewer.portText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.trapviewer.statusPanel.showStatus(String.valueOf(SnmpUtils.getString("Error : ")) + " ", String.valueOf(SnmpUtils.getString("Invalid port number : ")) + " " + this.trapviewer.portText.getText());
            return;
        }
        if (n <= 0) {
            this.trapviewer.statusPanel.showStatus(String.valueOf(SnmpUtils.getString("Warning : ")) + " ", String.valueOf(SnmpUtils.getString("Cannot Listen on port : ")) + " " + n);
            return;
        }
        this.trapviewer.statusPanel.showStatus(String.valueOf(SnmpUtils.getString("Status : ")) + " ", SnmpUtils.getString("Not Listening for Traps"));
        try {
            this.setPortWithExceptionMsg(n);
            if (n <= 0) {
                this.stop();
                this.trapviewer.statusPanel.showStatus(String.valueOf(SnmpUtils.getString("Warning : ")) + " ", String.valueOf(SnmpUtils.getString("Cannot Listen on port : ")) + " " + n);
                return;
            }
            this.trapviewer.statusPanel.showStatus(String.valueOf(SnmpUtils.getString("Status : ")) + " ", SnmpUtils.getString("Listening for Traps"));
            this.trapviewer.start.setText("Stop");
            LedPanel cfr_ignored_0 = this.trapviewer.linkStatus;
            this.trapviewer.linkStatus.glowColor(2);
        }
        catch (Exception exception) {
            this.trapviewer.statusPanel.showStatus(String.valueOf(SnmpUtils.getString("Error : ")) + " ", String.valueOf(SnmpUtils.getString("Port is already in use : ")) + " " + n);
            this.trapviewer.start.setText(SnmpUtils.getString("Start"));
            LedPanel cfr_ignored_1 = this.trapviewer.linkStatus;
            this.trapviewer.linkStatus.glowColor(1);
            return;
        }
    }

    void stopReceiver() {
        this.stop();
        this.trapviewer.start.setText(SnmpUtils.getString("Start"));
        this.trapviewer.statusPanel.showStatus(String.valueOf(SnmpUtils.getString("Status : ")) + " ", SnmpUtils.getString("Not Listening for Traps"));
        LedPanel cfr_ignored_0 = this.trapviewer.linkStatus;
        this.trapviewer.linkStatus.glowColor(1);
    }
}

