/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.beans.ParsedTrapEvent;
import com.adventnet.snmp.beans.TrapEvent;
import com.adventnet.snmp.beans.TrapListener;
import com.adventnet.snmp.beans.TrapParserListener;
import com.adventnet.snmp.mibs.MibOperations;
import com.adventnet.snmp.snmp2.SnmpException;
import com.adventnet.snmp.ui.DebugInterface;
import com.adventnet.snmp.ui.SasFileDialog;
import com.adventnet.snmp.ui.TrapBrowser;
import com.adventnet.snmp.ui.TrapParserBean;
import com.adventnet.snmp.ui.TrapParserCustomizer;
import com.adventnet.snmp.ui.TrapTasks;
import com.adventnet.snmp.ui.Utils;
import com.adventnet.utils.CustomFileFilter;
import com.adventnet.utils.FileUtils;
import com.adventnet.utils.LedPanel;
import com.adventnet.utils.SnmpUIUtils;
import com.adventnet.utils.SnmpUtils;
import com.adventnet.utils.StatusPanel;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TrapViewer
extends JPanel
implements TrapParserListener,
ActionListener,
TrapListener {
    DebugInterface di = null;
    MibOperations mibOps = null;
    Applet applet = null;
    LedPanel linkStatus = null;
    StatusPanel statusPanel = null;
    JButton settings;
    JButton start;
    JButton stop;
    JButton trapDetails;
    JButton deleteTrap;
    JButton add;
    JButton delete;
    JButton load;
    JTextField portText;
    JTextField commText;
    JTextField parserText;
    private Vector traptasksList = null;
    private Vector trapList = null;
    private JComboBox portcommBox;
    private DefaultComboBoxModel comboModel = null;
    Font lfont = SnmpUIUtils.getFont();
    String encStr = "ISO8859_1";
    TrapParserBean trapparserbean = null;
    private TrapBrowser trapbrowser = null;
    SasFileDialog fileSasDialog = null;
    JDialog parserFrame;
    JButton closeButton;
    private int port = 162;
    private String community = "public";
    private String[] localAddresses = null;
    private String mibs = null;

    public TrapViewer() {
        this((Applet)null);
    }

    public TrapViewer(Applet applet) {
        Object object;
        this.initVariables();
        this.applet = applet;
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(SnmpUtils.getString("Port"));
        jLabel.setFont(this.lfont);
        jLabel.setForeground(Color.black);
        this.portText = new JTextField(7);
        this.portText.setText(String.valueOf(this.port));
        JLabel jLabel2 = new JLabel(SnmpUtils.getString("Community"));
        jLabel2.setFont(this.lfont);
        jLabel2.setForeground(Color.black);
        this.commText = new JTextField(this.community, 15);
        JLabel jLabel3 = new JLabel(SnmpUtils.getString("TrapList"));
        jLabel3.setFont(this.lfont);
        jLabel3.setForeground(Color.black);
        this.portcommBox = new JComboBox(this.comboModel);
        this.portcommBox.setFont(this.lfont);
        JLabel jLabel4 = new JLabel(SnmpUtils.getString("TrapParser"));
        jLabel4.setFont(this.lfont);
        jLabel4.setForeground(Color.black);
        this.parserText = new JTextField(15);
        this.load = new JButton(SnmpUtils.getString("Load"));
        this.load.setFont(this.lfont);
        if (applet != null && (object = applet.getParameter("PROTOCOL")) != null && ((String)object).trim().equals("2")) {
            this.load.setEnabled(false);
        }
        this.load.addActionListener(this);
        this.settings = new JButton(SnmpUtils.getString("ParserEditor"));
        this.settings.setFont(this.lfont);
        if (applet != null && (object = applet.getParameter("PROTOCOL")) != null && ((String)object).trim().equals("2")) {
            this.settings.setEnabled(false);
        }
        this.settings.addActionListener(this);
        this.start = new JButton(SnmpUtils.getString("Start"));
        this.start.setFont(this.lfont);
        this.start.addActionListener(this);
        this.stop = new JButton(SnmpUtils.getString("Stop"));
        this.stop.setFont(this.lfont);
        this.stop.addActionListener(this);
        this.stop.setEnabled(false);
        this.trapDetails = new JButton(SnmpUtils.getString("Trap Details"));
        this.trapDetails.setFont(this.lfont);
        this.trapDetails.addActionListener(this);
        this.trapDetails.setEnabled(false);
        this.deleteTrap = new JButton(SnmpUtils.getString("Delete Trap"));
        this.deleteTrap.addActionListener(this);
        this.deleteTrap.setFont(this.lfont);
        this.deleteTrap.setEnabled(false);
        this.add = new JButton(SnmpUtils.getString("Add"));
        this.add.setFont(this.lfont);
        this.add.addActionListener(this);
        this.delete = new JButton(SnmpUtils.getString("Del"));
        this.delete.setFont(this.lfont);
        this.delete.addActionListener(this);
        this.delete.setEnabled(false);
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.portText, gridBagConstraints);
        jPanel.add(this.portText);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel.add(jLabel3);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.portcommBox, gridBagConstraints);
        jPanel.add(this.portcommBox);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.add, gridBagConstraints);
        jPanel.add(this.add);
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.delete, gridBagConstraints);
        jPanel.add(this.delete);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.commText, gridBagConstraints);
        jPanel.add(this.commText);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(jLabel4, gridBagConstraints);
        jPanel.add(jLabel4);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagLayout.setConstraints(this.parserText, gridBagConstraints);
        jPanel.add(this.parserText);
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.load, gridBagConstraints);
        jPanel.add(this.load);
        object = new JPanel();
        gridBagLayout = new GridBagLayout();
        ((Container)object).setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.start, gridBagConstraints);
        ((Container)object).add(this.start);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.stop, gridBagConstraints);
        ((Container)object).add(this.stop);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.trapDetails, gridBagConstraints);
        ((Container)object).add(this.trapDetails);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.deleteTrap, gridBagConstraints);
        ((Container)object).add(this.deleteTrap);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.settings, gridBagConstraints);
        ((Container)object).add(this.settings);
        this.trapbrowser = new TrapBrowser(applet);
        this.linkStatus = new LedPanel(48, 16);
        this.statusPanel = new StatusPanel(this.linkStatus);
        this.statusPanel.showStatus(SnmpUtils.getString("Status: "), SnmpUtils.getString("Not Listening for Traps"));
        gridBagLayout = new GridBagLayout();
        gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.trapbrowser, gridBagConstraints);
        this.add(this.trapbrowser);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints((Component)object, gridBagConstraints);
        this.add((Component)object);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.statusPanel, gridBagConstraints);
        this.add(this.statusPanel);
        this.linkStatus.startTheShow();
        this.linkStatus.glowColor(1);
        this.trapparserbean = new TrapParserBean(applet);
        this.trapparserbean.addParserListener(this);
    }

    /*
     * Unable to fully structure code
     */
    public void actionPerformed(ActionEvent var1_1) {
        if (var1_1.getActionCommand().equals(SnmpUtils.getString("Start"))) {
            if (this.portcommBox.getItemCount() == 0) {
                try {
                    this.port = Integer.parseInt(this.portText.getText());
                }
                catch (NumberFormatException v0) {
                    this.statusPanel.showStatus(String.valueOf(SnmpUtils.getString("Error : ")) + " ", String.valueOf(SnmpUtils.getString("Invalid port number : ")) + " " + this.portText.getText());
                    return;
                }
                if (this.port <= 0) {
                    this.statusPanel.showStatus(String.valueOf(SnmpUtils.getString("Warning : ")) + " ", String.valueOf(SnmpUtils.getString("Cannot Listen on port : ")) + " " + this.port);
                    return;
                }
                var2_2 = String.valueOf(this.portText.getText()) + ":" + this.commText.getText();
                this.comboModel.addElement(var2_2);
                this.statusPanel.showStatus(String.valueOf(SnmpUtils.getString("Status : ")) + " ", SnmpUtils.getString("Not Listening for Traps"));
            }
            var2_3 = 0;
            while (var2_3 < this.portcommBox.getItemCount()) {
                block63: {
                    var3_10 = (String)this.portcommBox.getItemAt(var2_3);
                    var4_13 = new StringTokenizer(var3_10, ":");
                    while (var4_13.hasMoreElements()) {
                        try {
                            this.port = Integer.parseInt(var4_13.nextToken());
                        }
                        catch (NumberFormatException v1) {
                            this.statusPanel.showStatus(String.valueOf(SnmpUtils.getString("Error : ")) + " ", String.valueOf(SnmpUtils.getString("Invalid port number : ")) + " " + this.port);
                            return;
                        }
                        this.community = var4_13.nextToken();
                    }
                    var5_15 = new TrapTasks(this, this.applet);
                    var5_15.setCharacterEncoding(this.encStr);
                    this.updateParams(var5_15);
                    try {
                        var5_15.setPortWithExceptionMsg(this.port);
                        this.statusPanel.showStatus(String.valueOf(SnmpUtils.getString("Status : ")) + " ", SnmpUtils.getString("Listening for Traps"));
                        this.start.setEnabled(false);
                        this.stop.setEnabled(true);
                        this.linkStatus.glowColor(2);
                        break block63;
                    }
                    catch (Exception var6_17) {
                        var5_15 = null;
                        ** while (this.traptasksList.size() != 0)
                    }
lbl-1000:
                    // 1 sources

                    {
                        var7_20 = (TrapTasks)this.traptasksList.elementAt(0);
                        this.traptasksList.removeElementAt(0);
                        var7_20.removeTrapListener(this);
                        var7_20.stopReceiver();
                        var7_20 = null;
                        continue;
                    }
lbl47:
                    // 1 sources

                    if (var6_17.getMessage().indexOf("Permission") > 0) {
                        this.statusPanel.showStatus(String.valueOf(SnmpUtils.getString("Error : ")) + " ", String.valueOf(SnmpUtils.getString("Not Listening for Traps")) + ", " + SnmpUtils.getString("Permission Denied"));
                    } else {
                        this.statusPanel.showStatus(String.valueOf(SnmpUtils.getString("Error : ")) + " ", String.valueOf(SnmpUtils.getString("Not Listening for Traps")) + ", " + SnmpUtils.getString("Port(s) already in use"));
                    }
                    this.stop.setEnabled(false);
                    this.start.setEnabled(true);
                    this.linkStatus.glowColor(1);
                    this.add.setEnabled(true);
                    this.delete.setEnabled(true);
                    return;
                }
                var5_15.setCommunity(this.community);
                var5_15.addTrapListener(this);
                this.traptasksList.addElement(var5_15);
                this.add.setEnabled(false);
                this.delete.setEnabled(false);
                ++var2_3;
            }
        } else if (var1_1.getActionCommand().equals(SnmpUtils.getString("Trap Details"))) {
            this.trapbrowser.getTrapDetails();
        } else if (var1_1.getActionCommand().equals(SnmpUtils.getString("Delete Trap"))) {
            this.trapbrowser.deleteTrap();
        } else if (var1_1.getActionCommand().equals(SnmpUtils.getString("Stop"))) {
            while (this.traptasksList.size() != 0) {
                var2_4 = (TrapTasks)this.traptasksList.elementAt(0);
                this.traptasksList.removeElementAt(0);
                var2_4.removeTrapListener(this);
                var2_4.stopReceiver();
                var2_4 = null;
            }
            this.add.setEnabled(true);
            this.delete.setEnabled(true);
            this.stop.setEnabled(false);
            this.start.setEnabled(true);
            this.statusPanel.showStatus(String.valueOf(SnmpUtils.getString("Status : ")) + " ", SnmpUtils.getString("Not Listening for Traps"));
            this.linkStatus.glowColor(1);
        } else if (var1_1.getActionCommand().equals(SnmpUtils.getString("Add"))) {
            if (this.portText.getText().equals("")) {
                this.statusPanel.showStatus(String.valueOf(SnmpUtils.getString("Warning: ")) + " ", SnmpUtils.getString("Port number is not specified"));
                return;
            }
            try {
                this.port = Integer.parseInt(this.portText.getText());
            }
            catch (NumberFormatException v2) {
                this.statusPanel.showStatus(String.valueOf(SnmpUtils.getString("Error : ")) + " ", String.valueOf(SnmpUtils.getString("Invalid port number : ")) + " " + this.portText.getText());
                return;
            }
            if (this.port <= 0) {
                this.statusPanel.showStatus(String.valueOf(SnmpUtils.getString("Warning : ")) + " ", String.valueOf(SnmpUtils.getString("Cannot add this port to the list : ")) + " " + this.port);
                return;
            }
            var2_5 = String.valueOf(this.portText.getText()) + ":" + this.commText.getText();
            if (this.trapList.contains(var2_5)) {
                this.comboModel.setSelectedItem(var2_5);
                this.statusPanel.showStatus(String.valueOf(SnmpUtils.getString("Warning : ")) + " ", SnmpUtils.getString("Already exist in the TrapList"));
                return;
            }
            this.trapList.addElement(var2_5);
            this.comboModel.setSelectedItem(this.trapList.lastElement());
            this.statusPanel.showStatus(String.valueOf(SnmpUtils.getString("Status : ")) + " ", SnmpUtils.getString("Added in the TrapList"));
            this.portcommBox.updateUI();
            if (!this.delete.isEnabled()) {
                this.delete.setEnabled(true);
            }
        } else if (var1_1.getActionCommand().equals(SnmpUtils.getString("Del"))) {
            if (this.portcommBox.getSelectedItem() != null) {
                this.comboModel.removeElement(this.portcommBox.getSelectedItem());
                this.statusPanel.showStatus(String.valueOf(SnmpUtils.getString("Status : ")) + " ", SnmpUtils.getString("Deleted from the TrapList"));
                if (this.trapList.size() != 0) {
                    this.comboModel.setSelectedItem(this.trapList.firstElement());
                } else {
                    this.delete.setEnabled(false);
                }
            } else {
                this.statusPanel.showStatus(String.valueOf(SnmpUtils.getString("Warning : ")) + " ", SnmpUtils.getString("Select an item from the TrapList"));
            }
        } else if (var1_1.getActionCommand().equals(SnmpUtils.getString("ParserEditor"))) {
            if (this.parserFrame == null) {
                var2_6 = new TrapParserCustomizer();
                var3_11 = new TrapParserBean(this.applet);
                var3_11.setMibOperations(this.mibOps);
                var2_6.setObject(var3_11);
                this.parserFrame = new JDialog();
                this.parserFrame.setTitle(SnmpUtils.getString("Trap Parser"));
                this.closeButton = new JButton(SnmpUtils.getString("Close"));
                this.closeButton.setFont(this.lfont);
                this.closeButton.addActionListener(this);
                this.parserFrame.getContentPane().add("Center", var2_6);
                this.parserFrame.addWindowListener(new WindowAdapter(){

                    public void windowClosed(WindowEvent windowEvent) {
                        if (TrapViewer.this.parserFrame != null) {
                            ((Component)TrapViewer.this.parserFrame).setVisible(false);
                        }
                    }
                });
                this.parserFrame.getContentPane().add("South", this.closeButton);
                this.parserFrame.pack();
            }
            this.parserFrame.setVisible(true);
        } else if (var1_1.getActionCommand().equals(SnmpUtils.getString("Close"))) {
            this.parserFrame.setVisible(false);
        } else if (var1_1.getActionCommand().equals("Exit All")) {
            this.linkStatus.stopTheShow();
            if (this.parserFrame != null) {
                this.parserFrame.setVisible(false);
                var2_7 = (TrapParserCustomizer)this.parserFrame.getContentPane().getComponent(0);
                var2_7.removeAll();
                var2_7 = null;
                this.parserFrame.getContentPane().removeAll();
                this.parserFrame.dispose();
                this.parserFrame = null;
            }
            this.linkStatus = null;
            this.statusPanel = null;
            this.trapparserbean = null;
            this.trapbrowser = null;
        } else if (var1_1.getActionCommand().equals(SnmpUtils.getString("Load"))) {
            if (this.applet == null) {
                var2_8 = new JFileChooser();
                var2_8.setDialogTitle(SnmpUtils.getString("Load Parser File"));
                var2_8.setCurrentDirectory(new File(System.getProperty("user.dir")));
                var3_12 = new CustomFileFilter("parser");
                var2_8.addChoosableFileFilter(var3_12);
                var2_8.setVisible(true);
                var4_14 = var2_8.showOpenDialog(this);
                if (var4_14 == 0) {
                    var5_16 = var2_8.getSelectedFile();
                    if (var5_16 == null) {
                        return;
                    }
                    try {
                        var6_18 = var5_16.getCanonicalPath();
                        var7_21 = System.getProperty("user.dir");
                        var8_23 = FileUtils.getRelativePath(var7_21, var6_18, ".");
                        if (!var8_23.endsWith(".parser")) {
                            Utils.err(SnmpUtils.getString("Parser file must have .parser extension"));
                            return;
                        }
                        this.parserText.setText(var8_23.toString());
                    }
                    catch (Exception v3) {
                        var6_19 = var5_16.getName();
                        var7_22 = var2_8.getCurrentDirectory().toString();
                        if (var7_22 != null && var6_19 != null) {
                            this.parserText.setText(String.valueOf(var7_22.trim()) + File.separator + var6_19);
                        }
                        return;
                    }
                } else {
                    return;
                }
                if (this.parserText.getText().trim().equals("")) {
                    return;
                }
                this.setFileName(this.parserText.getText());
            } else {
                this.fileSasDialog = new SasFileDialog(this.applet);
                this.fileSasDialog.setFileExtension(".parser");
                this.fileSasDialog.addActionListener(this);
                this.fileSasDialog.init();
                this.fileSasDialog.setDirectory("/");
                this.fileSasDialog.FileType.setSelectedItem("Parser Files(*.parser)");
                this.fileSasDialog.setSize(new Dimension(500, 380));
                Utils.centerWindow(this.fileSasDialog);
                this.fileSasDialog.show();
            }
        } else if (var1_1.getActionCommand().equals("DisableTrapButtons")) {
            this.trapDetails.setEnabled(false);
            this.deleteTrap.setEnabled(false);
        } else if (var1_1.getActionCommand().equals("EnableDeleteButton")) {
            this.deleteTrap.setEnabled(true);
        } else if (var1_1.getActionCommand().equals("EnableDetailsButton")) {
            this.trapDetails.setEnabled(true);
        }
        if (var1_1.getSource().equals(this.fileSasDialog) && var1_1.getActionCommand().equals(SnmpUtils.getString("Open")) && (var2_9 = this.fileSasDialog.getSelectedFileUrl()) != null) {
            if (!var2_9.endsWith(".parser")) {
                Utils.err("file must have .parser extension");
                return;
            }
            this.parserText.setText(this.fileSasDialog.getSelectedFileUrl());
            this.setFileName(this.parserText.getText());
        }
    }

    public void eventParsed(ParsedTrapEvent parsedTrapEvent) {
        this.trapbrowser.displayEvent(parsedTrapEvent);
        this.deleteTrap.setEnabled(true);
        this.trapDetails.setEnabled(true);
    }

    protected void finalize() throws Throwable {
        this.stop();
        this.linkStatus.stopTheShow();
        this.linkStatus = null;
        this.trapparserbean = null;
        this.trapbrowser = null;
    }

    public String getCharacterEncoding() {
        return this.encStr;
    }

    public String getCommunity() {
        return this.commText.getText();
    }

    DebugInterface getDebugInterface() {
        return this.di;
    }

    public String getFileName() {
        return this.trapparserbean.getFileName();
    }

    public String[] getLocalAddresses() {
        return this.localAddresses;
    }

    public String getMibModules() {
        return this.mibs;
    }

    public int getPort() {
        return Integer.parseInt(this.portText.getText());
    }

    private void initVariables() {
        this.traptasksList = new Vector();
        this.trapList = new Vector();
        this.comboModel = new DefaultComboBoxModel(this.trapList);
    }

    public void receivedTrap(TrapEvent trapEvent) {
        this.trapparserbean.parseEvtAndFire(trapEvent);
    }

    public void setCharacterEncoding(String string) {
        this.encStr = string;
    }

    public void setCommunity(String string) {
        this.commText.setText(string);
    }

    void setDebugInterface(DebugInterface debugInterface) {
        this.di = debugInterface;
    }

    public void setFileName(String string) {
        this.trapparserbean.setFileName(string);
    }

    public void setLocalAddresses(String[] stringArray) {
        this.localAddresses = stringArray;
    }

    public void setMibModules(String string) {
        this.mibs = string;
    }

    void setMibOperations(MibOperations mibOperations) {
        this.mibOps = mibOperations;
        this.trapparserbean.setMibOperations(this.mibOps);
    }

    public void setPort(int n) throws SnmpException {
        if (n <= 0) {
            throw new SnmpException(String.valueOf(SnmpUtils.getString("Cannot listen on the specified port : ")) + " " + n);
        }
        this.port = n;
        this.portText.setText(String.valueOf(n));
    }

    public void stop() {
        while (this.traptasksList.size() != 0) {
            TrapTasks trapTasks = (TrapTasks)this.traptasksList.elementAt(0);
            this.traptasksList.removeElementAt(0);
            trapTasks.removeTrapListener(this);
            trapTasks.stop();
            trapTasks = null;
        }
        this.linkStatus.glowColor(1);
    }

    private void updateParams(TrapTasks trapTasks) {
        if (this.localAddresses != null) {
            trapTasks.setLocalAddresses(this.localAddresses);
        }
        if (this.mibs != null) {
            trapTasks.setMibModules(this.mibs);
            if (this.mibOps != null) {
                this.trapparserbean.setMibOperations(this.mibOps);
            } else {
                this.trapparserbean.setMibOperations(trapTasks.getMibOperations());
            }
            this.trapbrowser.loadMibs(this.mibs);
        }
    }
}

