/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.ui;

import com.adventnet.snmp.ui.MessageWindow;
import com.adventnet.utils.SnmpUtils;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JComponent;

class Utils {
    static Applet applet;
    public static boolean debug;
    static Point screenCenter;

    static {
        debug = true;
    }

    Utils() {
    }

    public static void centerWindow(Component component) {
        if (screenCenter == null) {
            Utils.setScreenSize(Toolkit.getDefaultToolkit().getScreenSize());
        }
        int n = Utils.screenCenter.x - component.getSize().width / 2;
        int n2 = Utils.screenCenter.y - component.getSize().height / 2 - 50;
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        component.setLocation(n, n2);
    }

    public static void debug(String string) {
        if (debug) {
            System.out.println(string);
        }
    }

    public static void err(String string) {
        MessageWindow.showMessage(null, SnmpUtils.getString("Error Message"), string, 6, 60);
    }

    public static void err(String string, Throwable throwable) {
        System.err.println(String.valueOf(string) + ": " + throwable);
        throwable.printStackTrace();
    }

    public static void err(Throwable throwable) {
        if (debug) {
            throwable.printStackTrace();
        }
    }

    static void fixSize(JComponent jComponent, int n, int n2) {
        jComponent.setSize(new Dimension(n, n2));
        jComponent.setMinimumSize(new Dimension(n, n2));
        jComponent.setPreferredSize(new Dimension(n, n2));
        jComponent.setMaximumSize(new Dimension(n, n2));
    }

    public static synchronized void init(Applet applet) {
        Utils.applet = applet;
    }

    static JComponent minSize(JComponent jComponent, int n, int n2) {
        jComponent.setMinimumSize(new Dimension(n, n2));
        return jComponent;
    }

    static void openHelp(String string, Applet applet) {
        block2: {
            if (applet == null) break block2;
            try {
                URL uRL = new URL(applet.getDocumentBase(), string);
                applet.getAppletContext().showDocument(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                Utils.err("Error opening page" + malformedURLException);
            }
        }
    }

    public static void out(String string) {
        System.out.println(string);
    }

    static JComponent prefSize(JComponent jComponent, int n, int n2) {
        jComponent.setPreferredSize(new Dimension(n, n2));
        return jComponent;
    }

    public static void setScreenSize(Dimension dimension) {
        screenCenter = new Point(dimension.width / 2, dimension.height / 2);
    }
}

