/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.snmp.utils;

import com.adventnet.snmp.snmp2.SnmpException;
import com.adventnet.snmp.snmp2.SnmpMessage;
import com.adventnet.snmp.snmp2.SnmpPDU;
import com.adventnet.utils.SnmpUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.StringTokenizer;

public class SnmpDecoder {
    SnmpMessage msg = null;
    SnmpPDU pdu = null;
    String result = "";
    String error = "";

    public boolean decode(SnmpPDU snmpPDU) {
        block4: {
            this.result = String.valueOf(SnmpUtils.getString("PDU")) + " :\n" + this.getOctets(snmpPDU.getData(), snmpPDU.getData().length);
            this.error = "";
            if (snmpPDU != null) {
                try {
                    if (!snmpPDU.decode()) {
                        this.error = SnmpUtils.getString("Decode error");
                        return false;
                    }
                    break block4;
                }
                catch (Exception exception) {
                    this.error = String.valueOf(SnmpUtils.getString("Exception :")) + "  " + exception.getMessage();
                    return false;
                }
            }
            return false;
        }
        return this.setPDUResults(snmpPDU);
    }

    public boolean decode(String string) {
        this.result = "";
        this.error = "";
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            fileInputStream = new FileInputStream(string);
            bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        }
        catch (Exception exception) {
            this.error = String.valueOf(SnmpUtils.getString("Exception :")) + " " + exception.getMessage();
            return false;
        }
        String string2 = "";
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
        try {
            int n = streamTokenizer.nextToken();
            while (n != -1) {
                if (streamTokenizer.ttype == -3) {
                    if (streamTokenizer.sval.length() == 1) {
                        string2 = string2.substring(0, string2.length() - 1);
                        string2 = String.valueOf(string2) + streamTokenizer.sval;
                    } else {
                        string2 = String.valueOf(string2) + streamTokenizer.sval;
                    }
                } else if (streamTokenizer.ttype == -2) {
                    string2 = String.valueOf(string2) + Long.toString((long)streamTokenizer.nval);
                }
                n = streamTokenizer.nextToken();
                string2 = String.valueOf(string2) + " ";
            }
        }
        catch (Exception exception) {
            this.error = String.valueOf(SnmpUtils.getString("Exception : ")) + " " + exception.getMessage();
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        byte[] byArray = new byte[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            try {
                byArray[n++] = (byte)Integer.parseInt(stringTokenizer.nextToken(), 16);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println(String.valueOf(SnmpUtils.getString("File contains Non SNMP Message(s).")) + "\n" + numberFormatException.getMessage());
            }
        }
        return this.decode(byArray);
    }

    public boolean decode(byte[] byArray) {
        block6: {
            this.result = String.valueOf(SnmpUtils.getString("PDU")) + " :\n" + this.getOctets(byArray, byArray.length);
            this.error = "";
            try {
                this.msg = new SnmpMessage(byArray);
            }
            catch (Exception exception) {
                this.error = String.valueOf(SnmpUtils.getString("Exception :")) + " " + exception.getMessage();
                return false;
            }
            this.pdu = this.msg.getPDU();
            if (this.pdu != null) {
                try {
                    if (!this.pdu.decode()) {
                        this.error = SnmpUtils.getString("Decode error");
                        return false;
                    }
                    break block6;
                }
                catch (Exception exception) {
                    this.error = String.valueOf(SnmpUtils.getString("Exception :")) + " " + exception.getMessage();
                    return false;
                }
            }
            return false;
        }
        return this.setPDUResults(this.pdu);
    }

    public String getErrorString() {
        return this.error.toString();
    }

    private String getOctets(byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 20;
        if (byArray.length < n) {
            n = byArray.length;
        }
        int n4 = 0;
        while (n4 < n) {
            String string;
            if (n2++ > 19) {
                n2 = 1;
                stringBuffer.append("\n");
            }
            if ((string = Integer.toString(byArray[n4] & 0xFF, 16)).length() < 2) {
                string = "0" + string;
            }
            stringBuffer.append(String.valueOf(string) + " ");
            ++n4;
        }
        return stringBuffer.toString();
    }

    private String getPDUCommand(byte by) {
        String string = "";
        switch (by) {
            case -96: {
                string = SnmpUtils.getString("Get Request");
                break;
            }
            case -95: {
                string = SnmpUtils.getString("GetNext Request");
                break;
            }
            case -94: {
                string = SnmpUtils.getString("Get Response");
                break;
            }
            case -93: {
                string = SnmpUtils.getString("Set Request");
                break;
            }
            case -92: {
                string = SnmpUtils.getString("v1 Trap");
                break;
            }
            default: {
                string = SnmpUtils.getString("Unknown");
            }
        }
        return string;
    }

    private String getPDUVersion(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = SnmpUtils.getString("v1");
                break;
            }
            case 1: {
                string = SnmpUtils.getString("v2c");
                break;
            }
            case 2: {
                string = SnmpUtils.getString("v2");
                break;
            }
            case 3: {
                string = SnmpUtils.getString("v3");
                break;
            }
        }
        return string;
    }

    public String getResultString() {
        return this.result.toString();
    }

    private boolean setPDUResults(SnmpPDU snmpPDU) {
        this.result = String.valueOf(this.result) + "\n" + SnmpUtils.getString("Version") + " : " + snmpPDU.getVersion() + "(" + this.getPDUVersion(snmpPDU.getVersion()) + ")" + "\n" + SnmpUtils.getString("Community") + " : " + snmpPDU.getCommunity() + "\n" + SnmpUtils.getString("Command") + " : " + this.getPDUCommand(snmpPDU.getCommand()) + "\n" + SnmpUtils.getString("Request ID:") + " " + snmpPDU.getReqid() + "\n";
        if (snmpPDU.getCommand() == -92) {
            this.result = String.valueOf(this.result) + SnmpUtils.getString("Generic Type") + " : " + snmpPDU.getTrapType() + "\n" + SnmpUtils.getString("Specific Type") + " : " + snmpPDU.getSpecificType() + "\n" + SnmpUtils.getString("Enterprise OID") + " : " + snmpPDU.getEnterprise().toString() + "\n" + SnmpUtils.getString("Agent Address") + " : " + snmpPDU.getAgentAddr() + "\n";
        }
        this.result = String.valueOf(this.result) + SnmpUtils.getString("Error Status:") + " " + snmpPDU.getErrstat() + "(" + SnmpException.exceptionString((byte)snmpPDU.getErrstat()) + ")" + "\n" + SnmpUtils.getString("Error Index:") + " " + snmpPDU.getErrindex() + "\n" + SnmpUtils.getString("Varbinds") + " : " + "\n" + snmpPDU.printVarBinds();
        return true;
    }
}

