/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.utils;

import com.adventnet.utils.SnmpUIUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ButtonPanel
extends JPanel {
    JButton[] buttons = null;
    public boolean drawBorder = true;

    public ButtonPanel(String[] stringArray, ActionListener actionListener) {
        this.init(stringArray, null, null, actionListener);
    }

    public ButtonPanel(String[] stringArray, ActionListener[] actionListenerArray) {
        this.init(stringArray, null, actionListenerArray, null);
    }

    public ButtonPanel(String[] stringArray, String[] stringArray2) {
        this.init(stringArray, stringArray2, null, null);
    }

    public ButtonPanel(String[] stringArray, String[] stringArray2, ActionListener actionListener) {
        this.init(stringArray, stringArray2, null, actionListener);
    }

    public ButtonPanel(String[] stringArray, String[] stringArray2, ActionListener[] actionListenerArray) {
        this.init(stringArray, stringArray2, actionListenerArray, null);
    }

    public void addButton(JButton jButton) {
        jButton.setFont(SnmpUIUtils.getFont());
        this.add(jButton);
    }

    private void init(String[] stringArray, String[] stringArray2, ActionListener[] actionListenerArray, ActionListener actionListener) {
        int n;
        if (stringArray == null) {
            return;
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.setLayout(gridBagLayout);
        this.buttons = new JButton[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.buttons[n2] = new JButton(stringArray[n2]);
            gridBagLayout.setConstraints(this.buttons[n2], gridBagConstraints);
            this.buttons[n2].setActionCommand(stringArray[n2]);
            ++n2;
        }
        if (stringArray2 != null) {
            n = 0;
            while (n < stringArray.length) {
                this.buttons[n].setToolTipText(stringArray2[n]);
                ++n;
            }
        }
        if (actionListenerArray != null && actionListenerArray.length == this.buttons.length) {
            n = 0;
            while (n < stringArray.length) {
                this.buttons[n].addActionListener(actionListenerArray[n]);
                ++n;
            }
        }
        if (actionListener != null) {
            n = 0;
            while (n < stringArray.length) {
                this.buttons[n].addActionListener(actionListener);
                ++n;
            }
        }
        this.thisLayout();
    }

    public boolean isEnabledIndex(int n) {
        if (n < this.buttons.length) {
            return this.buttons[n].isEnabled();
        }
        return false;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.drawBorder) {
            int n = this.getSize().width;
            int n2 = this.getSize().height;
            graphics.setColor(Color.white);
            graphics.setColor(Color.gray);
        }
    }

    public void setEnabledButtons(boolean bl) {
        int n = 0;
        while (n < this.buttons.length) {
            this.buttons[n].setEnabled(bl);
            ++n;
        }
    }

    public void setEnabledIndex(int n, boolean bl) {
        if (n < this.buttons.length) {
            this.buttons[n].setEnabled(bl);
        }
    }

    public void setTextIndex(int n, String string) {
        if (n < this.buttons.length) {
            this.buttons[n].setText(string);
            this.buttons[n].setActionCommand(string);
        }
    }

    void thisLayout() {
        int n = 0;
        while (n < this.buttons.length) {
            this.buttons[n].setFont(SnmpUIUtils.getFont());
            this.add(this.buttons[n]);
            ++n;
        }
    }

    private void toDo() {
    }
}

