/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.utils;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.JPanel;

public class LedPanel
extends JPanel
implements Runnable {
    public static final int ON = 0;
    public static final int RED = 1;
    public static final int GREEN = 2;
    public static final int ORANGE = 3;
    public static final int OFF = 4;
    private static final int NUM_OF_IMAGES = 5;
    private Image[] imgArr = new Image[5];
    private int colorChoice = 0;
    private int mywidth;
    private int myheight;
    private boolean greenFlag;
    private boolean stopMyThread = false;
    private Thread myThread = null;

    public LedPanel(int n, int n2) {
        this.setLayout(null);
        this.mywidth = n;
        this.myheight = n2;
        String[] stringArray = new String[]{"images/image1.jpg", "images/image2.jpg", "images/image3.jpg", "images/image4.jpg", "images/image5.jpg"};
        int n3 = 0;
        while (n3 < 5) {
            this.imgArr[n3] = this.getImage(stringArray[n3]);
            ++n3;
        }
        this.greenFlag = false;
    }

    private Image getImage(String string) {
        try {
            URL uRL = this.getClass().getResource(String.valueOf(string));
            return Toolkit.getDefaultToolkit().getImage(uRL);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.mywidth, this.myheight);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.mywidth, this.myheight);
    }

    public void glowColor(int n) {
        this.greenFlag = n == 2;
    }

    public void paintComponent(Graphics graphics) {
        graphics.drawImage(this.imgArr[this.colorChoice], 0, 0, this);
    }

    public void run() {
        while (this.stopMyThread) {
            this.colorChoice = this.greenFlag ? 2 : 1;
            this.repaint();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
            this.colorChoice = 4;
            this.repaint();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void startTheShow() {
        if (this.myThread == null) {
            this.myThread = new Thread(this);
            this.stopMyThread = true;
            this.myThread.start();
        }
    }

    public void stopTheShow() {
        this.stopMyThread = false;
        this.myThread = null;
    }
}

