/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.utils;

import com.adventnet.utils.SnmpUIUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class RadioGroupPanel
extends JPanel {
    JRadioButton[] radiobuttons = null;
    Font lfont = SnmpUIUtils.getFont();

    public RadioGroupPanel(String string, String[] stringArray) {
        this.init(string, stringArray, null, null);
    }

    public RadioGroupPanel(String string, String[] stringArray, ActionListener actionListener) {
        this.init(string, stringArray, null, actionListener);
    }

    public RadioGroupPanel(String string, String[] stringArray, ActionListener[] actionListenerArray) {
        this.init(string, stringArray, actionListenerArray, null);
    }

    public int getSelectedIndex() {
        int n = 0;
        while (n < this.radiobuttons.length) {
            if (this.radiobuttons[n].isSelected()) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void init(String string, String[] stringArray, ActionListener[] actionListenerArray, ActionListener actionListener) {
        int n;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.radiobuttons = new JRadioButton[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.radiobuttons[n2] = new JRadioButton(stringArray[n2]);
            this.radiobuttons[n2].setFont(this.lfont);
            buttonGroup.add(this.radiobuttons[n2]);
            ++n2;
        }
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(this.lfont);
        jLabel.setForeground(Color.black);
        this.add(jLabel);
        int n3 = 0;
        while (n3 < stringArray.length) {
            gridBagConstraints.gridx = n3 + 1;
            gridBagLayout.setConstraints(this.radiobuttons[n3], gridBagConstraints);
            this.add(this.radiobuttons[n3]);
            ++n3;
        }
        if (actionListenerArray != null && actionListenerArray.length == stringArray.length) {
            n = 0;
            while (n < stringArray.length) {
                this.radiobuttons[n].addActionListener(actionListenerArray[n]);
                ++n;
            }
        }
        if (actionListener != null) {
            n = 0;
            while (n < stringArray.length) {
                this.radiobuttons[n].addActionListener(actionListener);
                ++n;
            }
        }
    }

    public void isEnabled(int n) {
        if (n <= this.radiobuttons.length) {
            this.radiobuttons[n].isEnabled();
        }
    }

    public void setEnabledIndex(int n, boolean bl) {
        if (n <= this.radiobuttons.length) {
            this.radiobuttons[n].setEnabled(bl);
        }
    }

    public void setSelectedIndex(int n) {
        if (n <= this.radiobuttons.length) {
            this.radiobuttons[n].setSelected(true);
        }
    }
}

