/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.utils;

import com.adventnet.utils.SnmpUtils;
import com.adventnet.utils.WorkerThread;
import java.applet.Applet;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Scheduler
extends Thread {
    int MAX_THREADS = 4;
    private static int DEFAULT_MAX_THREADS = 4;
    static int TOTAL_THREADS = 0;
    static boolean STOP_ALL = false;
    boolean STOP_THIS = false;
    int NUM_THREADS_STOPPED = 0;
    Vector runnables = new Vector();
    Vector times = new Vector();
    Vector workers = new Vector();
    Vector ready_tasks = new Vector();
    private static Hashtable schedulers = new Hashtable(15);
    private static Hashtable maxThreads = new Hashtable(15);
    private static String confFile = "conf/threads.conf";
    private static boolean readConfFile = false;
    static Applet applet = null;
    static int STOP_TIME_OUT = 15;

    private Scheduler(String string) {
        this(string, DEFAULT_MAX_THREADS);
    }

    private Scheduler(String string, int n) {
        super(string);
        this.MAX_THREADS = n;
    }

    public boolean cleanUp() {
        if (this.isAlive()) {
            return false;
        }
        Hashtable hashtable = schedulers;
        synchronized (hashtable) {
            this.times.removeAllElements();
            this.runnables.removeAllElements();
            this.ready_tasks.removeAllElements();
            this.workers.removeAllElements();
            schedulers.remove(this.getName());
            boolean bl = true;
            Object var3_3 = null;
            return bl;
        }
    }

    public static Scheduler createScheduler(Applet applet, String string) {
        Scheduler.applet = applet;
        return Scheduler.createScheduler(string, -1);
    }

    public static Scheduler createScheduler(String string) {
        return Scheduler.createScheduler(string, -1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Scheduler createScheduler(String string, int n) {
        Hashtable hashtable = schedulers;
        synchronized (hashtable) {
            Integer n2;
            if (string == null) {
                return null;
            }
            Scheduler scheduler = Scheduler.getScheduler(string);
            if (scheduler != null && scheduler.isAlive()) {
                return scheduler;
            }
            scheduler = n <= 0 || n > 100 ? ((n2 = (Integer)maxThreads.get(string)) != null ? new Scheduler(string, n2) : new Scheduler(string)) : new Scheduler(string, n);
            schedulers.put(string, scheduler);
            return scheduler;
        }
    }

    public static String getConfFile() {
        return confFile;
    }

    public static int getDefaultMaxThreads() {
        return DEFAULT_MAX_THREADS;
    }

    public int getMaxThreads() {
        return this.MAX_THREADS;
    }

    synchronized Runnable getNextTask() {
        if (this.ready_tasks.size() == 0) {
            return null;
        }
        Runnable runnable = (Runnable)this.ready_tasks.firstElement();
        this.ready_tasks.removeElement(runnable);
        return runnable;
    }

    public static Scheduler getScheduler(String string) {
        if (string == null) {
            return null;
        }
        return (Scheduler)schedulers.get(string);
    }

    synchronized Runnable getTheWork() {
        Date date;
        while (this.times.size() == 0) {
            try {
                this.wait(10L);
                if (!STOP_ALL && !this.STOP_THIS) continue;
                return null;
            }
            catch (InterruptedException interruptedException) {}
        }
        Date date2 = (Date)this.times.firstElement();
        if (date2.after(date = new Date())) {
            return null;
        }
        Runnable runnable = (Runnable)this.runnables.firstElement();
        this.runnables.removeElement(runnable);
        this.times.removeElement(date2);
        return runnable;
    }

    public static int getTotalThreads() {
        return TOTAL_THREADS;
    }

    public synchronized void removeTask(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        int n = 0;
        while (n < this.runnables.size()) {
            Runnable runnable2 = (Runnable)this.runnables.elementAt(n);
            if (runnable.equals(runnable2)) {
                this.runnables.removeElement(runnable2);
                this.times.removeElementAt(n);
                --n;
            }
            ++n;
        }
    }

    public boolean resumeAll() {
        Hashtable hashtable = schedulers;
        synchronized (hashtable) {
            if (!STOP_ALL) {
                boolean bl = false;
                Object var3_3 = null;
                return bl;
            }
            STOP_ALL = false;
            Enumeration enumeration = schedulers.elements();
            while (enumeration.hasMoreElements()) {
                Scheduler scheduler = (Scheduler)enumeration.nextElement();
                scheduler.start();
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        var1_1 = Scheduler.schedulers;
        synchronized (var1_1) {
            Scheduler.STOP_ALL = false;
            this.STOP_THIS = false;
        }
        this.startWorkers();
        if (this.MAX_THREADS != 0) ** GOTO lbl25
        return;
lbl-1000:
        // 1 sources

        {
            try {
                var1_1 = this.getTheWork();
                if (var1_1 == null) {
                    try {
                        this.waitSchedule();
                    }
                    catch (InterruptedException v1) {}
                    continue;
                }
                this.startTask((Runnable)var1_1);
                continue;
            }
            catch (Exception var1_2) {
                System.err.println(String.valueOf(SnmpUtils.getString("Exception scheduling task in scheduler:")) + " " + this.getName() + " " + var1_2);
                var1_2.printStackTrace();
            }
lbl25:
            // 5 sources

            ** while (!Scheduler.STOP_ALL && !this.STOP_THIS)
        }
lbl26:
        // 1 sources

    }

    public synchronized void scheduleTask(Runnable runnable, Date date) {
        if (date == null) {
            date = new Date();
        }
        int n = 0;
        while (n < this.times.size()) {
            Date date2 = (Date)this.times.elementAt(n);
            if (date2.after(date)) {
                this.times.insertElementAt(date, n);
                this.runnables.insertElementAt(runnable, n);
                return;
            }
            ++n;
        }
        this.times.addElement(date);
        this.runnables.addElement(runnable);
        this.notifyAll();
    }

    public static void setConfFile(String string) {
        confFile = string;
    }

    public static void setDefaultMaxThreads(int n) {
        if (n >= 0 && n < 100) {
            DEFAULT_MAX_THREADS = n;
        }
    }

    public boolean setMaxThreads(int n) {
        if (this.isAlive()) {
            return false;
        }
        if (n >= 0 && n < 100) {
            this.MAX_THREADS = n;
            return true;
        }
        return false;
    }

    public void setStopTimeout(int n) {
        STOP_TIME_OUT = n;
    }

    synchronized void startTask(Runnable runnable) {
        this.ready_tasks.addElement(runnable);
        int n = 0;
        while (n < this.workers.size()) {
            WorkerThread workerThread = (WorkerThread)this.workers.elementAt(n);
            workerThread.wakeUp();
            ++n;
        }
    }

    synchronized void startWorkers() {
        if (STOP_ALL || this.STOP_THIS) {
            return;
        }
        this.workers = new Vector();
        int n = 0;
        while (n < this.MAX_THREADS) {
            ++TOTAL_THREADS;
            WorkerThread workerThread = new WorkerThread(this, String.valueOf(this.getName()) + "-" + (n + 1));
            this.workers.addElement(workerThread);
            workerThread.start();
            ++n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean stopAll() {
        Hashtable hashtable = schedulers;
        synchronized (hashtable) {
            if (STOP_ALL) {
                return false;
            }
            int n = 0;
            STOP_ALL = true;
            int n2 = TOTAL_THREADS;
            while (TOTAL_THREADS > 0) {
                if (n >= STOP_TIME_OUT) {
                    System.err.println(String.valueOf(SnmpUtils.getString("Schedulers did not stop properly: ")) + " " + (n2 - TOTAL_THREADS) + " " + SnmpUtils.getString("threads stopped out of") + " " + n2);
                    System.err.println(String.valueOf(SnmpUtils.getString("The remaining")) + " " + TOTAL_THREADS + " " + SnmpUtils.getString("threads did not stop in") + " " + STOP_TIME_OUT + " " + SnmpUtils.getString("seconds"));
                    return false;
                }
                try {
                    Thread.sleep(1000L);
                    ++n;
                }
                catch (Exception exception) {}
            }
            System.out.println(String.valueOf(n2 - TOTAL_THREADS) + " " + SnmpUtils.getString("of the") + n2 + " " + SnmpUtils.getString("active threads in the control") + " " + SnmpUtils.getString("of the schedulers stopped"));
            TOTAL_THREADS = 0;
            return true;
        }
    }

    public boolean stopThis() {
        int n = 0;
        this.STOP_THIS = true;
        while (this.NUM_THREADS_STOPPED < this.MAX_THREADS) {
            if (n >= STOP_TIME_OUT) {
                System.err.println(String.valueOf(SnmpUtils.getString("Scheduler:")) + " " + this.getName() + SnmpUtils.getString("did not stop properly:") + " " + this.NUM_THREADS_STOPPED + " " + SnmpUtils.getString("threads stopped out of") + " " + this.MAX_THREADS);
                System.err.println(String.valueOf(SnmpUtils.getString("The remaining")) + " " + (this.MAX_THREADS - this.NUM_THREADS_STOPPED) + " " + SnmpUtils.getString("threads of scheduler:") + " " + this.getName() + " " + SnmpUtils.getString("did not stop in") + " " + STOP_TIME_OUT + " " + SnmpUtils.getString("seconds"));
                return false;
            }
            try {
                Thread.sleep(1000L);
                ++n;
            }
            catch (Exception exception) {}
        }
        System.out.println(String.valueOf(this.NUM_THREADS_STOPPED) + SnmpUtils.getString("out of") + " " + this.MAX_THREADS + " " + SnmpUtils.getString("active threads stopped in") + " " + SnmpUtils.getString("Scheduler:") + " " + this.getName());
        return true;
    }

    synchronized void waitSchedule() throws InterruptedException {
        this.wait(10L);
    }
}

