/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.utils;

import com.adventnet.utils.Scheduler;
import com.adventnet.utils.SnmpUtils;

public class WorkerThread
extends Thread {
    Scheduler scheduler = null;

    public WorkerThread(Scheduler scheduler, String string) {
        super(string);
        this.scheduler = scheduler;
    }

    public void run() {
        while (!Scheduler.STOP_ALL && !this.scheduler.STOP_THIS) {
            try {
                this.waitUntilAsked();
                Runnable runnable = this.scheduler.getNextTask();
                if (runnable == null) continue;
                runnable.run();
            }
            catch (Exception exception) {
                System.err.println(String.valueOf(SnmpUtils.getString("Exception running task: ")) + " " + exception);
                exception.printStackTrace();
            }
        }
        ++this.scheduler.NUM_THREADS_STOPPED;
        --Scheduler.TOTAL_THREADS;
    }

    synchronized void waitUntilAsked() {
        while (this.scheduler.ready_tasks.size() == 0 && !Scheduler.STOP_ALL) {
            try {
                this.wait(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    synchronized void wakeUp() {
        this.notifyAll();
    }
}

