import com.adventnet.snmp.beans.*;
import com.adventnet.snmp.snmp2.*;
import java.lang.reflect.*;
import java.util.*;
import java.sql.*;

public class Manager{
    private static final String NMS_node_info_scheme="(ip_address varchar(20), port integer, sysName varchar(50),ipDefaultTTL integer,tcpMaxConnection integer,sysDesc varchar(200))";
    private static final String NMS_stats_scheme="(ipInRecieves integer, ipForwDatagrams integer, ipInDiscards integer, ipInDelivers integer, ipOutRequests integer, ipOutDiscards integer, udpInDatagrams integer, udpOutDatagrams integer, tcpInSegs integer, tcpOutSegs integer, tcpRetransSegs integer, sysUpTime integer, ip_address varchar(20), time date)";

    public static void main(String args[]) throws Exception{

	int TIMEOUT = Config.TIMEOUT;
	int RETRIES =Config.RETRIES;
	double REPEAT_TIME=Config.REPEAT_TIME;
	//    String connectionDriver=Config.connectionDriver;
	String connectionServer=Config.connectionServer;
	String connectionName=Config.connectionName;
	String connectionPasswd=Config.connectionPasswd;
	    
	Connection con = null;
	Statement stmt = null;
	
	String objectIDList_NMS_Stats[]={      //object ID List 
	    ".1.3.6.1.2.1.4.3.0", //ipInReceives
	    ".1.3.6.1.2.1.4.6.0", //ipForwDatagrams 
	    ".1.3.6.1.2.1.4.8.0", //ipInDiscards
	    ".1.3.6.1.2.1.4.9.0", //ipInDelivers
	    ".1.3.6.1.2.1.4.10.0", //ipOutRequests
	    ".1.3.6.1.2.1.4.11.0", //ipOutDiscards
	    ".1.3.6.1.2.1.7.1.0", //udpInDatagrams
	    ".1.3.6.1.2.1.7.4.0", //udpOutDatagrams
	    ".1.3.6.1.2.1.6.10.0", //tcpInSegs 
	    ".1.3.6.1.2.1.6.11.0", //tcpOutSegs
	    ".1.3.6.1.2.1.6.12.0", //tcpRetransSegs
	    ".1.3.6.1.2.1.1.3.0", //sysUpTime
	    ".1.3.6.1.2.1.2.2.1.10.1", //ifInOctets.1            ?
	    ".1.3.6.1.2.1.2.2.1.13.1", //ifInDiscards.1          ?
	    ".1.3.6.1.2.1.2.2.1.16.1", //ifOutOctets.1           ?
	    ".1.3.6.1.2.1.2.2.1.19.1", //ifOutDiscards.1         ?
	  
	};
	  
			 
	
	String objectIDList_NMS_node_info[]={ // Object ID List
	    ".1.3.6.1.2.1.1.5.0", //sysName
	    ".1.3.6.1.2.1.4.2.0", //ipDefaultTTL
	    ".1.3.6.1.2.1.6.4.0", //tcpMaxConnection
	    ".1.3.6.1.2.1.1.1.0", //sysDescr
	    ".1.3.6.1.2.1.2.2.1.2.1", //ifDescr.1                  ?
	    ".1.3.6.1.2.1.2.2.1.4.1", //ifMTU.1                   ?
	    ".1.3.6.1.2.1.2.2.1.5.1", //ifSpeed.1                 ?
	};
			  
	
	Hashtable OIDHashtable = new Hashtable(); //Maps OID to object Names
	OIDHashtable.put(".1.3.6.1.2.1.4.3.0","ipInReceives");
	OIDHashtable.put(".1.3.6.1.2.1.4.6.0","ipForwDatagrams"); 
	OIDHashtable.put(".1.3.6.1.2.1.4.8.0","ipInDiscards");
	OIDHashtable.put(".1.3.6.1.2.1.4.9.0","ipInDelivers");
	OIDHashtable.put(".1.3.6.1.2.1.4.10.0","ipOutRequests");
	OIDHashtable.put(".1.3.6.1.2.1.4.11.0","ipOutDiscards");
	OIDHashtable.put(".1.3.6.1.2.1.7.1.0","udpInDatagrams");
	OIDHashtable.put(".1.3.6.1.2.1.7.4.0","udpOutDatagrams");
	OIDHashtable.put(".1.3.6.1.2.1.6.10.0","tcpInSegs");
	OIDHashtable.put(".1.3.6.1.2.1.6.11.0","tcpOutSegs");
	OIDHashtable.put(".1.3.6.1.2.1.6.12.0","tcpRetransSegs");
	OIDHashtable.put(".1.3.6.1.2.1.1.3.0","sysUpTime");
	OIDHashtable.put(".1.3.6.1.2.1.2.2.1.10.1","ifInOctets"); // ?         
	OIDHashtable.put(".1.3.6.1.2.1.2.2.1.13.1","ifInDiscards"); // ?        
	OIDHashtable.put(".1.3.6.1.2.1.2.2.1.16.1","ifOutOctets");// ?           
	OIDHashtable.put(".1.3.6.1.2.1.2.2.1.19.1","ifOutDiscards"); // ?       
	OIDHashtable.put(".1.3.6.1.2.1.1.5.0","sysName");
	OIDHashtable.put(".1.3.6.1.2.1.4.2.0","ipDefaultTTL");
	OIDHashtable.put(".1.3.6.1.2.1.6.4.0","tcpMaxConnection");
	OIDHashtable.put(".1.3.6.1.2.1.1.1.0","sysDescr");
	OIDHashtable.put(".1.3.6.1.2.1.2.2.1.2.1","ifDescr");// ?                  
	OIDHashtable.put(".1.3.6.1.2.1.2.2.1.4.1","ifMtu"); // ?              
	OIDHashtable.put(".1.3.6.1.2.1.2.2.1.5.1","ifSpeed");// ?            
	
	long newTime=System.currentTimeMillis();
	long oldTime=System.currentTimeMillis();
	SnmpTarget target = new SnmpTarget();
	while(true){
	    newTime=System.currentTimeMillis();
	    if((newTime-oldTime)>=REPEAT_TIME*60*1000){            		
		oldTime=newTime;
		try{
		    
		    String timestamp="";
		    timestamp=timestamp+(new java.sql.Date(newTime)).toString()+" ";
		    timestamp=timestamp+(new Time(newTime)).toString();
					
		    DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());
		    con = DriverManager.getConnection(connectionServer,connectionName,connectionPasswd);
		    stmt = con.createStatement();
		    ResultSet rs = null;
		    boolean ret= true;

		    ret=stmt.execute("alter session set nls_date_format = 'YYYY-MM-DD HH24:mi:ss'");
		   
		    String querry="select ip_address from nms_node_info";  
		    
		    rs = stmt.executeQuery(querry);
		    
		    Vector hostIP = new Vector();
		    
		    while (rs.next()) {
			hostIP.addElement(rs.getObject("ip_address"));
			System.out.println(rs.getObject("ip_address"));
		    }
		    
		    for(int index=0; index <hostIP.size(); index++){
			String IP=(String) hostIP.elementAt(index);	
			
			target.setTargetHost(IP);  // set host
			querry="select port from NMS_node_info where ip_address='"+IP+"'";
			rs = stmt.executeQuery(querry);
			rs.next();
			int port=rs.getInt("port");
			target.setTargetPort(port);            //set port
			target.setTimeout(TIMEOUT);
			target.setRetries(RETRIES);
			
			target.setObjectIDList(objectIDList_NMS_Stats); // set OID's
			
			SnmpVarBind snmpVarBind[] = target.snmpGetVariableBindings();
			int length= java.lang.reflect.Array.getLength(objectIDList_NMS_Stats);   
			rs=stmt.executeQuery("select * from NMS_stats_old where ip_address='"+IP+"'");
			rs.next();
			String schema="(ip_address, time";
			String values=" values('"+IP+"','"+timestamp.toString()+"'"; 
			String valuesOld=" values('"+IP+"','"+timestamp.toString()+"'";
			for(int t=0;t<length;t++){
			    String snmpOID=objectIDList_NMS_Stats[t];
			    String snmpOIDString=(String) OIDHashtable.get(snmpOID);
			    schema=schema+","+snmpOIDString;
			    target.setObjectID(snmpOID);
			    SnmpVar snmpVar=target.snmpGetVariable();
			    if(snmpVar==null){
				valuesOld=valuesOld+",null";		 
				values=values+",null";
			    }
			    else{	
				String type=snmpVar.getTypeString();
				if(type.equals("COUNTER")){
				    long oldCounter;    
				    if(rs.getObject(snmpOIDString)==null){ System.out.println("null encountered COUNTER");  oldCounter=0;}
				    else oldCounter=rs.getLong(snmpOIDString);
				    String temp= String.valueOf(snmpVar.toValue()); 		 
				    Long newVal=Long.valueOf(temp);
				    valuesOld=valuesOld+","+Long.toString(newVal.longValue());
				    values=values+","+Long.toString(newVal.longValue()-oldCounter);  
				}
				else if(type.equals("STRING")){
				    valuesOld=valuesOld+","+"'"+snmpVar.toValue()+"'";
				    values=values+","+"'"+snmpVar.toValue()+"'";
				}
				else if(type.equals("TIMETICKS")){
				    valuesOld=valuesOld+","+snmpVar.toValue();
				    values=values+","+ snmpVar.toValue();
				}	  
				else if(type.equals("INTEGER")){
				    int oldInteger;
				    if(rs.getObject(snmpOIDString)==null){System.out.println("null encountered INTEGER");  oldInteger=0;}
				    else oldInteger=rs.getInt(snmpOIDString);
				    String temp= String.valueOf(snmpVar.toValue()); 		 
				    Integer newVal=Integer.valueOf(temp);
				    valuesOld=valuesOld+","+Integer.toString(newVal.intValue());
				    values=values+","+Integer.toString(newVal.intValue()-oldInteger);  
				}
			    }
			}
			schema=schema+")";
			values=values+")";
			valuesOld=valuesOld+")";
			querry="insert into NMS_stats "+schema+" "+values;     
			System.out.println(querry);
			stmt.executeUpdate(querry);
			System.out.println("\n\n");
			querry="delete from nms_stats_old where ip_address='"+IP+"'"; 
			stmt.executeUpdate(querry);	
			System.out.println(querry);
			System.out.println("\n\n");
			querry="insert into nms_stats_old "+schema+" "+valuesOld;
			System.out.println(querry);
			stmt.executeUpdate(querry);
			System.out.println("\n\n");

			target.setObjectIDList(objectIDList_NMS_node_info); // set OID's  
			length= java.lang.reflect.Array.getLength(objectIDList_NMS_node_info);
			
			querry="update NMS_node_info set ip_address='"+IP+"',port="+Integer.toString(port);
			for(int t=0;t<length;t++){
			    String snmpOID=objectIDList_NMS_node_info[t];
			    String snmpOIDString=(String) OIDHashtable.get(snmpOID);
			    querry=querry+","+snmpOIDString+"=";
			    target.setObjectID(snmpOID);
			    SnmpVar snmpVar=target.snmpGetVariable();
			    //			System.out.println(snmpOIDString);
			    if(snmpVar==null){
				querry=querry+"null";
			    }
			    else{	
				String type=snmpVar.getTypeString();
				if(type.equals("COUNTER")){
				    querry=querry+snmpVar.toValue();  
				}
				else if(type.equals("STRING")){
				    querry=querry+"'"+snmpVar.toValue()+"'";
				}
				else if(type.equals("TIMETICKS")){
				    querry=querry+ snmpVar.toValue();
				}	  
				else if(type.equals("INTEGER")){
				    querry=querry+snmpVar.toValue(); 
				}
				else if(type.equals("GAUGE")){
				    querry=querry+snmpVar.toValue(); 
				}

				// System.out.println(type+" "+snmpVar.toValue());
			    
			    }
			}
			querry=querry+" where ip_address='"+IP+"'";     
			System.out.println(querry);
			stmt.executeUpdate(querry);
			System.out.println("\n\n");
			
		    }
		    con.close();
		}catch(Exception e){System.out.println(e);
		//		  System.exit(0);
		}
		
	    }
	}
	
	//		 System.exit(0);
    }
    
    private static long sysUpTime(String upTime){
	StringTokenizer st1 = new StringTokenizer(upTime, ",");
	String time[] = new String[3];
	int index1=0;
	while(st1.hasMoreTokens()){
	    StringTokenizer st2 = new StringTokenizer(st1.nextToken());
	    time[index1]=st2.nextToken();
	    String key=st2.nextToken();
	    index1++;
	}
	return Long.parseLong(time[0])*3600+Long.parseLong(time[1])*60+Long.parseLong(time[2]);
	
    } 
    
    
}



