/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.server;

import com.sun.web.core.Context;
import com.sun.web.server.Endpoint;
import com.sun.web.server.EndpointManager;
import com.sun.web.server.HttpServer;
import com.sun.web.server.ServerRequest;
import com.sun.web.server.ServerResponse;
import com.sun.web.server.ServletInputStreamImpl;
import com.sun.web.util.StringManager;
import java.net.InetAddress;
import java.net.Socket;

class ConnectionHandler
extends Thread {
    private StringManager sm = StringManager.getManager("com.sun.web.server");
    private EndpointManager manager;
    private ServerRequest request = new ServerRequest();
    private ServerResponse response = new ServerResponse();
    private Endpoint endpoint;
    private Socket socket;

    ConnectionHandler(EndpointManager endpointManager) {
        this.manager = endpointManager;
    }

    void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    void setSocket(Socket socket) {
        this.socket = socket;
    }

    void reset() {
        this.request.reset();
        this.response.reset();
        this.endpoint = null;
        this.socket = null;
    }

    public void run() {
        if (this.endpoint == null || this.socket == null) {
            String string = this.sm.getString("conhandler.run.ise");
            throw new IllegalStateException(string);
        }
        try {
            this.request.setSocket(this.socket);
            this.response.setSocket(this.socket);
            while (this.request.hasMoreRequests()) {
                Object object;
                int n;
                Object object2;
                this.request.setResponse(this.response);
                this.response.setRequest(this.request);
                this.request.readNextRequest();
                if (this.request.getProtocol() == null) {
                    this.response.setOmitHeaders(true);
                }
                if (this.response.getStatus() >= 400) {
                    this.response.finish();
                    this.request.reset();
                    this.response.reset();
                    break;
                }
                String string = this.request.getHeader("host");
                if (string != null) {
                    int n2 = string.indexOf(58);
                    if (n2 > -1) {
                        string = string.substring(0, n2);
                    }
                    this.request.setServerName(string);
                } else {
                    object2 = this.socket.getLocalAddress();
                    this.request.setServerName(((InetAddress)object2).getHostName());
                }
                object2 = this.request.getHeader("accept-charset");
                if (object2 != null) {
                    this.request.setCharacterEncoding((String)object2);
                }
                if ((n = this.request.getIntHeader("content-length")) != -1) {
                    object = (ServletInputStreamImpl)this.request.getInputStream();
                    ((ServletInputStreamImpl)((Object)object)).setLimit(n);
                }
                object = this.manager.resolveServer(this.endpoint, string);
                String string2 = this.request.getRequestURI();
                int n3 = string2.indexOf("?");
                if (n3 > 0) {
                    string2 = string2.substring(0, n3);
                }
                Context context = ((HttpServer)object).getContextByPath(string2);
                String string3 = context.getPath();
                string2.substring(string3.length(), string2.length());
                context.handleRequest(this.request, this.response);
                this.response.finish();
                this.request.reset();
                this.response.reset();
            }
            this.socket.close();
        }
        catch (Exception exception) {
            System.out.println("HANDLER THREAD PROBLEM: " + exception);
            exception.printStackTrace();
        }
        this.manager.returnHandler(this);
    }
}

