import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

/**
 * This class displays the form, through which the sysad can add new categories and the feature to those categories. 
 * Assumptions:
 * It is assumed when the parent category is not a final category. i.e, I should not try to create a category in say RAM. For this we need to check if parent category already contains some product for auction. In that case it won't be final.
 
 * @author      Himanshu Jain
 * @version     1.00, 09/10/2001
 */


public class AddCategoryServlet extends HttpServlet { 
    
    public void init(){
	System.out.println("Init AddCategoryServlet:");
	
    }

    /**
     * <code>doGet</code> - displays the form with 
     * <ol>
     * <li> One input box to take new category name. It checks (by using query from QueryEngine) whether that category name is not already present in the parent category.
     * <li> Then twenty 20 rows are displayed  here to add features of the category to be added an with types of each feature.
     * </ol>
     *
     * @param HttpServletRequest request
     * @param HttpServletResponse response
     */
    
    public void doGet (HttpServletRequest request,HttpServletResponse response)
        throws ServletException, IOException{

	String parentName=request.getParameter("parentName");
	boolean isNotFinal= (SharedObjects.qe).isNotFinal(parentName);
	response.setContentType("text/html");
	PrintWriter pw = response.getWriter();
	
	if (isNotFinal){
	    ProdHtmlGen.addHtmlHeader(pw,"Add category and its feature");
	    ProdHtmlGen.showCategoryAdditionForm(pw,parentName);
	    ProdHtmlGen.addHtmlFooter(pw);
	}
	else{
	    ProdHtmlGen.showMessage(pw,"This is a final category, no more sub category can be created inside it");
	}
	
    }
	
     /**
     * <code>doPost</code> - recieves the data posted from <code>doGet</code> method. And accordingly updates the database by adding the new category to database. Suitable messages are displayed to indicate whether the:
     * <ol>
     * <li> Category name was already present.
     * <li> some problem occured during update to database.
     * <li> the update executed successfully.
     * </ol>
     *
     * @param HttpServletRequest request
     * @param HttpServletResponse response
     */
     
    public void doPost(HttpServletRequest request,HttpServletResponse response)
	throws ServletException, IOException{
	String parentName= request.getParameter("parentName");
	String subCatName= request.getParameter("subcatname");
	response.setContentType("text/html");
	PrintWriter pw = response.getWriter();
	boolean isCatNameOverlap= (SharedObjects.qe).isCategoryNameOverlaping(parentName,subCatName);
	
	if (isCatNameOverlap){
	    String mesg="A category named "+subCatName+" already exists in "+parentName+" ";
	    ProdHtmlGen.showMessage(pw,mesg);
	    System.out.println("Category name overlap found");
	}
	else{
	    System.out.println("sub category addition is being done");
	    Vector fnatVect =new Vector(10,10);
	    String featureName=null;
	    String featureType=null;
	    for(int i=0;i<20;i++){
		featureName=request.getParameter("feature"+i);
		featureType=request.getParameter("type"+i);
		
		if (!(featureName.equals(""))){
		    fnatVect.addElement(new ProdFeatureNameAndType (featureName, featureType));
		    
		}
		
	    }
	    boolean addSubCat= (SharedObjects.qe).addNewCategory(parentName,subCatName);
	    String mesg=null;
	    
	    if(addSubCat){
		mesg="Sub Category "+subCatName+ " added successfully to "+parentName;
	    }
	    else{
		mesg="Problem occured while adding sub-cat";
	    }
	    
	    ProdHtmlGen.showMessage(pw,mesg);
	    boolean addFeatToCat= (SharedObjects.qe).addFeaturesToCategory(subCatName,fnatVect);
	    
	    if(addFeatToCat){
		mesg="Features added successfully to the category "+subCatName;
	    }
	    else{
		mesg="Problem occyred while adding Features";
	    }
	    ProdHtmlGen.showMessage(pw,mesg);
	}
    }
}

/*--------------------END OF CODE --------------------------------------------*/








