import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

/**
 * This class is used to implement the browsing in the online auction database. Browsing is used for both placing auction and bidding on a current auction. This is also used by System Administrator to add and delete categories by browsing.
 * <ol>
 * <li> Depending upon the parameters passed to servlet, finally control is passed to classes responsible for placing auction or bidding.
 *   <ol> 
 *      <li> If <b>whereFrom</b> parameter passed to servlet is <b>sel</b>l control is passed to PlaceAuctionServlet.
 *      <li>  If <b>whereFrom</b> is <b>browse</b> control is passed to BidServlet.
 *      <li>  If <b>whereFrom</b> is <b>sysad</b> control is passed to servlets that implement sysad functions.
 *   </ol>
 * <li> In case sysad is browsing the control is finally passed to servlets <code>AddCategoryServlet</code> for adding new categories or  
 * </ol>
 * @author      Himanshu Jain
 * @version     1.00, 09/10/2001
 */ 

public class BrowseServlet extends HttpServlet { 
    
    public void init(){
	System.out.println("Init:BrowseServlet");
    }

    /**
     * <code>doGet</code> - performs the function as mentioned in the class summary. Some assumptions are:
     * <ol> 
     * <li> whereFrom holds "browse" or "sell". If "null" I assume its browse.
     * <li> This is the parent name whose, all childs will be displayed now. If null I assume its at the top of hierarchy i.e. it is the "Product"
     * </ol>
     * @param HttpServletRequest request
     * @param HttpServletResponse response
     */      
   
    
    /* This expects whereFrom and parentName in the encoded URL
       1. whereFrom holds "browse" or "sell". If "null" I assume its browse.
       2. This is the parent name whose, all childs will be displayed now. If null I assume its at the top of hierarchy i.e. it is the "Product"
     */
    
    public void doGet(HttpServletRequest request,HttpServletResponse response)
	throws ServletException, IOException{
	String whereFrom=request.getParameter("whereFrom");
	String parentName=request.getParameter("parentName");
	if (whereFrom == null){
	    whereFrom="Browse";
	}
	
	if (parentName == null){
	    parentName="Product";
	}
	
	
	//Getting the query executed, Vector will contain all the childs if parentName is not a final category like RAM etc which won't have further categories. 
	Vector rv= (SharedObjects.qe).getChildCategoryList(parentName);
	int size=rv.size();
	response.setHeader("Refresh", "-1");
	response.setContentType("text/html");
	if(! (whereFrom.equals("sysad"))){  
	    if (size > 0){
		//Display all childs
		PrintWriter pw = response.getWriter();
		ProdHtmlGen.addHtmlHeader(pw,"Categories");
		ProdHtmlGen.showChilds(pw,rv,whereFrom);
		ProdHtmlGen.addHtmlFooter(pw);
	    }
	    else{
		// parentName was a final category infact.
		// Now I will show products in this category for auction
		if(whereFrom.equals("browse")){
		    System.out.println("Now I have reached final cat and will call query to find all prod for auction in this cat");
		    Vector resultVec= (SharedObjects.qe).productDetailsOfFinalCategory(parentName); 
		    PrintWriter pw = response.getWriter();
		    
		    response.setHeader("Refresh", "20");
		    System.out.println("Vector obtained now calling HTML display pages");
		    ProdHtmlGen.addHtmlHeader(pw,"Products for auction in "+parentName);
		    ProdHtmlGen.showProductDetailsTable(pw,parentName,resultVec);
		    ProdHtmlGen.addHtmlFooter(pw);

		}
		else{
		       // Now I will redirect to the page that open's auction details form
		    response.setHeader("refresh", "-1" );
		    RequestDispatcher dispatcher=null;
		     request.setAttribute("category",parentName);
		     dispatcher=getServletContext().getRequestDispatcher("/servlet/PlaceAuctionServlet");
		       
		     if (dispatcher != null){
			 dispatcher.forward(request,response);
		     }
		   
		    // response.sendRedirect(Config.servletUrl+"PlaceAuctionServlet);
		    //response.sendRedirect(Config.servletUrl+"PlaceAuctionServlet?category="+parentName.replace(' ','+'));
		}
	    }
	}
    
	else{
	    PrintWriter pw = response.getWriter();
	    System.out.println("Entered in sysad area");
	    String sysadOption= request.getParameter("sysadOption");
	    Integer choiceNum=new Integer(0);
	    // Option 1 is for adding new Categories
	    // Option 2 is for deleting existing Categories
	    
	    switch(choiceNum.parseInt(sysadOption)){
            case 1:
		{
		    ProdHtmlGen.addHtmlHeader(pw,"Browse and Add");
		    ProdHtmlGen.showChildsWithAddingOption(pw,rv,whereFrom,sysadOption);
		    ProdHtmlGen.addHtmlFooter(pw); 
		}
		break;
	    case 2:
		{
		    ProdHtmlGen.addHtmlHeader(pw,"Warning! You are deleting Categories");
		    ProdHtmlGen.showChildsWithDeletingOption(pw,rv,whereFrom,sysadOption);
		    ProdHtmlGen.addHtmlFooter(pw); 
		}
		break;
	    }
	    
	}
    }
	

     /**
     * This is empty.
     * @param HttpServletRequest request
     * @param HttpServletResponse response
     */ 

    /* doGet hasn't got much to do. */
    /* I am not adding anything to user session*/
    public void doPost (HttpServletRequest request,HttpServletResponse response)
        throws ServletException, IOException{
    }
    
}


/*--------------------END OF CODE --------------------------------------------*/











