import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

/**
 * This class displays the form. through which the sysad can add delete existing categories .

 * Assumptions:
 * Category is deleted only if it is empty. A category is empty if:
 * <ol>
 * <li> It does not contain any sub-categories.
 * <li> Or it does not contain any products placed for auction under it.
 * </ol>
 * @author      Himanshu Jain
 * @version     1.00, 09/10/2001
*/


public class DeleteCategoryServlet extends HttpServlet { 
    
    public void init(){
	System.out.println("Init: DeleteCategoryServlet");
	
    }

    /**
     * <code>doGet</code> - this just calls <code>deleteTheCategory</code> in QueryEngine. The method deleteTheCategory in query engine takes care of whether the category can be deleted or not. If it can be deleted, its deleted.
     *
     * @param HttpServletRequest request
     * @param HttpServletResponse response
     */
    
    /*Just calls the delete category function in query engine*/
    
    
    public void doGet (HttpServletRequest request,HttpServletResponse response)
        throws ServletException, IOException{
	String parentName=request.getParameter("parentName");
	System.out.println("Category to be deleted is: "+parentName);
	String resultOfDeletingTheParent= (SharedObjects.qe).deleteTheCategory(parentName);
	response.setContentType("text/html");
	PrintWriter pw = response.getWriter();
	ProdHtmlGen.showMessage(pw,resultOfDeletingTheParent);
    }
	
     /**
     * This is empty.
     * @param HttpServletRequest request
     * @param HttpServletResponse response
     */ 
        
    public void doPost(HttpServletRequest request,HttpServletResponse response)
	throws ServletException, IOException{
	
    }
}

/*--------------------END OF CODE --------------------------------------------*/







