//package com.parsec.applets;

import java.applet.*;
import java.io.*;
import java.net.*;
import java.awt.*;
import java.awt.event.*;

/*
<applet code="StockTicker" height=20 width=600>
</applet>
*/
public class StockTicker extends Applet implements Runnable,KeyListener
{
	static Image bkGround=null;
	static Image tickerChars=null;
	static Image arrowUp=null;
	static Image arrowDown=null;
	static Image buffer=null;
	static Graphics bufferG=null;
	static final String characters="abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ 0123456789.,:;'\"<>/?[]{}\\|`~!@#$%^&*()-_=+";
	static boolean running=true;
	static long lastUpdated=0;
	static String quoteString="";
	int height=20;
	int width=636;
	int index=0;
	int numChars=width/12;
	int len=0;
	boolean canPaint=false;
	boolean allowPaint=false;
	int smIndex=0;
	Thread t;
	long delay;
	long MIN_DELAY=0;
	long MAX_DELAY=10;

	public void keyPressed(KeyEvent e)
	{
		switch (e.getKeyCode())
		{
		case KeyEvent.VK_UP: if (delay>MIN_DELAY) delay--;break;
		case KeyEvent.VK_DOWN: if (delay<MAX_DELAY) delay++;break;
		}
	}
	
	public void keyTyped(KeyEvent e)
	{
	}
	public void keyReleased(KeyEvent e)
	{
	}
	public synchronized void init()
	{
		System.out.println("init");
		getSourceImages();
		setBackground(Color.black);
		addKeyListener(this);
	}


	public synchronized void start()
	{
		System.out.println("starting");
		running=true;
		canPaint=false;
		buffer=null;
		//smIndex=0;
		t=new Thread(this);
		t.start();
	}

	public synchronized void stop()
	{
		System.out.println("stp[");
		running=false;
		//smIndex=0;
	}


	public void update(Graphics g)
	{
		paint(g);
	}


	public void paint(Graphics g)
	{	
		if (buffer!=null)
		{

			g.drawImage(buffer,smIndex,2,this);

			return;

		}else
		{
			buffer=createImage(width+12,height);
			bufferG=buffer.getGraphics();
			bufferG.setColor(Color.black);
			bufferG.fillRect(0,0,width,height); 
			canPaint=true;
			return;
		}
	}

	void fetchData()
	{
		quoteString="BSE Quotes delayed 10 mintutes INF 1230+12 ACT+16 ASD-21 INF-21   ";
		len=quoteString.length();
	}

	public void run()
	{
		while (running)
		{
			System.out.println("mom");
			fetchData();
			//	if (System.currentTimeMillis()-lastUpdated>15*60*1000)
			//	{
			//	fetchData();
			//	lastUpdated=System.currentTimeMillis();
			//	}
			//generate buffer of index to index+char+1 and drag out buffer
			if (canPaint)
			{
				for(int i=0;i<numChars+1;i++)
				{
					char c=quoteString.charAt((index+i)%len);
					if (c=='+')
						bufferG.drawImage(arrowUp,i*12,0,(i+1)*12,13,0,0,12,12,this);
					else if (c=='-')
						bufferG.drawImage(arrowDown,i*12,0,(i+1)*12,13,0,0,12,12,this);	
					else
					{
						int num=characters.indexOf(c);
						bufferG.drawImage(tickerChars,i*12,0,(i+1)*12,13,num*12,0,(num+1)*12,13,this);
					}
				} 
				for(smIndex=0;smIndex>-12;smIndex--)
				{

					repaint();

					try
					{
						Thread.sleep(10L);
					}catch(InterruptedException e)
					{
					}
				}
				index=(index+1)%len;
			}

		}


	}

	public StockTicker()
	{
	}

	void getSourceImages()
	{
		MediaTracker mt=new MediaTracker(this);
		bkGround=getImage(getCodeBase(),"bkg.gif");
		tickerChars=getImage(getCodeBase(),"images/tickerSrc.gif");
		arrowUp=getImage(getCodeBase(),"images/arrowUp.jpg");
		arrowDown=getImage(getCodeBase(),"images/arrowDown.jpg");
		mt.addImage(bkGround,10);
		mt.addImage(tickerChars,10);
		mt.addImage(arrowUp,10);
		mt.addImage(arrowDown,10);
		while (!mt.checkID(10,true))
		{
			try
			{
				Thread.sleep(100L);
			}catch(Exception e)
			{
				e.printStackTrace();
			}
		}
	}


}


