package com.parsec.apps;

import java.util.*;
import java.io.*;
import javax.naming.*;
import javax.rmi.PortableRemoteObject;
import javax.ejb.*;
import java.rmi.*;
import com.parsec.ejbs.share.*;
import com.parsec.ejbs.bidbuy.*;
import com.parsec.ejbs.portfolio.*;
import com.parsec.ejbs.deal.*;


class Breaker
{
    public static void breakDeals() throws EJBException
    {
	ShareUnitHome home;
	BuyingCallHome home1;
	SellingCallHome home2;
	PortfolioHome homep;
	PendingDealHome homepd;
	DealHome homed;
	CurrentShareStateHome homecss;
	SharePerformanceHome homesp;

	try
	    {
		Context initial = new InitialContext();

		Object objref = initial.lookup("ShareUnitBean");	
		home = 
		    (ShareUnitHome)PortableRemoteObject.narrow(objref, 
							       ShareUnitHome.class);

		objref = initial.lookup("BuyingCallBean");
		home1 = 
		    (BuyingCallHome)PortableRemoteObject.narrow(objref, 
								BuyingCallHome.class);

		objref = initial.lookup("SellingCallBean");
		home2 = 
		    (SellingCallHome)PortableRemoteObject.narrow(objref, 
								 SellingCallHome.class);

		objref = initial.lookup("PortfolioBean");
		homep = 
		    (PortfolioHome)PortableRemoteObject.narrow(objref, 
							       PortfolioHome.class);

		objref = initial.lookup("PendingDealBean");
		homepd = 
		    (PendingDealHome)PortableRemoteObject.narrow(objref, 
								 PendingDealHome.class);

		objref = initial.lookup("DealBean");
		homed = 
		    (DealHome)PortableRemoteObject.narrow(objref, 
							  DealHome.class);


		objref = initial.lookup("CurrentShareStateBean");
		homecss = 
		    (CurrentShareStateHome)PortableRemoteObject.narrow(objref, 
								       CurrentShareStateHome.class);
		objref = initial.lookup("SharePerformanceBean");
		homesp = 
		    (SharePerformanceHome)PortableRemoteObject.narrow(objref, 
								      SharePerformanceHome.class);
		
	    }
	catch (NamingException ne)
	    {
		ne.printStackTrace();
		throw new EJBException(ne.getMessage());
	    }
    
	Collection c;
	System.out.println("Finding ShareUnits...\n");

	try
	    {
		c = home.findAll();
	    }
	catch (FinderException fe)
	    {
		System.out.println(fe);
		return;
	    }
	catch (RemoteException re)
	    {
		System.out.println(re);
		return;
	    }
	

	Iterator i = c.iterator();

	while(i.hasNext())
	    {
		ShareUnit this_share = (ShareUnit)i.next();
		String this_share_id;
		Collection c1;
		Collection c2;
		System.out.println("Another Share...");

		try
		    {
			this_share_id = (String)this_share.getShareId();
			c1 = home1.findByShareId(this_share_id); 
			System.out.println("done c1");
			c2 = home2.findByShareId(this_share_id);
			System.out.println("done c2");
				
		    }
		catch(FinderException fe)
		    {
			System.out.println("No Buying/Selling calls for this share type "+fe);
			this_share=null;
			continue;
		    }
		catch(RemoteException re)
		    {
			System.out.println(re);
			this_share=null;
			continue;
		    }


		//Now c1 and c2 hold the buying and selling calls for 
		//this share

		if(c1.isEmpty() || c2.isEmpty())continue;  //No Deal or price up possible

		//Now to pick up the two extreme calls
		Iterator i1 = c1.iterator();
		Iterator i2 = c2.iterator();


		BuyingCall b = (BuyingCall)i1.next();
		SellingCall s = (SellingCall)i2.next();

		try
		    {

			float minsp = s.getPrice();
			float maxbp = b.getPrice();
			BuyingCall maxb = b;
			SellingCall mins = s;

			while(i1.hasNext())
			    {
				b = (BuyingCall)i1.next();
				if(b.getPrice() > maxbp)
				    {
					maxb = b;
					maxbp = b.getPrice();
				    }
			    }

			while(i2.hasNext())
			    {
				s = (SellingCall)i2.next();
				if(s.getPrice() < minsp)
				    {
					mins = s;
					minsp = s.getPrice();
				    }
			    }

				//Now mins points to the minimum selling price bid
				//and maxb points to the maximum buying price bid

			if(minsp > maxbp)continue; //No Scope....

			float this_share_price = (minsp + maxbp)/2;
			int deal_size = mins.getNoOfShares();
			boolean deletes=true;
			boolean deleteb=true;
			if(mins.getNoOfShares() < maxb.getNoOfShares())
			    {
				deal_size = mins.getNoOfShares();
				deleteb=false;
				//Enqueue remaining requests
				try 
				    {
					maxb.setNoOfShares(maxb.getNoOfShares()-deal_size);
				    }
				catch (RemoteException re)
				    {
					System.out.println(re);
					continue;
				    }
			    }
			else if (mins.getNoOfShares() > maxb.getNoOfShares())
			    {
				deal_size = maxb.getNoOfShares();
				deletes=false;
				//Enqueue remaining requests
				try 
				    {
					mins.setNoOfShares(mins.getNoOfShares()-deal_size);
				    }
				catch(RemoteException ce)
				    {
					System.out.println(ce);
					continue;
				    }
			    }


			Portfolio p = null;
			boolean struck = false;
			
			try 
			    {
				p = homep.findByPrimaryKey(new ItemKey(mins.getCustomerId(), mins.getShareId()));
			
			    }
			catch(FinderException fe)
			    {
					System.out.println(fe);
					p = null;
			    }
		
		
		
			if((p == null) || (p.getHolding() < deal_size))
			    {
				//Send this deal to pending table 
				//as seller has less no. of shares than needed
				//Deal Size is deal_size
				try 
				    {
				
					PendingDeal pd = 
					    homepd.create(maxb.getCustomerId(),mins.getCustomerId(),
							  this_share_id,(new Date()),deal_size,
							  this_share_price);
				    }
				catch (CreateException ce)
				    {
					System.out.println(ce);
					throw new EJBException(ce.getMessage());
				    }
			
			    }
			else
			    {
						
				//Decrease p's holding by deal_size, remove if zero now
				//Update AvgBuying price
				if (p.getHolding() == deal_size)
				    {	
					try 
					    {			
						p.remove();
					    }
					catch(RemoveException re)
					    {
						System.out.println(re);
						throw new EJBException(re.getMessage());
					    }
				    }
				else
				    {
					p.setAvgBuyingPrice((p.getHolding()*
							     p.getAvgBuyingPrice()
							     - deal_size*
							     this_share_price)/
							    (p.getHolding()-
							     deal_size));
					p.setHolding(p.getHolding()-deal_size);

				    }



				//Add deal_size shares to maxb's Portfolio...create if needed
				//Update AvgBuyingprice

				
				Portfolio pb;
				
				try 
				    {

						pb = homep.findByPrimaryKey(new ItemKey(maxb.getCustomerId(), maxb.getShareId()));
					 	pb.setAvgBuyingPrice((pb.getHolding()*
								     pb.getAvgBuyingPrice()+
								     deal_size*
								     this_share_price)/
							    	(pb.getHolding()+
							    	 deal_size));
				
						pb.setHolding(pb.getHolding()+deal_size);
				 
				 
				 
				 
				    }
				catch(FinderException fe)
				    {
						System.out.println(fe);
									
						try 
					    {
							p = homep.create(maxb.getCustomerId(),
									 this_share_id,
									 deal_size,
									 this_share_price);
					    }
						catch(CreateException ce)
					    {
							System.out.println(ce);
							throw new EJBException(ce.getMessage());
					    }
					
				    }
			
			
			
				//Add whole deal to "Deals" if needed
				try 
				    {
					Deal d = homed.create(maxb.getCustomerId(),
							      mins.getCustomerId(),
							      this_share_id,
							      (new Date()),
							      deal_size,
							      this_share_price);
				    }
				catch(CreateException ce)
				    {
					System.out.println(ce);
					throw new EJBException(ce.getMessage());
				    }
			
			
			    }
			
			try 
			    {	
			
				//Remove mins from Selling_calls
				if(deletes)
				    mins.remove();
			
				//Remove maxb from Buying_calls
				if(deleteb)
				    maxb.remove();
			    }
			catch(RemoveException re)
			    {
				System.out.println(re);
				throw new EJBException(re.getMessage());
			    }
		
				//Update this share's price to this_share_price and handle
				//day's low/high
			try
			    {
			
				CurrentShareState css = homecss.findByPrimaryKey(this_share_id);
				
				css.setCurrentPrice(this_share_price);

				if(this_share_price > css.getTodaysHigh())
					css.setTodaysHigh(this_share_price);
				if(this_share_price < css.getTodaysLow())
					css.setTodaysLow(this_share_price);

				SharePerformance sp = homesp.findByPrimaryKey(new SharePerformancePrimaryKey(this_share_id, new java.sql.Date(new java.util.Date().getTime())));
				sp.setClosing(this_share_price);

				if(this_share_price > sp.getDaysHigh())
					sp.setDaysHigh(this_share_price);
				if(this_share_price < sp.getDaysLow())
					sp.setDaysLow(this_share_price);

			    }
			catch(FinderException fe)
			    {
				System.out.println(fe);
				try
				    {
						homesp.create(this_share_id,new java.sql.Date(new java.util.Date().getTime()),this_share_price,this_share_price,this_share_price,this_share_price);
				    }
				catch(CreateException ce)
				    {
					System.out.println(ce);
					throw new EJBException(ce.getMessage());
				    }
			      /*
				try
				{					
				homecss.create(this_share_id,this_share_price,this_share_price,this_share_price);				
				}
				catch(CreateException ce)
				{
				System.out.println(ce);
				throw new EJBException(ce.getMessage());
				}*/
				
			
			    }
		    }	
		catch (RemoteException re)
		    {
			System.out.println(re);
			throw new EJBException(re.getMessage());
		    }
	    }

	//Now to update the applet file 
	String forapplet = "";
	

	try
	    {
	    try
	        {
	    	c = home.findAll();
	        }
	    catch (FinderException fe)
	        {
	    	System.out.println(fe);
	    	return;
	        }
	    catch (RemoteException re)
	        {
	    	System.out.println(re);
	    	return;
	        }
				
		//Now c is the collection of all shares
		i = c.iterator();
		while(i.hasNext())
		    {
			ShareUnit this_share = (ShareUnit)i.next();
			String this_share_id;
			String this_comp_name;
			float this_share_price = 0;
			
			try
			    {
				this_share_id = (String)this_share.getShareId();
				this_comp_name = (String)this_share.getCompanyId();
			    }
			catch(RemoteException fe)
			    {
				System.out.println(fe);
				continue;
			    }
			
			CurrentShareState css = null;
			SharePerformance sp = null;

			try
			{
				css = homecss.findByPrimaryKey(this_share_id);
				this_share_price = css.getCurrentPrice();
			}
			catch (FinderException fe)
			{
				System.out.println(fe);
				continue;
			}


			try
			    {
					sp = homesp.findByPrimaryKey(new SharePerformancePrimaryKey(this_share_id, new java.sql.Date(new java.util.Date().getTime())));
					
				}
			catch(FinderException fe)
			    {
				System.out.println(fe);
				try
				    {
						sp = homesp.create(this_share_id,new java.sql.Date(new java.util.Date().getTime()),this_share_price,this_share_price,this_share_price,this_share_price);
				    }
				catch(CreateException ce)
				    {
					System.out.println(ce);
					throw new EJBException(ce.getMessage());
				    }
			    }
			forapplet += this_comp_name + " " + this_share_price;
				
			if ((css.getCurrentPrice() - sp.getOpening()) >= 0) 
				{
					forapplet += "+";
				}
			forapplet += (this_share_price - sp.getOpening()) + " ";
				
			
		    }
			System.out.println("Forapplet is : "+forapplet);
			if(!forapplet.equals(""))
			    {
				//Write string to the applet file
				forapplet = "Current Price Listing: " + forapplet+"\n";
				
				try
				    {
						System.out.println("Forapplet again is : "+forapplet);
						FileWriter f = new FileWriter("applets/currentprices");
						f.write(forapplet);
						f.close();
				    }
				
				catch(IOException ioe)
				    {
					System.out.println(ioe);
				    }
			    }
	    }

	catch(RemoteException re)
	    {
		System.out.println(re);
		return;
	    }
    }
}

