package com.parsec.apps;

import java.util.*;
import javax.naming.*;
import javax.rmi.PortableRemoteObject;
import javax.ejb.*;
import java.rmi.*;
import com.parsec.ejbs.deal.*;
import com.parsec.ejbs.portfolio.*;

class Settler  
{
    public static void settleDeals(int lookback) throws RemoteException
    {//Will settle deals that could not be settled "lookback" days back due to 
	//short selling
	
	PortfolioHome homep;
	PendingDealHome home;
	DealHome homed;

	
	try {
	    Context initial = new InitialContext();
	
	    Object objref = initial.lookup("Pending_deal");
	    home = 
		(PendingDealHome)PortableRemoteObject.narrow(objref, 
							     PendingDealHome.class);
	    
	    objref = initial.lookup("Portfolio");
	    homep = 
		(PortfolioHome)PortableRemoteObject.narrow(objref, 
							   PortfolioHome.class);
	    
	    objref = initial.lookup("Deal");
	    homed= 
		(DealHome)PortableRemoteObject.narrow(objref, 
						      DealHome.class);
	    
	    
	}

	catch(NamingException ne)
	    {
		System.out.println(ne);
		throw new RemoteException(ne.getMessage());
	    }

	Date current = new Date();
	Date that_day = new Date(current.getTime()-lookback*24*3600*1000);
	
	Collection c;
	
	try 
	    {
		
		c = home.findByDateOnly(that_day);
	    }
	catch(FinderException fe)
	    {
		System.out.println(fe);
		return;
	    }
	catch (RemoteException re)
	    {
		System.out.println(re);
		return;
	    }
	
	if(c.isEmpty())return;
	
	//Now to iterate over all pending deals.....
	
	Iterator i = c.iterator();
	while(i.hasNext())
	    {
		PendingDeal pd = (PendingDeal)i.next();
		try {
		    String this_share_id = pd.getShareId();
		    int deal_size = pd.getNoOfShares();
		    float this_share_price = pd.getPrice();
		    
		    Portfolio p = null;
		    
		    try 
			{
			    p = homep.findByPrimaryKey(new ItemKey(pd.getSellerId(), pd.getShareId()));
			}
		    
		    catch(FinderException fe)
			{
			    System.out.println(fe);
			}
		   
		    boolean struck = false;
		
		    
		    if(p == null || (p.getHolding() < deal_size))
			{
			    
			    //TAKE CRIMINAL ACTION AGAINST THIS MAN
			
			}
		    else
			{
			    
			    //Decrease p's holding by deal_size, remove if zero now
			    //Update AvgBuying price
			    if(p.getHolding() == deal_size)
				{
				    try
					{

					    p.remove();
					}

				    catch(RemoveException re)
					{
					    System.out.println(re);
					    throw new RemoteException(re.getMessage());
					}
				}
			    else
				{
				    p.setAvgBuyingPrice((p.getHolding()*
							 p.getAvgBuyingPrice()
							 - deal_size*
							 this_share_price)/
							(p.getHolding()-
							 deal_size));
				    p.setHolding(p.getHolding()-deal_size);
						     				
				}
			

			
			    //Add deal_size shares to maxb's Portfolio...create if needed
			    //Update AvgBuyingprice
			
			    p = null;
			    
			    try
				{
				    p = homep.findByPrimaryKey(new ItemKey(pd.getBuyerId(),pd.getShareId()));
				}
			    catch(FinderException fe)
				{
				    System.out.println(fe);
				}
			    
			    
			    if(p == null)
				{
				    try
					{
					    p = homep.create(pd.getBuyerId(),
							     this_share_id,
							     deal_size,
							     this_share_price);
					}
				    catch(CreateException ce)
					{
					    System.out.println(ce);
					    throw new RemoteException(ce.getMessage());
					}
				    		
				}
			    else
				{
				    p.setAvgBuyingPrice((p.getHolding()*
							 p.getAvgBuyingPrice()+
							 deal_size*
							 this_share_price)/
							(p.getHolding()+
							 deal_size));
				
				    p.setHolding(p.getHolding()+deal_size);
				    
				}
			
			    
			    //Add whole deal to "Deals" if needed
			    try
				{
				    Deal d = homed.create(pd.getBuyerId(),
							  pd.getSellerId(),
							  this_share_id,
							  (new Date()),
							  deal_size,
							  this_share_price);
				}

			    catch(CreateException ce)
				{
				    System.out.println(ce);
				    throw new RemoteException(ce.getMessage());
				}
			    
			
			}
		    try 
			{
			    pd.remove();
			}
		    catch(RemoveException re)
			{
			    System.out.println(re);
			    throw new RemoteException(re.getMessage());
			}

		}
		
		catch(RemoteException re)
		    {
			System.out.println(re);
			throw new RemoteException(re.getMessage());
		    }
	    }
    }
}







