/*
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */
package com.parsec.ejbs.authenticator;

import java.sql.*;
import javax.sql.*;
import java.util.*;
import javax.ejb.*;
import javax.naming.*;
import com.parsec.utils.*;
 
public class AuthenticatedByEJB implements EntityBean
{

	private String customerId;
        private String authenticatorId;
        private java.util.Date authenticateDate;

	private EntityContext context;
	private Connection con;


	public String getCustomerId()
	{
		return customerId;
	}
       
        public String getAuthenticatorId()
	{
	    return authenticatorId;
	}
    
        public java.util.Date getAuthenticateDate()
        {
	       return authenticateDate;
        }

//Set methods

        public void setCustomerId (String a)
        {
	     customerId=a;
	}

        public void setAuthenticatorId(String a)
	{
		authenticatorId=a;
	}
	public void setAuthenticateDate(java.util.Date a)
	{
		 authenticateDate=a;
	}

//End of set methods


         public String ejbCreate(String customerId,
				 String authenticatorId,
				 java.util.Date authenticateDate
				 )
	throws CreateException
	{

		try
		{
		    insertRow(customerId,authenticatorId,authenticateDate);
		} catch (Exception ex)
		{
			throw new EJBException("ejbCreate: " + 
				ex.getMessage());
		}

		this.customerId=customerId;
		this.authenticatorId=authenticatorId;
		this.authenticateDate=authenticateDate;

		return customerId;
	}

	public String ejbFindByPrimaryKey(String primaryKey) 
	throws FinderException
	{

		boolean result;

		try
		{
		        result = selectByPrimaryKey(primaryKey);
		} catch (Exception ex)
		{
			throw new EJBException("ejbFindByPrimaryKey: " + 
				ex.getMessage());
		}
		if (result)
		{
			return primaryKey;
		}
		else
		{
			throw new ObjectNotFoundException
				("Row for id " + primaryKey + " not found.");
		}
	}

	public void ejbRemove()
	{

		try
		{
			deleteRow(customerId);
		} catch (Exception ex)
		{
			throw new EJBException("ejbRemove: " + 
				ex.getMessage());
		}
	} 

	public void setEntityContext(EntityContext context)
	{

		this.context = context;
//      try {
//         makeConnection();
//			} catch (Exception ex) {
//          throw new EJBException("Unable to connect to database. " +
//             ex.getMessage());
//			}
   	}

	public void unsetEntityContext()
	{

//		try
//		{
//			con.close();
//		} catch (SQLException ex)
//		{
//			throw new EJBException("unsetEntityContext: " + ex.getMessage());
//		}
	}

	public void ejbActivate()
	{

		customerId = (String)context.getPrimaryKey();
	}

	public void ejbPassivate()
	{

		customerId = null;
	}

	public void ejbLoad()
	{

		try
		{
			loadRow();
		} catch (Exception ex)
		{
			throw new EJBException("ejbLoad: " + 
				ex.getMessage());
		}
	}

	public void ejbStore()
	{

		try
		{
			storeRow();
		} catch (Exception ex)
		{
			throw new EJBException("ejbStore: " + 
				ex.getMessage());
		}
	}


    public void ejbPostCreate(String customerId,
			      String authenticatorId,
			      java.util.Date authenticateDate
			      )
    { 
    }


	/*********************** Database Routines *************************/

	private void makeConnection() throws NamingException, SQLException
	{

		DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());
		con = DriverManager.getConnection("jdbc:oracle:thin:@everest:1521:GEN","sarvjeet","sarv");
	}

	private void insertRow (String customerId,
				String authenticatorId,
				java.util.Date authenticateDate
				) 
	throws SQLException
	{

		con=ParsecUtils.getDBConnection();
		String insertStatement =
			"insert into authenticated_by values (?,?,?)";
		PreparedStatement prepStmt = 
			con.prepareStatement(insertStatement);

		prepStmt.setString(1, customerId);
		prepStmt.setString(2, authenticatorId);
		prepStmt.setTimestamp(3,new java.sql.Timestamp(authenticateDate.getTime()));

		prepStmt.executeUpdate();
		prepStmt.close();con.close();
	}

	private void deleteRow(String id) throws SQLException
	{

		con=ParsecUtils.getDBConnection();
		String deleteStatement =
			"delete from authenticated_by where customer_id = ? ";
		PreparedStatement prepStmt =
			con.prepareStatement(deleteStatement);

		prepStmt.setString(1, id);
		prepStmt.executeUpdate();
		prepStmt.close();con.close();
	}

	private boolean selectByPrimaryKey(String primaryKey) 
	throws SQLException
	{
	
		con=ParsecUtils.getDBConnection();
		String selectStatement =
			"select customer_id " +
			"from authenticated_by where customer_id = ? ";
		PreparedStatement prepStmt =
			con.prepareStatement(selectStatement);
		prepStmt.setString(1, primaryKey);

		ResultSet rs = prepStmt.executeQuery();
		boolean result = rs.next();
		prepStmt.close();con.close();
		return result;
	}



	private void loadRow() throws SQLException
	{
		con=ParsecUtils.getDBConnection();
		String selectStatement =
			"select authenticator_id,authenticate_date " +
			"from authenticated_by where customer_id = ? ";
		PreparedStatement prepStmt = 
			con.prepareStatement(selectStatement);

		prepStmt.setString(1, this.customerId);

		ResultSet rs = prepStmt.executeQuery();

		if (rs.next())
		{
		        this.authenticatorId=rs.getString(1);
			this.authenticateDate=new java.util.Date(rs.getTimestamp(2).getTime());
			prepStmt.close();con.close();
		}
		else
		{
			prepStmt.close();con.close();
			throw new NoSuchEntityException("Row for id " + customerId +
				" not found in database.");
		}
	}


	private void storeRow() throws SQLException
	{
		con=ParsecUtils.getDBConnection();
		String updateStatement =
			"update authenticated_by set " +
			"authenticator_id = ? , authenticate_date = ? " +
			"where customer_id = ? ";
		PreparedStatement prepStmt = 
			con.prepareStatement(updateStatement);

		prepStmt.setString(1, authenticatorId);
		prepStmt.setTimestamp(2, new java.sql.Timestamp(authenticateDate.getTime()));
 		prepStmt.setString(3, customerId);

		int rowCount = prepStmt.executeUpdate();
		prepStmt.close();con.close();

		if (rowCount == 0)
		{
			throw new EJBException("Storing row for id " + customerId + " failed.");
		}
	}

} // AuthenticatedByEJB 
