package com.parsec.ejbs.authenticator;

import javax.ejb.*;
import javax.naming.*;
import java.rmi.*;
import javax.rmi.*;
import java.util.*;
import com.parsec.ejbs.customer.*;
import com.parsec.ejbs.company.*;

public class AuthenticationEJB implements SessionBean
{

    CustomerHome chome;
	UserRegistrationHome uhome;
	CompanyHome cmhome;
	CorporateRegistrationHome crhome;
	AuthenticatedByHome abhome;
	CompanyAuthenticatedByHome cabhome;

    public void ejbCreate() {
	try {
	    Context initial = new InitialContext();
	    Object objref = initial.lookup("CustomerBean");
	    
	    chome = (CustomerHome)PortableRemoteObject.narrow(objref, CustomerHome.class);
		
		objref = initial.lookup("UserRegistrationBean");
	    
	    uhome = (UserRegistrationHome)PortableRemoteObject.narrow(objref, UserRegistrationHome.class);

	    objref = initial.lookup("CompanyBean");
	    
	    cmhome = (CompanyHome)PortableRemoteObject.narrow(objref, CompanyHome.class);

	    objref = initial.lookup("CorporateRegistrationBean");
	    
	    crhome = (CorporateRegistrationHome)PortableRemoteObject.narrow(objref, CorporateRegistrationHome.class);

	    objref = initial.lookup("AuthenticatedByBean");
	    
	    abhome = (AuthenticatedByHome)PortableRemoteObject.narrow(objref, AuthenticatedByHome.class);

	    objref = initial.lookup("CompanyAuthenticatedByBean");
	    
	    cabhome = (CompanyAuthenticatedByHome)PortableRemoteObject.narrow(objref, CompanyAuthenticatedByHome.class);

		
	} catch (NamingException ne) {
	    ne.printStackTrace();
	}
	 
    }

    public AuthenticationEJB() {}
    public void setSessionContext(SessionContext sc) {}
    public void ejbRemove() {}
    public void ejbActivate() {}
    public void ejbPassivate() {}
	
    public void userReject(String userid) throws RemoteException
	{
    	try 
		{
        	UserRegistration torej = uhome.findByPrimaryKey(userid);
			torej.remove();
    	} 
		catch (FinderException fe) 
		{
        	System.err.println("Row not found - "+fe);
			throw new RemoteException("Row not found - "+fe.toString());
		}
		catch (RemoveException fe) 
		{
			System.err.println("Could not remove - "+fe);
			throw new RemoteException("Could not remove - "+fe.toString());
		}
		
    }

    public void userApprove(String userid, String authId) throws RemoteException
	{
    	try 
		{

        	UserRegistration torej = uhome.findByPrimaryKey(userid);

			Customer c = chome.create(torej.getLogin(),
						 			  torej.getName(),
			  						  torej.getDescription(),
									  torej.getPasswd(),
								 	  torej.getBankName(),
									  torej.getBankAcc(),
									  torej.getMarginMoney(),
									  torej.getStreet(),
									  torej.getCity(),
									  torej.getState(),
									  torej.getPinCode(),
									  torej.getEmail(),
									  torej.getTelephone()
									 );

			torej.remove();

			AuthenticatedBy ab = abhome.create(userid, authId, new java.util.Date());

    	}
		catch (CreateException fe)
		{
			System.err.println("Could not create - "+fe);
			throw new RemoteException("Could not create - "+fe.toString());
		} 
		catch (FinderException fe) 
		{
        	System.err.println("Row not found - "+fe);
			throw new RemoteException("Row not found - "+fe.toString());
		}
		catch (RemoveException fe)
		{
			System.err.println("Could not remove from user_registration - "+fe);
			throw new RemoteException("Could not remove from user_registration - "+fe.toString());
		}
    }
	
    public void companyReject(String userid) throws RemoteException
    {
    	try 
    	{
        	CorporateRegistration torej = crhome.findByPrimaryKey(userid);
    		torej.remove();
    	} 
    	catch (FinderException fe) 
    	{
        	System.err.println("Row not found - "+fe);
    		throw new RemoteException("Row not found - "+fe.toString());
    	}
		catch (RemoveException fe) 
		{
			System.err.println("Could not remove - "+fe);
			throw new RemoteException("Could not remove - "+fe.toString());
		}
    }

    public void companyApprove(String complogin, String companyId, String authId) throws RemoteException
    {
    	try 
    	{
        	CorporateRegistration torej = crhome.findByPrimaryKey(complogin);
    		Company c = cmhome.create(companyId,
    		  						  torej.getDescription(),
									  torej.getLogin(),
    								  torej.getPassword(),									  
    								  torej.getStreet(),
    								  torej.getCity(),
    								  torej.getState(),
    								  torej.getPinCode(),
    								  torej.getEmail(),
    								  torej.getTelephone()
    								 );
    		torej.remove();
			
			CompanyAuthenticatedBy cab = cabhome.create(companyId, authId, new java.util.Date());
    	}
    	catch (CreateException fe)
    	{
    		System.err.println("Could not create  - "+fe);
    		throw new RemoteException("Could not create - "+fe.toString());
    	} 
    	catch (FinderException fe) 
    	{
        	System.err.println("Row not found - "+fe);
    		throw new RemoteException("Row not found - "+fe.toString());
    	}
    	catch (RemoveException fe)
    	{
    		System.err.println("Could not remove from corporate_registration - "+fe);
    		throw new RemoteException("Could not remove from corporate_registration - "+fe.toString());
    	}
    }

} // AuthenticationEJB
