/*
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */
package com.parsec.ejbs.authenticator;

import java.sql.*;
import javax.sql.*;
import java.util.*;
import javax.ejb.*;
import javax.naming.*;
import com.parsec.utils.*;
 
public class AuthenticatorEJB implements EntityBean
{

	private String authenticatorId;
        private String name;
        private String login;
        private String password;

	private EntityContext context;
	private Connection con;


	public String getAuthenticatorId()
	{
		return authenticatorId;
	}
       
        public String getName()
	{
		return name;
	}
    
        public String getLogin()
        {
	       return login;
        }
	
        public String getPassword()  
	{
		return password;
	}

//Set methods

        public void setAuthenticatorId (String a)
        {
	     authenticatorId=a;
	}

        public void setName(String desc)
	{
		name = desc;
	}
	public void setLogin(String a)
	{
		login = a;
	}

	public void setPassword(String password)  
	{
		this.password = password;
	}

//End of set methods


         public String ejbCreate(String authenticatorId,
				 String name,
				 String login,
				 String password
				 )
	throws CreateException
	{

		try
		{
		    insertRow(authenticatorId,name,login,password);
		} catch (Exception ex)
		{
			throw new EJBException("ejbCreate: " + 
				ex.getMessage());
		}

		this.authenticatorId = authenticatorId;
		this.name = name;
		this.login=login;
		this.password = password;

		return authenticatorId;
	}

	public String ejbFindByPrimaryKey(String primaryKey) 
	throws FinderException
	{

		boolean result;

		try
		{
		        result = selectByPrimaryKey(primaryKey);
		} catch (Exception ex)
		{
			throw new EJBException("ejbFindByPrimaryKey: " + 
				ex.getMessage());
		}
		if (result)
		{
			return primaryKey;
		}
		else
		{
			throw new ObjectNotFoundException
				("Row for id " + primaryKey + " not found.");
		}
	}

	public void ejbRemove()
	{

		try
		{
			deleteRow(authenticatorId);
		} catch (Exception ex)
		{
			throw new EJBException("ejbRemove: " + 
				ex.getMessage());
		}
	} 

	public void setEntityContext(EntityContext context)
	{

		this.context = context;
//      try {
//	         makeConnection();
//	  } catch (Exception ex) {
//          throw new EJBException("Unable to connect to database. " +
//             ex.getMessage());
//			}
   	}

	public void unsetEntityContext()
	{

//		try
//		{
//			con.close();
//		} catch (SQLException ex)
//		{
//			throw new EJBException("unsetEntityContext: " + ex.getMessage());
//		}
	}

	public void ejbActivate()
	{

		authenticatorId = (String)context.getPrimaryKey();
	}

	public void ejbPassivate()
	{

		authenticatorId = null;
	}

	public void ejbLoad()
	{

		try
		{
			loadRow();
		} catch (Exception ex)
		{
			throw new EJBException("ejbLoad: " + 
				ex.getMessage());
		}
	}

	public void ejbStore()
	{

		try
		{
			storeRow();
		} catch (Exception ex)
		{
			throw new EJBException("ejbStore: " + 
				ex.getMessage());
		}
	}


    public void ejbPostCreate(String authenticatorId,
			      String name,
			      String login,
			      String password
			      )
    { 
    }


	/*********************** Database Routines *************************/

	private void makeConnection() throws NamingException, SQLException
	{

		DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());
		con = DriverManager.getConnection("jdbc:oracle:thin:@everest:1521:GEN","sarvjeet","sarv");
	}

	private void insertRow (String authenticatorId,
				String name,
				String login,
				String password
				) 
	throws SQLException
	{

		con=ParsecUtils.getDBConnection();
		String insertStatement =
			"insert into authenticator values (?,?,?,?)";
		PreparedStatement prepStmt = 
			con.prepareStatement(insertStatement);

		prepStmt.setString(1, authenticatorId);
		prepStmt.setString(2, name);
		prepStmt.setString(3,login);
		prepStmt.setString(4, password);

		prepStmt.executeUpdate();
		prepStmt.close();con.close();
	}

	private void deleteRow(String id) throws SQLException
	{

		con=ParsecUtils.getDBConnection();
		String deleteStatement =
			"delete from authenticator where authenticator_id = ? ";
		PreparedStatement prepStmt =
			con.prepareStatement(deleteStatement);

		prepStmt.setString(1, id);
		prepStmt.executeUpdate();
		prepStmt.close();con.close();
	}

	private boolean selectByPrimaryKey(String primaryKey) 
	throws SQLException
	{

		con=ParsecUtils.getDBConnection();
		String selectStatement =
			"select authenticator_id " +
			"from authenticator where authenticator_id = ? ";
		PreparedStatement prepStmt =
			con.prepareStatement(selectStatement);
		prepStmt.setString(1, primaryKey);

		ResultSet rs = prepStmt.executeQuery();
		boolean result = rs.next();
		prepStmt.close();con.close();
		return result;
	}



	private void loadRow() throws SQLException
	{
		con=ParsecUtils.getDBConnection();
		String selectStatement =
			"select name,login,password " +
			"from authenticator where authenticator_id = ? ";
		PreparedStatement prepStmt = 
			con.prepareStatement(selectStatement);

		prepStmt.setString(1, this.authenticatorId);

		ResultSet rs = prepStmt.executeQuery();

		if (rs.next())
		{

			this.name = rs.getString(1);
			this.login = rs.getString(2);
			this.password = rs.getString(3);

			prepStmt.close();con.close();
		}
		else
		{
			prepStmt.close();con.close();
			throw new NoSuchEntityException("Row for id " + authenticatorId +
				" not found in database.");
		}
	}


	private void storeRow() throws SQLException
	{

		con=ParsecUtils.getDBConnection();
		String updateStatement =
			"update authenticator set " +
			"name = ? , login = ? , password = ? " +
			"where authenticator_id = ? ";
		PreparedStatement prepStmt = 
			con.prepareStatement(updateStatement);

		prepStmt.setString(1, name);
		prepStmt.setString(2, login);
		prepStmt.setString(3, password);
		prepStmt.setString(4, authenticatorId);

		int rowCount = prepStmt.executeUpdate();
		prepStmt.close();con.close();

		if (rowCount == 0)
		{
			throw new EJBException("Storing row for id " + authenticatorId + " failed.");
		}
	}

} // AuthenticatorEJB 
