/*
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */
package com.parsec.ejbs.authenticator;

import java.sql.*;
import javax.sql.*;
import java.util.*;
import javax.ejb.*;
import javax.naming.*;
import com.parsec.utils.*;
 
public class CompanyAuthenticatedByEJB implements EntityBean
{

	private String companyId;
        private String authenticatorId;
        private java.util.Date authenticateDate;

	private EntityContext context;
	private Connection con;


	public String getCompanyId()
	{
		return companyId;
	}
       
        public String getAuthenticatorId()
	{
	    return authenticatorId;
	}
    
        public java.util.Date getAuthenticateDate()
        {
	       return authenticateDate;
        }

//Set methods

        public void setCompanyId (String a)
        {
	     companyId=a;
	}

        public void setAuthenticatorId(String a)
	{
		authenticatorId=a;
	}
	public void setAuthenticateDate(java.util.Date a)
	{
		 authenticateDate=a;
	}

//End of set methods


         public String ejbCreate(String companyId,
				 String authenticatorId,
				 java.util.Date authenticateDate
				 )
	throws CreateException
	{

		try
		{
		    insertRow(companyId,authenticatorId,authenticateDate);
		} catch (Exception ex)
		{
			throw new EJBException("ejbCreate: " + 
				ex.getMessage());
		}

		this.companyId=companyId;
		this.authenticatorId=authenticatorId;
		this.authenticateDate=authenticateDate;

		return companyId;
	}

	public String ejbFindByPrimaryKey(String primaryKey) 
	throws FinderException
	{

		boolean result;

		try
		{
		        result = selectByPrimaryKey(primaryKey);
		} catch (Exception ex)
		{
			throw new EJBException("ejbFindByPrimaryKey: " + 
				ex.getMessage());
		}
		if (result)
		{
			return primaryKey;
		}
		else
		{
			throw new ObjectNotFoundException
				("Row for id " + primaryKey + " not found.");
		}
	}

	public void ejbRemove()
	{

		try
		{
			deleteRow(companyId);
		} catch (Exception ex)
		{
			throw new EJBException("ejbRemove: " + 
				ex.getMessage());
		}
	} 

	public void setEntityContext(EntityContext context)
	{

		this.context = context;
//      try {
//         makeConnection();
//			} catch (Exception ex) {
//          throw new EJBException("Unable to connect to database. " +
//             ex.getMessage());
//			}
   	}

	public void unsetEntityContext()
	{

//		try
//		{
//			con.close();
//		} catch (SQLException ex)
//		{
//			throw new EJBException("unsetEntityContext: " + ex.getMessage());
//		}
	}

	public void ejbActivate()
	{

		companyId = (String)context.getPrimaryKey();
	}

	public void ejbPassivate()
	{

		companyId = null;
	}

	public void ejbLoad()
	{

		try
		{
			loadRow();
		} catch (Exception ex)
		{
			throw new EJBException("ejbLoad: " + 
				ex.getMessage());
		}
	}

	public void ejbStore()
	{

		try
		{
			storeRow();
		} catch (Exception ex)
		{
			throw new EJBException("ejbStore: " + 
				ex.getMessage());
		}
	}


    public void ejbPostCreate(String companyId,
			      String authenticatorId,
			      java.util.Date authenticateDate
			      )
    { 
    }


	/*********************** Database Routines *************************/

	private void makeConnection() throws NamingException, SQLException
	{

		DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());
		con = DriverManager.getConnection("jdbc:oracle:thin:@everest:1521:GEN","sarvjeet","sarv");
	}

	private void insertRow (String companyId,
				String authenticatorId,
				java.util.Date authenticateDate
				) 
	throws SQLException
	{

		con=ParsecUtils.getDBConnection();
		String insertStatement =
			"insert into company_authenticated_by values (?,?,?)";
		PreparedStatement prepStmt = 
			con.prepareStatement(insertStatement);

		prepStmt.setString(1, companyId);
		prepStmt.setString(2, authenticatorId);
		prepStmt.setTimestamp(3,new java.sql.Timestamp(authenticateDate.getTime()));

		prepStmt.executeUpdate();
		prepStmt.close();con.close();
	}

	private void deleteRow(String id) throws SQLException
	{

		con=ParsecUtils.getDBConnection();
		String deleteStatement =
			"delete from company_authenticated_by where company_id = ? ";
		PreparedStatement prepStmt =
			con.prepareStatement(deleteStatement);

		prepStmt.setString(1, id);
		prepStmt.executeUpdate();
		prepStmt.close();con.close();
	}

	private boolean selectByPrimaryKey(String primaryKey) 
	throws SQLException
	{

		con=ParsecUtils.getDBConnection();
		String selectStatement =
			"select company_id " +
			"from company_authenticated_by where company_id = ? ";
		PreparedStatement prepStmt =
			con.prepareStatement(selectStatement);
		prepStmt.setString(1, primaryKey);

		ResultSet rs = prepStmt.executeQuery();
		boolean result = rs.next();
		prepStmt.close();con.close();
		return result;
	}



	private void loadRow() throws SQLException
	{
		con=ParsecUtils.getDBConnection();
		String selectStatement =
			"select authenticator_id,authenticate_date " +
			"from company_authenticated_by where company_id = ? ";
		PreparedStatement prepStmt = 
			con.prepareStatement(selectStatement);

		prepStmt.setString(1, this.companyId);

		ResultSet rs = prepStmt.executeQuery();

		if (rs.next())
		{
		        this.authenticatorId=rs.getString(1);
			this.authenticateDate=new java.util.Date(rs.getTimestamp(2).getTime());
			prepStmt.close();con.close();
		}
		else
		{
			prepStmt.close();con.close();
			throw new NoSuchEntityException("Row for id " + companyId +
				" not found in database.");
		}
	}


	private void storeRow() throws SQLException
	{
		con=ParsecUtils.getDBConnection();

		String updateStatement =
			"update company_authenticated_by set " +
			"authenticator_id = ? , authenticate_date = ? " +
			"where company_id = ? ";
		PreparedStatement prepStmt = 
			con.prepareStatement(updateStatement);

		prepStmt.setString(1, authenticatorId);
		prepStmt.setTimestamp(2, new java.sql.Timestamp(authenticateDate.getTime()));
 		prepStmt.setString(3, companyId);

		int rowCount = prepStmt.executeUpdate();
		prepStmt.close();con.close();

		if (rowCount == 0)
		{
			throw new EJBException("Storing row for id " + companyId + " failed.");
		}
	}

} // CompanyAuthenticatedByEJB 
