/*
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */
package com.parsec.ejbs.bidbuy;

import java.sql.*;
import javax.sql.*;
import java.util.*;
import javax.ejb.*;
import javax.naming.*;
import com.parsec.utils.*;
 
public class BuyingCallEJB implements EntityBean
{

	private String customerId;
	private String shareId;
	private java.util.Date bidTime;
        private java.util.Date expiryTime;
	private int noOfShares;
        private float price;

	private EntityContext context;
	private Connection con;


	public String getCustomerId()
	{
	    return customerId;
	}

        public String getShareId()  
	{
		return shareId;
	}
	public java.util.Date getBidTime()
	{
		return bidTime;
	}

        public java.util.Date getExpiryTime()
	{
		return expiryTime;
	}
    
        public int getNoOfShares()
        {
	    return noOfShares;
	}

        public float getPrice()
        {
	    return price;
	}

//Set methods

	public void setCustomerId(String a)
	{
		customerId = a;
	}

	public void setShareId(String a)  
	{
		shareId = a;
	}
	
        public void setBidTime(java.util.Date a)
	{
		bidTime = a;
	}

        public void setExpiryTime(java.util.Date a)
	{
		expiryTime = a;
	}

        public void setNoOfShares(int a)
	{
		noOfShares = a;
	}

	public void setPrice(float a)  
	{
		price = a;
	}



//End of set methods


	public BuySellPrimaryKey ejbCreate(String customerId,
					String shareId,
					java.util.Date bidTime,
					java.util.Date expiryTime,
					int noOfShares,
					float price
					)
	throws CreateException
	{
	    if (customerId == null || shareId == null) {
		throw new CreateException("All primary keys are required.");
	    }
		try
		{
			insertRow(customerId,shareId,bidTime,expiryTime,noOfShares,price);
		} catch (Exception ex)
		{
			throw new EJBException("ejbCreate: " + 
				ex.getMessage());
		}

		this.customerId = customerId;
		this.shareId = shareId;
		this.bidTime = bidTime;
		this.expiryTime = expiryTime;
		this.noOfShares = noOfShares;
		this.price = price;

		return new BuySellPrimaryKey(customerId,shareId);
	}

	public BuySellPrimaryKey ejbFindByPrimaryKey(BuySellPrimaryKey primaryKey) 
	throws FinderException
	{

		boolean result;

		try
		{
			result = selectByPrimaryKey(primaryKey);
		} catch (Exception ex)
		{
			throw new EJBException("ejbFindByPrimaryKey: " + 
				ex.getMessage());
		}
		if (result)
		{
			return primaryKey;
		}
		else
		{
			throw new ObjectNotFoundException
				("Row for id " + primaryKey + " not found.");
		}
	}

	public Collection ejbFindByCustomerId(String customerId)
	    throws FinderException {

	    Collection result;
	    
	    try {
		result = selectByCustomerId(customerId);
	    } catch (Exception ex) {
		throw new EJBException("ejbFindByLastName " + 
				       ex.getMessage());
	    }
	    
	    if (result.isEmpty()) {
		throw new ObjectNotFoundException("No rows found.");
	    }
	    else {
		return result;
	    }
	}
	
        public Collection ejbFindByShareId(String shareId)
	    throws FinderException {

	    Collection result;
	    
	    try {
		result = selectByShareId(shareId);
	    } catch (Exception ex) {
		throw new EJBException("ejbFindByShareId " + 
				       ex.getMessage());
	    }
	    
	    if (result.isEmpty()) {
		throw new ObjectNotFoundException("No rows found.");
	    }
	    else {
		return result;
	    }
	}


	public void ejbRemove()
	{

		try
		{
			deleteRow(customerId,shareId);
		} catch (Exception ex)
		{
			throw new EJBException("ejbRemove: " + 
				ex.getMessage());
		}
	} 

	public void setEntityContext(EntityContext context)
	{

		this.context = context;
//      try {
//         makeConnection();
//			} catch (Exception ex) {
//          throw new EJBException("Unable to connect to database. " +
//             ex.getMessage());
//			}
   	}

	public void unsetEntityContext()
	{

//		try
//		{
//			System.out.println("buying call");
//			con.close();
//		} catch (SQLException ex)
//		{
//			throw new EJBException("unsetEntityContext: " + ex.getMessage());
//		}
	}

	public void ejbActivate()
	{
	    BuySellPrimaryKey temp= (BuySellPrimaryKey) context.getPrimaryKey();
	    customerId = temp.getCustomerId();
	    shareId = temp.getShareId();
		System.out.println("Buying call on"+shareId);
	}

	public void ejbPassivate()
	{

	    customerId = null;
	    shareId = null;
		System.out.println("Buying call off");
	}

	public void ejbLoad()
	{

		try
		{
			loadRow();
		} catch (Exception ex)
		{
			throw new EJBException("ejbLoad: " + 
				ex.getMessage());
		}
	}

	public void ejbStore()
	{

		try
		{
			storeRow();
		} catch (Exception ex)
		{
			throw new EJBException("ejbStore: " + 
				ex.getMessage());
		}
	}


	public void ejbPostCreate(String customerId,
				  String shareId,
				  java.util.Date bidTime,
				  java.util.Date expiryTime,
				  int noOfShares,
				  float price
				  )
	{ 
	}


	/*********************** Database Routines *************************/

	private void makeConnection() throws NamingException, SQLException
	{
		System.out.println("Making con for :"+shareId);
		if (con == null)
		{
			DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());
			con = DriverManager.getConnection("jdbc:oracle:thin:@everest:1521:GEN","sarvjeet","sarv");
		}
	}

	private void insertRow (String customerId,
				String shareId,
				java.util.Date bidTime,
				java.util.Date expiryTime,
				int noOfShares,
				float price
				)
	throws SQLException
	{
		con=ParsecUtils.getDBConnection();

		String insertStatement =
			"insert into buying_call values (?,?,?,?,?,?)";
		PreparedStatement prepStmt = 
			con.prepareStatement(insertStatement);

		prepStmt.setString(1, customerId);
		prepStmt.setString(2, shareId);
		prepStmt.setTimestamp(3, new java.sql.Timestamp(bidTime.getTime()));
		prepStmt.setTimestamp(4, new java.sql.Timestamp(expiryTime.getTime()));
		prepStmt.setInt(5, noOfShares);
		prepStmt.setFloat(6, price);

		prepStmt.executeUpdate();
		prepStmt.close();
		con.close();
	}

	private void deleteRow(String a,String b) throws SQLException
	{
		con=ParsecUtils.getDBConnection();
		String deleteStatement =
			"delete from buying_call where (customer_id = ?) and (share_id = ?) and (bid_time = ?)";
		PreparedStatement prepStmt =
			con.prepareStatement(deleteStatement);

		prepStmt.setString(1, a);
		prepStmt.setString(2, b);
		prepStmt.setTimestamp(3, new java.sql.Timestamp(bidTime.getTime()));
		
		prepStmt.executeUpdate();
		prepStmt.close();
		con.close();
	}

	private boolean selectByPrimaryKey(BuySellPrimaryKey primaryKey) 
	throws SQLException
	{
		con=ParsecUtils.getDBConnection();
		String selectStatement =
			"select customer_id " +
			"from buying_call where (customer_id = ?) and (share_id = ?) ";
		PreparedStatement prepStmt =
			con.prepareStatement(selectStatement);
		prepStmt.setString(1, primaryKey.getCustomerId());
		prepStmt.setString(2, primaryKey.getShareId());

		ResultSet rs = prepStmt.executeQuery();
		boolean result = rs.next();
		prepStmt.close();con.close();
		return result;
	}

	private Collection selectByCustomerId(String customerId) 
	    throws SQLException {
	    con=ParsecUtils.getDBConnection();
	    String selectStatement =
		"select share_id " +
		"from buying_call where customer_id = ? ";
	    PreparedStatement prepStmt = 
		con.prepareStatement(selectStatement);
	    
	    prepStmt.setString(1, customerId);
	    ResultSet rs = prepStmt.executeQuery();
	    Vector a = new Vector();
	    
	    while (rs.next()) {
		BuySellPrimaryKey key = new BuySellPrimaryKey(customerId,rs.getString(1));
		a.add(key);
	    }
	    
	    prepStmt.close();con.close();
	    return a;
	}

        private Collection selectByShareId(String shareId) 
	    throws SQLException {
	    
		con=ParsecUtils.getDBConnection();
	    String selectStatement =
		"select customer_id " +
		"from buying_call where share_id = ? ";
	    PreparedStatement prepStmt = 
		con.prepareStatement(selectStatement);
	    
	    prepStmt.setString(1, shareId);
	    ResultSet rs = prepStmt.executeQuery();
	    Vector a = new Vector();
	    
	    while (rs.next()) {
		BuySellPrimaryKey key = new BuySellPrimaryKey(rs.getString(1),shareId);
		a.add(key);
	    }
	    
	    prepStmt.close();con.close();
	    return a;
	}
	
	private void loadRow() throws SQLException
	{
		con=ParsecUtils.getDBConnection();
		String selectStatement =
			"select bid_time, expiry_time, no_of_shares, price " +
			"from buying_call where (customer_id = ?) and (share_id = ?)";
		PreparedStatement prepStmt = 
			con.prepareStatement(selectStatement);

		prepStmt.setString(1, this.customerId);
		prepStmt.setString(2, this.shareId);

		ResultSet rs = prepStmt.executeQuery();

		if (rs.next())
		{
		        this.bidTime = new java.util.Date(rs.getTimestamp(1).getTime());
			this.expiryTime = new java.util.Date(rs.getTimestamp(2).getTime());
		        this.noOfShares = rs.getInt(3);
		        this.price = rs.getFloat(4);
		        prepStmt.close();con.close();
		}
		else
		{
			prepStmt.close();con.close();
			throw new NoSuchEntityException("Row for Primary Key not found in table buying_call");
		}
	}


	private void storeRow() throws SQLException
	{
		
		con=ParsecUtils.getDBConnection();
		String updateStatement =
			"update buying_call set bid_time =  ? , " +
			"expiry_time = ? , "+
		        "no_of_shares = ? , " +
		        "price = ?  " +
			"where (customer_id = ?) and (share_id = ?)";
		PreparedStatement prepStmt = 
			con.prepareStatement(updateStatement);

		prepStmt.setTimestamp(1, new java.sql.Timestamp(bidTime.getTime()));
		prepStmt.setTimestamp(2, new java.sql.Timestamp(expiryTime.getTime()));
		prepStmt.setInt(3, noOfShares);
		prepStmt.setFloat(4, price);
		prepStmt.setString(5, customerId);
		prepStmt.setString(6, shareId);

		int rowCount = prepStmt.executeUpdate();
		prepStmt.close();con.close();
		

		if (rowCount == 0)
		{
			throw new EJBException("Storing row for primary key failed.in table buying_call");
		}
	}

} // Buying_CallEJB
