package com.parsec.ejbs.bidbuy;

import javax.ejb.*;
import javax.naming.*;
import java.rmi.*;
import javax.rmi.*;
import java.util.*;
import java.io.*;

public class CancelBidEJB implements SessionBean
{

    BuyingCallHome bhome;
	SellingCallHome shome;

    public void ejbCreate() {
	try 
	{
	    Context initial = new InitialContext();
	    Object objref = initial.lookup("BuyingCallBean");
	    
	    bhome = (BuyingCallHome)PortableRemoteObject.narrow(objref, BuyingCallHome.class);
		
		objref = initial.lookup("SellingCallBean");
	    
	    shome = (SellingCallHome)PortableRemoteObject.narrow(objref, SellingCallHome.class);
	} 
	catch (NamingException ne) 
	{
	    ne.printStackTrace();
	} 
	 
    } //End ejbCreate

    public CancelBidEJB() {}
    public void setSessionContext(SessionContext sc) {}
    public void ejbRemove() {}
    public void ejbActivate() {}
    public void ejbPassivate() {}
	
    public void cancelBuy(String userid, String shareid, Date bidtime, Date expirytime, int numshares, float price) throws RemoteException
	{
				
    	try 
		{
        	Vector bcvec = new Vector(bhome.findByCustomerId(userid));
			BuyingCall bc;
			
			for (int i=0; i<bcvec.size(); i++)
			{
				bc = (BuyingCall) bcvec.elementAt(i);
				if ( (bc.getShareId().equals(shareid)) &&
					 (bc.getBidTime().equals(bidtime)) &&
					 (bc.getExpiryTime().equals(expirytime))
				   )
				{
					bc.remove();
				}
			}
    	} 
		catch (FinderException fe) 
		{
        	System.err.println("Row not found in buying_call - "+fe);
			throw new EJBException("Could not find user");
		}
		catch (RemoveException fe) 
		{
        	System.err.println("Could not remove from buying_call - "+fe);
			throw new EJBException("Internal server error");
		}
    }

    public void cancelSell(String userid, String shareid, Date bidtime, Date expirytime, int numshares, float price) throws RemoteException
    {
    			
    	try 
    	{
        	Vector bcvec = new Vector(shome.findByCustomerId(userid));
    		SellingCall bc;
    		
    		for (int i=0; i<bcvec.size(); i++)
    		{
    			bc = (SellingCall) bcvec.elementAt(i);
    			if ( (bc.getShareId().equals(shareid)) &&
    				 (bc.getBidTime().equals(bidtime)) &&
    				 (bc.getExpiryTime().equals(expirytime))
    			   )
    			{
    				bc.remove();
    			}
    		}
    	} 
    	catch (FinderException fe) 
    	{
        	System.err.println("Row not found in selling_call - "+fe);
    		throw new RemoteException("Row not found in selling_call - "+fe.toString());
    	}
    	catch (RemoveException fe) 
    	{
        	System.err.println("Could not remove from selling_call - "+fe);
    		throw new RemoteException("Could not remove from selling_call - "+fe.toString());
    	}
    }
} // CancelBidEJB
