package com.parsec.ejbs.bidbuy;

import javax.ejb.*;
import javax.naming.*;
import java.rmi.*;
import javax.rmi.*;
import java.util.*;
import java.io.*;
import com.parsec.ejbs.share.*;
import com.parsec.utils.*;

public class PlaceBidEJB implements SessionBean
{

    BuyingCallHome bhome;
	SellingCallHome shome;
	CurrentShareStateHome cshome;
	int swingmargin;

    public void ejbCreate() {
	try 
	{
	    Context initial = new InitialContext();
	    Object objref = initial.lookup("BuyingCallBean");
	    
	    bhome = (BuyingCallHome)PortableRemoteObject.narrow(objref, BuyingCallHome.class);
		
		objref = initial.lookup("SellingCallBean");
	    
	    shome = (SellingCallHome)PortableRemoteObject.narrow(objref, SellingCallHome.class);

	    objref = initial.lookup("CurrentShareStateBean");
	    
	    cshome = (CurrentShareStateHome)PortableRemoteObject.narrow(objref, CurrentShareStateHome.class);

		swingmargin = ParsecUtils.getSwingMargin();
		System.out.println("Swing Margin= "+swingmargin);
	} 
	catch (NamingException ne) 
	{
	    ne.printStackTrace();
	} 
	
	 
    } //End ejbCreate

    public PlaceBidEJB() {}
    public void setSessionContext(SessionContext sc) {}
    public void ejbRemove() {}
    public void ejbActivate() {}
    public void ejbPassivate() {}
	
    public boolean doBuy(String userid, String shareid, Date expirytime, int numshares, float price) throws RemoteException
	{
		float swing;
		CurrentShareState css;
		try
		{
			System.out.println("Came here");
			css = cshome.findByPrimaryKey(shareid);
		
			swing = swingmargin * css.getCurrentPrice() / 100;
			System.out.println("Swing = "+swing);
			

		}
		catch (FinderException fe)
		{
			System.err.println("Row not found - "+fe);
			//throw new RemoteException("Share with id "+shareid+" does not exist");
			return false;
		}
		if (Math.abs(price - css.getCurrentPrice()) > swing)
		{
			System.err.println("Price out of range");
			return false;
			//throw new IllegalArgumentException("Price specified is out of range");
		}
		
    	try 
		{
        	BuyingCall potential = bhome.create(userid, shareid, new Date(), expirytime, numshares, price);
    	} 
		catch (CreateException fe) 
		{
        	System.err.println("Could not create in buying_call - "+fe);
			//throw new RemoteException("Internal server error");
			return false;
		}
		return true;
    }
	
    public boolean doSell(String userid, String shareid, Date expirytime, int numshares, float price) throws RemoteException
    {
		float swing;
		CurrentShareState css;
		try
		{

			css = cshome.findByPrimaryKey(shareid);
			
			swing = swingmargin * css.getCurrentPrice() / 100;
			System.out.println("Swing = "+swing);
			

		}
		catch (FinderException fe)
		{
			System.err.println("Row not found - "+fe);
			//throw new RemoteException("Share with id "+shareid+" does not exist");
			return false;
		}
		if (Math.abs(price - css.getCurrentPrice()) > swing)
		{
			System.err.println("Price out of range");
			//throw new RemoteException("Price specified is out of range");
			return false;
		}
		
    	try 
    	{
        	SellingCall potential = shome.create(userid, shareid, new Date(), expirytime, numshares, price);
    	} 
    	catch (CreateException fe) 
    	{
        	System.err.println("Could not create in selling_call - "+fe);
			//throw new RemoteException("Internal server error");
			return false;
    	}
		return true;
    }
	

} // PlaceBidEJB
