/*
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */
package com.parsec.ejbs.company;

import java.sql.*;
import javax.sql.*;
import java.util.*;
import javax.ejb.*;
import javax.naming.*;
import com.parsec.utils.*;
 
public class CompanyEJB implements EntityBean
{

	private String companyId;
        private String description;
        private String login;
        private String password;
	private String street;
	private String city;
	private String state;
	private String pinCode;
	private String email;
	private String telephone;

	private EntityContext context;
	private Connection con;


	public String getCompanyId()
	{
		return companyId;
	}
       
        public String getDescription()
	{
		return description;
	}
    
        public String getLogin()
        {
	       return login;
        }
	
        public String getPassword()  
	{
		return password;
	}

	public String getStreet()
	{
		return street;
	}
	public String getCity()
	{
		return city;
	}
	public String getState()
	{
		return state;
	}
	public String getPinCode()
	{
		return pinCode;
	}
	public String getEmail()
	{
		return email;
	}
	public String getTelephone()
	{
		return telephone;
	}

//Set methods

        public void setCompanyId (String a)
        {
	     companyId=a;
	}

        public void setDescription(String desc)
	{
		description = desc;
	}
	public void setLogin(String a)
	{
		login = a;
	}

	public void setPassword(String passwd)  
	{
		this.password = passwd;
	}
	public void setStreet(String st)
	{
		street = st;
	}
	public void setCity(String c)
	{
		city = c;
	}
	public void setState(String s)
	{
		state = s;
	}
	public void setPinCode(String p)
	{
		pinCode = p;
	}
	public void setEmail(String e)
	{
		email = e;
	}
	public void setTelephone(String t)
	{
		telephone = t;
	}

//End of set methods


         public String ejbCreate(String companyId,
				 String description,
				 String login,
				 String password,
				 String street,
				 String city,
				 String state,
				 String pinCode,
				 String email,
				 String telephone
				 )
	throws CreateException
	{

		try
		{
		    insertRow(companyId,description,login,password,
				street,city,state,pinCode,email,telephone);
		} catch (Exception ex)
		{
			throw new EJBException("ejbCreate: " + 
				ex.getMessage());
		}

		this.companyId = companyId;
		this.description = description;
		this.login=login;
		this.password = password;
		this.street = street;
		this.city = city;
		this.state = state;
		this.pinCode = pinCode;
		this.email = email;
		this.telephone = telephone;

		return companyId;
	}

	public String ejbFindByPrimaryKey(String primaryKey) 
	throws FinderException
	{

		boolean result;

		try
		{
		        result = selectByPrimaryKey(primaryKey);
		} catch (Exception ex)
		{
			throw new EJBException("ejbFindByPrimaryKey: " + 
				ex.getMessage());
		}
		if (result)
		{
			return primaryKey;
		}
		else
		{
			throw new ObjectNotFoundException
				("Row for id " + primaryKey + " not found.");
		}
	}

    public Collection ejbFindByNameDesc(String name)
	    throws FinderException {

	    Collection result;
	    
	    try {
		result = selectByNameDesc(name);
	    } catch (Exception ex) {
		throw new EJBException("ejbFindByNameDesc " + 
				       ex.getMessage());
	    }
	    
	    if (result.isEmpty()) {
		throw new ObjectNotFoundException("No rows found.");
	    }
	    else {
		return result;
	    }
	}


	public void ejbRemove()
	{

		try
		{
			deleteRow(companyId);
		} catch (Exception ex)
		{
			throw new EJBException("ejbRemove: " + 
				ex.getMessage());
		}
	} 

	public void setEntityContext(EntityContext context)
	{

		this.context = context;
//      try {
//         makeConnection();
//			} catch (Exception ex) {
//          throw new EJBException("Unable to connect to database. " +
//             ex.getMessage());
//			}
   	}

	public void unsetEntityContext()
	{

//		try
//		{
//			con.close();
//		} catch (SQLException ex)
//		{
//			throw new EJBException("unsetEntityContext: " + ex.getMessage());
//		}
	}

	public void ejbActivate()
	{

		companyId = (String)context.getPrimaryKey();
	}

	public void ejbPassivate()
	{

		companyId = null;
	}

	public void ejbLoad()
	{

		try
		{
			loadRow();
		} catch (Exception ex)
		{
			throw new EJBException("ejbLoad: " + 
				ex.getMessage());
		}
	}

	public void ejbStore()
	{

		try
		{
			storeRow();
		} catch (Exception ex)
		{
			throw new EJBException("ejbStore: " + 
				ex.getMessage());
		}
	}


    public void ejbPostCreate(String companyId,
			      String description,
			      String login,
			      String password,
			      String street,
			      String city,
			      String state,
			      String pinCode,
			      String email,
			      String telephone
			      )
    { 
    }


	/*********************** Database Routines *************************/

	private void makeConnection() throws NamingException, SQLException
	{

		DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());
		con = DriverManager.getConnection("jdbc:oracle:thin:@everest:1521:GEN","sarvjeet","sarv");
	}

	private void insertRow (String companyId,
				String description,
				String login,
				String password,
				String street,
				String city,
				String state,
				String pinCode,
				String email,
				String telephone
				) 
	throws SQLException
	{
		con=ParsecUtils.getDBConnection();
		String insertStatement =
			"insert into company values (?,?,?,?,?,?,?,?,?,?)";
		PreparedStatement prepStmt = 
			con.prepareStatement(insertStatement);

		prepStmt.setString(1, companyId);
		prepStmt.setString(2, description);
		prepStmt.setString(3,login);
		prepStmt.setString(4, password);
		prepStmt.setString(5, street);
		prepStmt.setString(6, city);
		prepStmt.setString(7, state);
		prepStmt.setString(8, pinCode);
		prepStmt.setString(9, email);
		prepStmt.setString(10, telephone);
		prepStmt.executeUpdate();
		prepStmt.close();con.close();
	}

	private void deleteRow(String id) throws SQLException
	{

		con=ParsecUtils.getDBConnection();
		String deleteStatement =
			"delete from company where company_id = ? ";
		PreparedStatement prepStmt =
			con.prepareStatement(deleteStatement);

		prepStmt.setString(1, id);
		prepStmt.executeUpdate();
		prepStmt.close();con.close();
	}

	private boolean selectByPrimaryKey(String primaryKey) 
	throws SQLException
	{

		con=ParsecUtils.getDBConnection();
		String selectStatement =
			"select company_id " +
			"from company where company_id = ? ";
		PreparedStatement prepStmt =
			con.prepareStatement(selectStatement);
		prepStmt.setString(1, primaryKey);

		ResultSet rs = prepStmt.executeQuery();
		boolean result = rs.next();
		prepStmt.close();con.close();
		return result;
	}

	private Collection selectByNameDesc(String name) 
	    throws SQLException {
	    
		con=ParsecUtils.getDBConnection();
	    String selectStatement =
		"select company_id, description " +
		"from company";
	    PreparedStatement prepStmt = 
		con.prepareStatement(selectStatement);
	    
	    ResultSet rs = prepStmt.executeQuery();
	    Vector a = new Vector();
	    
	    while (rs.next()) {

		if ((rs.getString(2).toLowerCase().indexOf(name.toLowerCase())) != -1)
		{
		    a.add(rs.getString(1));
		}
	    }
	    
	    prepStmt.close();con.close();
	    return a;
	}


	private void loadRow() throws SQLException
	{
	
		con=ParsecUtils.getDBConnection();
		String selectStatement =
			"select description,login,password," +
			"street,city,state,pincode,email,telephone " +
			"from company where company_id = ? ";
		PreparedStatement prepStmt = 
			con.prepareStatement(selectStatement);

		prepStmt.setString(1, this.companyId);

		ResultSet rs = prepStmt.executeQuery();

		if (rs.next())
		{

			this.description = rs.getString(1);
			this.login = rs.getString(2);
			this.password = rs.getString(3);
			this.street = rs.getString(4);
			this.city = rs.getString(5);
			this.state = rs.getString(6);
			this.pinCode = rs.getString(7);
			this.email = rs.getString(8);
			this.telephone =rs.getString(9);
			prepStmt.close();con.close();
		}
		else
		{
			prepStmt.close();con.close();
			throw new NoSuchEntityException("Row for id " + companyId +
				" not found in database.");
		}
	}


	private void storeRow() throws SQLException
	{

		con=ParsecUtils.getDBConnection();
		String updateStatement =
			"update company set " +
			"description = ? , login = ? , password = ? , " +
			"street = ? , " +
			"city = ? , state = ? , " +
			"pincode = ? , email = ? , " +
			"telephone = ? " +
			"where company_id = ? ";
		PreparedStatement prepStmt = 
			con.prepareStatement(updateStatement);

		prepStmt.setString(1, description);
		prepStmt.setString(2, login);
		prepStmt.setString(3, password);
		prepStmt.setString(4, street);
		prepStmt.setString(5, city);
		prepStmt.setString(6, state);
		prepStmt.setString(7, pinCode);
		prepStmt.setString(8, email);
		prepStmt.setString(9, telephone);
		prepStmt.setString(10, companyId);

		int rowCount = prepStmt.executeUpdate();
		prepStmt.close();con.close();

		if (rowCount == 0)
		{
			throw new EJBException("Storing row for id " + companyId + " failed.");
		}
	}

} // CompanyEJB 
