/*
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */
package com.parsec.ejbs.company;

import java.sql.*;
import javax.sql.*;
import java.util.*;
import javax.ejb.*;
import javax.naming.*;
import com.parsec.utils.*;
 
public class CorporateRegistrationEJB implements EntityBean
{

	private String login;
	private String password;
	private String description;
	private String street;
	private String city;
	private String state;
	private String pinCode;
	private String email;
	private String telephone;

	private EntityContext context;
	private Connection con;


	public String getLogin()
	{
		return login;
	}

	public String getPassword()  
	{
		return password;
	}

	public String getDescription()
	{
		return description;
	}
	public String getStreet()
	{
		return street;
	}
	public String getCity()
	{
		return city;
	}
	public String getState()
	{
		return state;
	}
	public String getPinCode()
	{
		return pinCode;
	}
	public String getEmail()
	{
		return email;
	}
	public String getTelephone()
	{
		return telephone;
	}

//Set methods

	public void setLogin(String userid)
	{
		login = userid;
	}

	public void setPassword(String password)  
	{
		this.password = password;
	}
	public void setDescription(String desc)
	{
		description = desc;
	}
	public void setStreet(String st)
	{
		street = st;
	}
	public void setCity(String c)
	{
		city = c;
	}
	public void setState(String s)
	{
		state = s;
	}
	public void setPinCode(String p)
	{
		pinCode = p;
	}
	public void setEmail(String e)
	{
		email = e;
	}
	public void setTelephone(String t)
	{
		telephone = t;
	}

//End of set methods


	public String ejbCreate(String login, 
		String description,
		String password, 
		String street,
		String city,
		String state,
		String pinCode,
		String email,
		String telephone
		)
	throws CreateException
	{

		try
		{
			insertRow(login,description,password,
				street,city,state,pinCode,email,telephone);
		} catch (Exception ex)
		{
			throw new EJBException("ejbCreate: " + 
				ex.getMessage());
		}

		this.login = login;
		this.description = description;
		this.password = password;
		this.street = street;
		this.city = city;
		this.state = state;
		this.pinCode = pinCode;
		this.email = email;
		this.telephone = telephone;

		return login;
	}

	public String ejbFindByPrimaryKey(String primaryKey) 
	throws FinderException
	{

		boolean result;

		try
		{
			result = selectByPrimaryKey(primaryKey);
		} catch (Exception ex)
		{
			throw new EJBException("ejbFindByPrimaryKey: " + 
				ex.getMessage());
		}
		if (result)
		{
			return primaryKey;
		}
		else
		{
			throw new ObjectNotFoundException
				("Row for id " + primaryKey + " not found.");
		}
	}

       	public Collection ejbFindAll()
	    throws FinderException {

	    Collection result;
	    
	    try {
		result = selectAll();
	    } catch (Exception ex) {
		throw new EJBException("ejbFindAll " + 
				       ex.getMessage());
	    }
	    
	    if (result.isEmpty()) {
		throw new ObjectNotFoundException("No rows found.");
	    }
	    else {
		return result;
	    }
	}


        public void ejbRemove()
	{

		try
		{
			deleteRow(login);
		} catch (Exception ex)
		{
			throw new EJBException("ejbRemove: " + 
				ex.getMessage());
		}
	} 

	public void setEntityContext(EntityContext context)
	{

		this.context = context;
//      try {
//         makeConnection();
//	} catch (Exception ex) {
//         throw new EJBException("Unable to connect to database. " +
//             ex.getMessage());
//			}
   	}

	public void unsetEntityContext()
	{

//		try
//		{
//			con.close();
//		} catch (SQLException ex)
//		{
//			throw new EJBException("unsetEntityContext: " + ex.getMessage());
//		}
	}

	public void ejbActivate()
	{

		login = (String)context.getPrimaryKey();
	}

	public void ejbPassivate()
	{

		login = null;
	}

	public void ejbLoad()
	{

		try
		{
			loadRow();
		} catch (Exception ex)
		{
			throw new EJBException("ejbLoad: " + 
				ex.getMessage());
		}
	}

	public void ejbStore()
	{

		try
		{
			storeRow();
		} catch (Exception ex)
		{
			throw new EJBException("ejbStore: " + 
				ex.getMessage());
		}
	}


	public void ejbPostCreate(String login, 
		String description,
		String password, 
		String street,
		String city,
		String state,
		String pinCode,
		String email,
		String telephone
		)
	{ 
	}


	/*********************** Database Routines *************************/

	private void makeConnection() throws NamingException, SQLException
	{

		DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());
		con = DriverManager.getConnection("jdbc:oracle:thin:@everest:1521:GEN","sarvjeet","sarv");
	}

	private void insertRow (String login, 
		String description,
		String password, 
		String street,
		String city,
		String state,
		String pinCode,
		String email,
		String telephone
		) 
	throws SQLException
	{
		con=ParsecUtils.getDBConnection();
		String insertStatement =
			"insert into corporate_registration values (?,?,?,?,?,?,?,?,?)";
		PreparedStatement prepStmt = 
			con.prepareStatement(insertStatement);

		prepStmt.setString(1, login);
		prepStmt.setString(2, description);
		prepStmt.setString(3, password);
		prepStmt.setString(4, street);
		prepStmt.setString(5, city);
		prepStmt.setString(6, state);
		prepStmt.setString(7, pinCode);
		prepStmt.setString(8, email);
		prepStmt.setString(9, telephone);
		prepStmt.executeUpdate();
		prepStmt.close();con.close();
	}

	private void deleteRow(String id) throws SQLException
	{

		con=ParsecUtils.getDBConnection();
		String deleteStatement =
			"delete from corporate_registration where login = ? ";
		PreparedStatement prepStmt =
			con.prepareStatement(deleteStatement);

		prepStmt.setString(1, id);
		prepStmt.executeUpdate();
		prepStmt.close();con.close();
	}

	private boolean selectByPrimaryKey(String primaryKey) 
	throws SQLException
	{
	
		con=ParsecUtils.getDBConnection();

		String selectStatement =
			"select login " +
			"from corporate_registration where login = ? ";
		PreparedStatement prepStmt =
			con.prepareStatement(selectStatement);
		prepStmt.setString(1, primaryKey);

		ResultSet rs = prepStmt.executeQuery();
		boolean result = rs.next();
		prepStmt.close();con.close();
		return result;
	}


    private Collection selectAll() 
	    throws SQLException {
	    
		con=ParsecUtils.getDBConnection();
	    String selectStatement =
		"select login " +
		"from corporate_registration";
	    PreparedStatement prepStmt = 
		con.prepareStatement(selectStatement);
	    
	    ResultSet rs = prepStmt.executeQuery();
	    Vector a = new Vector();
	    
	    while (rs.next()) {
		a.add(rs.getString(1));
	    }
	    
	    prepStmt.close();con.close();
	    return a;
	}



	private void loadRow() throws SQLException
	{
	
		con=ParsecUtils.getDBConnection();
		String selectStatement =
			"select description,password," +
			"street,city,state,pincode,email,telephone " +
			"from corporate_registration where login = ? ";
		PreparedStatement prepStmt = 
			con.prepareStatement(selectStatement);

		prepStmt.setString(1, this.login);

		ResultSet rs = prepStmt.executeQuery();

		if (rs.next())
		{

			this.description = rs.getString(1);
			this.password = rs.getString(2);
			this.street = rs.getString(3);
			this.city = rs.getString(4);
			this.state = rs.getString(5);
			this.pinCode = rs.getString(6);
			this.email = rs.getString(7);
			this.telephone =rs.getString(8);
			prepStmt.close();con.close();
		}
		else
		{
			prepStmt.close();con.close();
			throw new NoSuchEntityException("Row for id " + login +
				" not found in database.");
		}
	}


	private void storeRow() throws SQLException
	{

		con=ParsecUtils.getDBConnection();
		String updateStatement =
			"update corporate_registration set " +
			"description = ? , password = ? , " +
			"street = ? , " +
			"city = ? , state = ? , " +
			"pincode = ? , email = ? , " +
			"telephone = ? " +
			"where login = ? ";
		PreparedStatement prepStmt = 
			con.prepareStatement(updateStatement);

		prepStmt.setString(1, description);
		prepStmt.setString(2, password);
		prepStmt.setString(3, street);
		prepStmt.setString(4, city);
		prepStmt.setString(5, state);
		prepStmt.setString(6, pinCode);
		prepStmt.setString(7, email);
		prepStmt.setString(8, telephone);
		prepStmt.setString(9, login);

		int rowCount = prepStmt.executeUpdate();
		prepStmt.close();con.close();

		if (rowCount == 0)
		{
			throw new EJBException("Storing row for id " + login + " failed.");
		}
	}

} // CorporateRigistrationEJB 
