/*
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */
package com.parsec.ejbs.config;

import java.sql.*;
import javax.sql.*;
import java.util.*;
import javax.ejb.*;
import javax.naming.*;
import com.parsec.utils.*;
 
public class ParsecConfigEJB implements EntityBean
{

	private String propName;
        private String propValue;

	private EntityContext context;
	private Connection con;


	public String getPropName()
	{
		return propName;
	}
       
        public String getPropValue()
	{
		return propValue;
	}
    
//Set methods

        public void setPropName (String a)
        {
	     propName=a;
	}

        public void setPropValue(String a)
	{
		propValue = a;
	}
//End of set methods


    public String ejbCreate(String propName,
			    String propValue
			    )
	throws CreateException
	{

		try
		{
		    insertRow(propName,propValue);
		} catch (Exception ex)
		{
			throw new EJBException("ejbCreate: " + 
				ex.getMessage());
		}

		this.propName = propName;
		this.propValue = propValue;

		return propName;
	}

	public String ejbFindByPrimaryKey(String primaryKey) 
	throws FinderException
	{

		boolean result;

		try
		{
		        result = selectByPrimaryKey(primaryKey);
		} catch (Exception ex)
		{
			throw new EJBException("ejbFindByPrimaryKey: " + 
				ex.getMessage());
		}
		if (result)
		{
			return primaryKey;
		}
		else
		{
			throw new ObjectNotFoundException
				("Row for id " + primaryKey + " not found.");
		}
	}


	public void ejbRemove()
	{

		try
		{
			deleteRow(propName);
		} catch (Exception ex)
		{
			throw new EJBException("ejbRemove: " + 
				ex.getMessage());
		}
	} 

	public void setEntityContext(EntityContext context)
	{

		this.context = context;
//        try {
//                makeConnection();
//        } catch (Exception ex) {
//                throw new EJBException("Unable to connect to database. " +
//                      ex.getMessage());
//	}
   	}

	public void unsetEntityContext()
	{

//		try
//		{
//			con.close();
//		} catch (SQLException ex)
//		{
//			throw new EJBException("unsetEntityContext: " + ex.getMessage());
//		}
	}

	public void ejbActivate()
	{

		propName = (String)context.getPrimaryKey();
	}

	public void ejbPassivate()
	{

		propName = null;
	}

	public void ejbLoad()
	{

		try
		{
			loadRow();
		} catch (Exception ex)
		{
			throw new EJBException("ejbLoad: " + 
				ex.getMessage());
		}
	}

	public void ejbStore()
	{

		try
		{
			storeRow();
		} catch (Exception ex)
		{
			throw new EJBException("ejbStore: " + 
				ex.getMessage());
		}
	}


    public void ejbPostCreate(String propName,
			      String propValue
			      )
    { 
    }


	/*********************** Database Routines *************************/

	private void makeConnection() throws NamingException, SQLException
	{

		DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());
		con = DriverManager.getConnection("jdbc:oracle:thin:@everest:1521:GEN","sarvjeet","sarv");
	}

	private void insertRow (String propName,
				String propValue
				) 
	throws SQLException
	{

		con=ParsecUtils.getDBConnection();
		String insertStatement =
			"insert into parsec_config values (?,?)";
		PreparedStatement prepStmt = 
			con.prepareStatement(insertStatement);

		prepStmt.setString(1, propName);
		prepStmt.setString(2, propValue);

		prepStmt.executeUpdate();
		prepStmt.close();con.close();
	}

	private void deleteRow(String id) throws SQLException
	{
		con=ParsecUtils.getDBConnection();
		String deleteStatement =
			"delete from parsec_config where prop_name = ? ";
		PreparedStatement prepStmt =
			con.prepareStatement(deleteStatement);

		prepStmt.setString(1, id);
		prepStmt.executeUpdate();
		prepStmt.close();con.close();
	}

	private boolean selectByPrimaryKey(String primaryKey) 
	throws SQLException
	{
		con=ParsecUtils.getDBConnection();
		String selectStatement =
			"select prop_name " +
			"from parsec_config where prop_name = ? ";
		PreparedStatement prepStmt =
			con.prepareStatement(selectStatement);
		prepStmt.setString(1, primaryKey);

		ResultSet rs = prepStmt.executeQuery();
		boolean result = rs.next();
		prepStmt.close();con.close();
		return result;
	}

	private void loadRow() throws SQLException
	{
		con=ParsecUtils.getDBConnection();
		String selectStatement =
			"select prop_value " +
			"from parsec_config where prop_name = ? ";
		PreparedStatement prepStmt = 
			con.prepareStatement(selectStatement);

		prepStmt.setString(1, this.propName);

		ResultSet rs = prepStmt.executeQuery();

		if (rs.next())
		{

			this.propValue = rs.getString(1);
			
			prepStmt.close();con.close();
		}
		else
		{
			prepStmt.close();con.close();
			throw new NoSuchEntityException("Row for id " + propName +
				" not found in database.");
		}
	}


	private void storeRow() throws SQLException
	{
		con=ParsecUtils.getDBConnection();
		String updateStatement =
			"update parsec_config set " +
			"prop_value = ? " +
			"where prop_name = ? ";
		PreparedStatement prepStmt = 
			con.prepareStatement(updateStatement);

		prepStmt.setString(1, propValue);
		prepStmt.setString(2, propName);

		int rowCount = prepStmt.executeUpdate();
		prepStmt.close();con.close();

		if (rowCount == 0)
		{
			throw new EJBException("Storing row for id " + propName + " failed.");
		}
	}

} // ParsecConfigEJB 
