/*
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */
package com.parsec.ejbs.customer;

import java.sql.*;
import javax.sql.*;
import java.util.*;
import javax.ejb.*;
import javax.naming.*;
 
public class CustomerEJB implements EntityBean
{

	private String userId;
	private String passwd;
	private String name;
	private String description;
	private String bankName;
	private String bankAcc;
	private double marginMoney;
	private String street;
	private String city;
	private String state;
	private String pinCode;
	private String email;
	private String telephone;

	private EntityContext context;
	private Connection con;


	public String getLogin()
	{
		return userId;
	}

	public String getPasswd()  
	{
		return passwd;
	}
	public String getName()
	{
		return name;
	}
	public String getDescription()
	{
		return description;
	}
	public String getBankName()
	{
		return bankName;
	}
	public String getBankAcc()
	{
		return bankAcc;
	}
	public double getMarginMoney()
	{
		return marginMoney;
	}
	public String getStreet()
	{
		return street;
	}
	public String getCity()
	{
		return city;
	}
	public String getState()
	{
		return state;
	}
	public String getPinCode()
	{
		return pinCode;
	}
	public String getEmail()
	{
		return email;
	}
	public String getTelephone()
	{
		return telephone;
	}

//Set methods

	public void setLogin(String userid)
	{
		userId = userid;
	}

	public void setPasswd(String passwd)  
	{
		this.passwd = passwd;
	}
	public void setName(String name)
	{
		this.name = name;
	}
	public void setDescription(String desc)
	{
		description = desc;
	}
	public void setBankName(String bn)
	{
		bankName = bn;
	}
	public void setBankAcc(String ba)
	{
		bankAcc = ba;
	}
	public void setMarginMoney(double mm)
	{
		marginMoney = mm;
	}
	public void setStreet(String st)
	{
		street = st;
	}
	public void setCity(String c)
	{
		city = c;
	}
	public void setState(String s)
	{
		state = s;
	}
	public void setPinCode(String p)
	{
		pinCode = p;
	}
	public void setEmail(String e)
	{
		email = e;
	}
	public void setTelephone(String t)
	{
		telephone = t;
	}

//End of set methods


	public String ejbCreate(String userId, 
		String name,
		String description,
		String passwd, 
		String bankName,
		String bankAcc,
		double marginMoney,
		String street,
		String city,
		String state,
		String pinCode,
		String email,
		String telephone
		)
	throws CreateException
	{

		try
		{
			insertRow(userId,name,description,passwd,bankName,bankAcc,marginMoney,
				street,city,state,pinCode,email,telephone);
		} catch (Exception ex)
		{
			throw new EJBException("ejbCreate: " + 
				ex.getMessage());
		}

		this.userId = userId;
		this.name = name;
		this.description = description;
		this.passwd = passwd;
		this.bankName = bankName;
		this.bankAcc = bankAcc;
		this.marginMoney = marginMoney;
		this.street = street;
		this.city = city;
		this.state = state;
		this.pinCode = pinCode;
		this.email = email;
		this.telephone = telephone;

		return userId;
	}

	public String ejbFindByPrimaryKey(String primaryKey) 
	throws FinderException
	{

		boolean result;

		try
		{
			//this.userId = primaryKey;
			//loadRow();
			result = selectByPrimaryKey(primaryKey);
		} catch (Exception ex)
		{
			throw new EJBException("ejbFindByPrimaryKey: " + 
				ex.getMessage());
		}
		if (result)
		{
			return primaryKey;
		}
		else
		{
			throw new ObjectNotFoundException
				("Row for id " + primaryKey + " not found.");
		}
	}

	public void ejbRemove()
	{

		try
		{
			deleteRow(userId);
		} catch (Exception ex)
		{
			throw new EJBException("ejbRemove: " + 
				ex.getMessage());
		}
	} 

	public void setEntityContext(EntityContext context)
	{

		this.context = context;
      try {
         makeConnection();
			} catch (Exception ex) {
          throw new EJBException("Unable to connect to database. " +
             ex.getMessage());
			}
   	}

	public void unsetEntityContext()
	{

		try
		{
			con.close();
		} catch (SQLException ex)
		{
			throw new EJBException("unsetEntityContext: " + ex.getMessage());
		}
	}

	public void ejbActivate()
	{

		userId = (String)context.getPrimaryKey();
	}

	public void ejbPassivate()
	{

		userId = null;
	}

	public void ejbLoad()
	{

		try
		{
			loadRow();
		} catch (Exception ex)
		{
			throw new EJBException("ejbLoad: " + 
				ex.getMessage());
		}
	}

	public void ejbStore()
	{

		try
		{
			storeRow();
		} catch (Exception ex)
		{
			throw new EJBException("ejbStore: " + 
				ex.getMessage());
		}
	}


	public void ejbPostCreate(String userId, 
		String name,
		String description,
		String passwd, 
		String bankName,
		String bankAcc,
		double marginMoney,
		String street,
		String city,
		String state,
		String pinCode,
		String email,
		String telephone
		)
	{ 
	}


	/*********************** Database Routines *************************/

	private void makeConnection() throws NamingException, SQLException
	{

		DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());
		con = DriverManager.getConnection("jdbc:oracle:thin:@everest:1521:GEN","sarvjeet","sarv");
	}

	private void insertRow (String userId, 
		String name,
		String description,
		String passwd, 
		String bankName,
		String bankAcc,
		double marginMoney,
		String street,
		String city,
		String state,
		String pinCode,
		String email,
		String telephone
		) 
	throws SQLException
	{

		String insertStatement =
			"insert into customer values (?,?,?,?,?,?,?,?,?,?,?,?,?)";
		PreparedStatement prepStmt = 
			con.prepareStatement(insertStatement);

		prepStmt.setString(1, userId);
		prepStmt.setString(2, name);
		prepStmt.setString(3, description);
		prepStmt.setString(4, passwd);
		prepStmt.setString(5, bankName);
		prepStmt.setString(6, bankAcc);
		prepStmt.setDouble(7, marginMoney);
		prepStmt.setString(8, street);
		prepStmt.setString(9, city);
		prepStmt.setString(10, state);
		prepStmt.setString(11, pinCode);
		prepStmt.setString(12, email);
		prepStmt.setString(13, telephone);
		prepStmt.executeUpdate();
		prepStmt.close();
	}

	private void deleteRow(String id) throws SQLException
	{

		String deleteStatement =
			"delete from customer where login = ? ";
		PreparedStatement prepStmt =
			con.prepareStatement(deleteStatement);

		prepStmt.setString(1, id);
		prepStmt.executeUpdate();
		prepStmt.close();
	}

	private boolean selectByPrimaryKey(String primaryKey) 
	throws SQLException
	{

		String selectStatement =
			"select login " +
			"from customer where login = ? ";
		PreparedStatement prepStmt =
			con.prepareStatement(selectStatement);
		prepStmt.setString(1, primaryKey);

		ResultSet rs = prepStmt.executeQuery();
		boolean result = rs.next();
		prepStmt.close();
		return result;
	}



	private void loadRow() throws SQLException
	{
		String selectStatement =
			"select name,description,password,bank_name,bank_acc_no,margin_money," +
			"street,city,state,pincode,email,telephone " +
			"from customer where login = ? ";
		PreparedStatement prepStmt = 
			con.prepareStatement(selectStatement);

		prepStmt.setString(1, this.userId);

		ResultSet rs = prepStmt.executeQuery();

		if (rs.next())
		{

			this.name = rs.getString(1);
			this.description = rs.getString(2);
			this.passwd = rs.getString(3);
			this.bankName = rs.getString(4);
			this.bankAcc = rs.getString(5);
			this.marginMoney = rs.getDouble(6);
			this.street = rs.getString(7);
			this.city = rs.getString(8);
			this.state = rs.getString(9);
			this.pinCode = rs.getString(10);
			this.email = rs.getString(11);
			this.telephone =rs.getString(12);
			prepStmt.close();
		}
		else
		{
			prepStmt.close();
			throw new NoSuchEntityException("Row for id " + userId +
				" not found in database.");
		}
	}


	private void storeRow() throws SQLException
	{

		String updateStatement =
			"update customer set name =  ? , " +
			"description = ? , password = ? , " +
			"bank_name = ? , bank_acc_no = ? , " +
			"margin_money = ? , street = ? , " +
			"city = ? , state = ? , " +
			"pincode = ? , email = ? , " +
			"telephone = ? " +
			"where login = ? ";
		PreparedStatement prepStmt = 
			con.prepareStatement(updateStatement);

		prepStmt.setString(1, name);
		prepStmt.setString(2, description);
		prepStmt.setString(3, passwd);
		prepStmt.setString(4, bankName);
		prepStmt.setString(5, bankAcc);
		prepStmt.setDouble(6, marginMoney);
		prepStmt.setString(7, street);
		prepStmt.setString(8, city);
		prepStmt.setString(9, state);
		prepStmt.setString(10, pinCode);
		prepStmt.setString(11, email);
		prepStmt.setString(12, telephone);
		prepStmt.setString(13, userId);

		int rowCount = prepStmt.executeUpdate();
		prepStmt.close();

		if (rowCount == 0)
		{
			throw new EJBException("Storing row for id " + userId + " failed.");
		}
	}

} // CustomerEJB 
