/*
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */
package com.parsec.ejbs.deal;

import java.sql.*;
import javax.sql.*;
import java.util.*;
import javax.ejb.*;
import javax.naming.*;
import com.parsec.utils.*;
 
public class PendingDealEJB implements EntityBean
{

	private String buyerId;
    private String sellerId;
	private String shareId;
	private java.util.Date dealTime;
	private int noOfShares;
    private float price;

	private EntityContext context;
	private Connection con;


	public String getBuyerId()
	{
		return buyerId;
	}

        public String getSellerId()
	{
		return sellerId;
	}

	public String getShareId()  
	{
		return shareId;
	}
	public java.util.Date getDealTime()
	{
		return dealTime;
	}
    
        public int getNoOfShares()
        {
	    return noOfShares;
	}

        public float getPrice()
        {
	    return price;
	}

//Set methods

	public void setBuyerId(String a)
	{
		buyerId = a;
	}

        public void setSellerId(String a)
	{
		sellerId = a;
	}

	public void setShareId(String a)  
	{
		shareId = a;
	}
	
        public void setDealTime(java.util.Date a)
	{
		dealTime = a;
	}

        public void setNoOfShares(int a)
	{
		noOfShares = a;
	}

	public void setPrice(float a)  
	{
		price = a;
	}



//End of set methods


	public DealPrimaryKey ejbCreate(String buyerId,
					String sellerId,
					String shareId,
					java.util.Date dealTime,
					int noOfShares,
					float price
					)
	throws CreateException
	{
	    if (buyerId == null || sellerId == null || shareId == null || dealTime == null) {
		throw new CreateException("All primary keys are required.");
	    }
		try
		{
			insertRow(buyerId,sellerId,shareId,dealTime,noOfShares,price);
		} catch (Exception ex)
		{
			throw new EJBException("ejbCreate: " + 
				ex.getMessage());
		}

		this.buyerId = buyerId;
		this.sellerId=sellerId;
		this.shareId = shareId;
		this.dealTime = dealTime;
		this.noOfShares = noOfShares;
		this.price = price;

		return new DealPrimaryKey(buyerId,sellerId,shareId,dealTime);
	}

	public DealPrimaryKey ejbFindByPrimaryKey(DealPrimaryKey primaryKey) 
	throws FinderException
	{

		boolean result;

		try
		{
			result = selectByPrimaryKey(primaryKey);
		} catch (Exception ex)
		{
			throw new EJBException("ejbFindByPrimaryKey: " + 
				ex.getMessage());
		}
		if (result)
		{
			return primaryKey;
		}
		else
		{
			throw new ObjectNotFoundException
				("Row for id " + primaryKey + " not found.");
		}
	}

	public Collection ejbFindByBuyerId(String buyerId)
	    throws FinderException {

	    Collection result;
	    
	    try {
		result = selectByBuyerId(buyerId);
	    } catch (Exception ex) {
		throw new EJBException("ejbFindByLastName " + 
				       ex.getMessage());
	    }
	    
	    if (result.isEmpty()) {
		throw new ObjectNotFoundException("No rows found.");
	    }
	    else {
		return result;
	    }
	}
	
	public Collection ejbFindBySellerId(String sellerId)
	    throws FinderException {

	    Collection result;
	    
	    try {
		result = selectBySellerId(sellerId);
	    } catch (Exception ex) {
		throw new EJBException("ejbFindByLastName " + 
				       ex.getMessage());
	    }
	    
	    if (result.isEmpty()) {
		throw new ObjectNotFoundException("No rows found.");
	    }
	    else {
		return result;
	    }
	}

    
        public Collection ejbFindByDateOnly(java.util.Date dealTime)
	    throws FinderException {

	    Collection result;
	    
	    try {
		result = selectByDateOnly(dealTime);
	    } catch (Exception ex) {
		throw new EJBException("ejbFindByDateOnly " + 
				       ex.getMessage());
	    }
	    
	    if (result.isEmpty()) {
		throw new ObjectNotFoundException("No rows found.");
	    }
	    else {
		return result;
	    }
	}


	public void ejbRemove()
	{

		try
		{
			deleteRow(buyerId,sellerId,shareId,dealTime);
		} catch (Exception ex)
		{
			throw new EJBException("ejbRemove: " + 
				ex.getMessage());
		}
	} 

	public void setEntityContext(EntityContext context)
	{

		this.context = context;
//      try {
//         makeConnection();
//			} catch (Exception ex) {
//          throw new EJBException("Unable to connect to database. " +
//             ex.getMessage());
//			}
   	}

	public void unsetEntityContext()
	{

//		try
//		{
//			con.close();
//		} catch (SQLException ex)
//		{
//			throw new EJBException("unsetEntityContext: " + ex.getMessage());
//		}
	}

	public void ejbActivate()
	{
	    DealPrimaryKey temp= (DealPrimaryKey) context.getPrimaryKey();
	    buyerId = temp.getBuyerId();
	    sellerId= temp.getSellerId();
	    shareId = temp.getShareId();
		dealTime = temp.getDealTime();
	}

	public void ejbPassivate()
	{

	    buyerId = null;
	    sellerId = null;
	    shareId = null;
		dealTime= null;
	}

	public void ejbLoad()
	{

		try
		{
			loadRow();
		} catch (Exception ex)
		{
			throw new EJBException("ejbLoad: " + 
				ex.getMessage());
		}
	}

	public void ejbStore()
	{

		try
		{
			storeRow();
		} catch (Exception ex)
		{
			throw new EJBException("ejbStore: " + 
				ex.getMessage());
		}
	}


	public void ejbPostCreate(String buyerId,
				  String sellerId,
				  String shareId,
				  java.util.Date dealTime,
				  int noOfShares,
				  float price
				  )
	{ 
	}


	/*********************** Database Routines *************************/

	private void makeConnection() throws NamingException, SQLException
	{

		DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());
		con = DriverManager.getConnection("jdbc:oracle:thin:@everest:1521:GEN","sarvjeet","sarv");
	}

	private void insertRow (String buyerId,
				String sellerId,
				String shareId,
				java.util.Date dealTime,
				int noOfShares,
				float price
				)
	throws SQLException
	{
		con=ParsecUtils.getDBConnection();
		String insertStatement =
			"insert into pending_deal values (?,?,?,?,?,?)";
		PreparedStatement prepStmt = 
			con.prepareStatement(insertStatement);

		prepStmt.setString(1, buyerId);
		prepStmt.setString(2, sellerId);
		prepStmt.setString(3, shareId);
		prepStmt.setTimestamp(4, new java.sql.Timestamp(dealTime.getTime()));
		prepStmt.setInt(5, noOfShares);
		prepStmt.setFloat(6, price);

		prepStmt.executeUpdate();
		prepStmt.close();con.close();
	}

	private void deleteRow(String a,String b,String c,java.util.Date dealTime) throws SQLException
	{

		con=ParsecUtils.getDBConnection();
		String deleteStatement =
			"delete from pending_deal where (buyer_id = ?) and (seller_id = ?)" +
		    " and (share_id = ?) and (deal_time = ?)";
		PreparedStatement prepStmt =
			con.prepareStatement(deleteStatement);

		prepStmt.setString(1, a);
		prepStmt.setString(2, b);
		prepStmt.setString(3, c);
		prepStmt.setTimestamp(4, new java.sql.Timestamp(dealTime.getTime()));
		prepStmt.executeUpdate();
		prepStmt.close();con.close();
	}

	private boolean selectByPrimaryKey(DealPrimaryKey primaryKey) 
	throws SQLException
	{

		con=ParsecUtils.getDBConnection();
		String selectStatement =
			"select buyer_id " +
			"from pending_deal where (buyer_id = ?) and (seller_id = ?) and (share_id = ?) and (deal_time = ?)";
		PreparedStatement prepStmt =
			con.prepareStatement(selectStatement);
		prepStmt.setString(1, primaryKey.getBuyerId());
		prepStmt.setString(2, primaryKey.getSellerId());
		prepStmt.setString(3, primaryKey.getShareId());
		prepStmt.setTimestamp(4, new java.sql.Timestamp(dealTime.getTime()));

		ResultSet rs = prepStmt.executeQuery();
		boolean result = rs.next();
		prepStmt.close();con.close();
		return result;
	}

	private Collection selectByBuyerId(String buyerId) 
	    throws SQLException {
	    
		con=ParsecUtils.getDBConnection();
	    String selectStatement =
		"select seller_id, share_id, deal_time " +
		"from pending_deal where buyer_id = ? ";
	    PreparedStatement prepStmt = 
		con.prepareStatement(selectStatement);
	    
	    prepStmt.setString(1, buyerId);
	    ResultSet rs = prepStmt.executeQuery();
	    Vector a = new Vector();
	    
	    while (rs.next()) {
			DealPrimaryKey key = new DealPrimaryKey(buyerId,rs.getString(1),rs.getString(2),new java.util.Date(rs.getTimestamp(3).getTime()));
			a.add(key);
	    }
	    
	    prepStmt.close();con.close();
	    return a;
	}
	
	private Collection selectBySellerId(String sellerId) 
	    throws SQLException {
	    
		con=ParsecUtils.getDBConnection();
	    String selectStatement =
		"select buyer_id, share_id, deal_time " +
		"from pending_deal where seller_id = ? ";
	    PreparedStatement prepStmt = 
		con.prepareStatement(selectStatement);
	    
	    prepStmt.setString(1, sellerId);
	    ResultSet rs = prepStmt.executeQuery();
	    Vector a = new Vector();
	    
	    while (rs.next()) {
			DealPrimaryKey key =new DealPrimaryKey(rs.getString(1),sellerId,rs.getString(2),new java.util.Date(rs.getTimestamp(3).getTime()));
			a.add(key);
	    }
	    
	    prepStmt.close();con.close();
	    return a;
	}

        private Collection selectByDateOnly(java.util.Date d) 
	    throws SQLException {
	
		con=ParsecUtils.getDBConnection();
	    String selectStatement =
		"select buyer_id, seller_id, share_id, deal_time " +
		"from pending_deal";
	    PreparedStatement prepStmt = 
		con.prepareStatement(selectStatement);
	    
	    ResultSet rs = prepStmt.executeQuery();
	    Vector a = new Vector();
	    
	    while (rs.next()) {
		java.sql.Date temp=new java.sql.Date(d.getTime());

		if (temp.equals(rs.getDate(4))) {
		    DealPrimaryKey key =new DealPrimaryKey(rs.getString(1),rs.getString(2),rs.getString(3),d);
		    a.add(key);
		}
	    }
	    
	    prepStmt.close();con.close();
	    return a;
	}

	private void loadRow() throws SQLException
	{
	
		con=ParsecUtils.getDBConnection();
		String selectStatement =
			"select no_of_shares, price " +
			"from pending_deal where (buyer_id = ?) and (seller_id = ?) and (share_id = ?) and (deal_time = ?)";
		PreparedStatement prepStmt = 
			con.prepareStatement(selectStatement);

		prepStmt.setString(1, this.buyerId);
		prepStmt.setString(2, this.sellerId);
		prepStmt.setString(3, this.shareId);
		prepStmt.setTimestamp(4, new java.sql.Timestamp(dealTime.getTime()));

		ResultSet rs = prepStmt.executeQuery();

		if (rs.next())
		{
		        this.noOfShares = rs.getInt(1);
		        this.price = rs.getFloat(2);
		        prepStmt.close();con.close();
		}
		else
		{
			prepStmt.close();con.close();
			throw new NoSuchEntityException("Row for Primary Key not found in table pending_deal");
		}
	}


	private void storeRow() throws SQLException
	{

		con=ParsecUtils.getDBConnection();
		String updateStatement =
			"update pending_deal set " +
			"no_of_shares = ? , " +
		        "price = ? " +
			"where (buyer_id = ?) and (seller_id = ?) and (share_id = ?) and (deal_time = ?)";
		PreparedStatement prepStmt = 
			con.prepareStatement(updateStatement);

		prepStmt.setInt(1, noOfShares);
		prepStmt.setFloat(2, price);
		prepStmt.setString(3, buyerId);
		prepStmt.setString(4, sellerId);
		prepStmt.setString(5, shareId);
		prepStmt.setTimestamp(6, new java.sql.Timestamp(dealTime.getTime()));
		

		int rowCount = prepStmt.executeUpdate();
		prepStmt.close();con.close();

		if (rowCount == 0)
		{
			throw new EJBException("Storing row for primary key failed.in table pending_deal");
		}
	}

} // PendingDealEJB
