/*
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */
package com.parsec.ejbs.login;

import javax.ejb.*;
import javax.naming.*;
import java.rmi.*;
import javax.rmi.*;
import java.util.*;
import java.io.*;

import com.parsec.ejbs.customer.*;
import com.parsec.ejbs.authenticator.*;
import com.parsec.utils.*;

public class LoginEJB implements SessionBean
{

	CustomerHome home;
	AuthenticatorHome ahome;

	public void ejbCreate()
	{
		try
		{
			Context initial = new InitialContext();
			Object objref = initial.lookup("CustomerBean");

				home = (CustomerHome)PortableRemoteObject.narrow(objref, CustomerHome.class);

				objref = initial.lookup("AuthenticatorBean");

				ahome = (AuthenticatorHome)PortableRemoteObject.narrow(objref, AuthenticatorHome.class);

		} catch (NamingException ne)
		{
			ne.printStackTrace();
		}

	}

	public boolean checkCustomerLogin(String userid, String passwd)
	{
		try
		{
			Customer potential = home.findByPrimaryKey(userid);

			if ((potential.getPasswd()).equals(passwd))
			{
				return true;
			}


		} catch (RemoteException re)
		{
			System.err.println("RemoteException : "+re);

		} catch (FinderException fe)
		{
			System.err.println("User not found - "+fe);

		}
		return false; 
	}

	public boolean checkAuthenticatorLogin(String userid, String passwd)
	{

		try
		{
			Authenticator potential = ahome.findByPrimaryKey(userid);

			if ((potential.getPassword()).equals(passwd))
			{

				return true;
			}


		} catch (RemoteException re)
		{
			System.err.println("RemoteException : "+re);

		} catch (FinderException fe)
		{
			System.err.println("Auth not found - "+fe);

		}

		return false; 
	}

	public boolean checkAdministratorLogin(String userid, String passwd)
	{


		String adpass = ParsecUtils.getAdminPassword();

		if ((userid.equals("root")) && (adpass.equals(passwd)))
		{
			return true;
		}


		return false; 
	}


	public LoginEJB()
	{
	}
	public void setSessionContext(SessionContext sc)
	{
	}
	public void ejbRemove()
	{
	}
	public void ejbActivate()
	{
	}
	public void ejbPassivate()
	{
	}

} // LoginEJB
