package com.parsec.ejbs.portfolio;

import javax.ejb.*;
import javax.naming.*;
import java.rmi.*;
import javax.rmi.*;
import java.util.*;
import com.parsec.ejbs.share.*;
import com.parsec.ejbs.deal.*;

public class PortfolioDescriptorEJB implements SessionBean
{

    PortfolioHome home;
	CurrentShareStateHome shome;
	DealHome dhome;

    public void ejbCreate() 
	{
		try {
	    	Context initial = new InitialContext();
		
		    Object objref = initial.lookup("PortfolioBean");
	        home = (PortfolioHome)PortableRemoteObject.narrow(objref, PortfolioHome.class);
			
			objref = initial.lookup("CurrentShareStateBean");
		    shome = (CurrentShareStateHome)PortableRemoteObject.narrow(objref, CurrentShareStateHome.class);
			
			objref = initial.lookup("DealBean");
		    dhome = (DealHome)PortableRemoteObject.narrow(objref, DealHome.class);
		} catch (NamingException ne) {
	    ne.printStackTrace();
		}
    }

	public PortfolioDescriptorEJB() {}
    public void setSessionContext(SessionContext sc) {}
    public void ejbRemove() {}
    public void ejbActivate() {}
    public void ejbPassivate() {}
	
	//Business methods - holdings, buys & sales
	
	public Collection holdings(String userid) 
	{
		try 
		{
			System.out.println("in holdings1");
	    	Vector pot = new Vector(home.findByCustomerId(userid));
			System.out.println("in holdings2");
			Vector ret = new Vector();
			Portfolio p;
			PortfolioData pfd;
	    	System.out.println("in holdings3");
		
			for (int i=0; i<pot.size(); i++)
				{
				pfd = new PortfolioData();
		
				p = (Portfolio) pot.elementAt(i);
				System.out.println("mummy daddy");
				pfd.shareId = p.getShareId();
				System.out.println("mummy daddy1");
				pfd.holding = p.getHolding();
				System.out.println("mummy daddy2"+pfd.holding);
				pfd.avgBuyingPrice = p.getAvgBuyingPrice();
				pfd.totalValue = pfd.holding * pfd.avgBuyingPrice;
				
				CurrentShareState css = shome.findByPrimaryKey(pfd.shareId);
				
				pfd.marketValue = pfd.holding * css.getCurrentPrice();
				pfd.gain = pfd.marketValue - pfd.totalValue;
				pfd.gainPercent = (pfd.gain / pfd.totalValue) * 100; 
				System.out.println("I am here2"+pfd.gainPercent);
				
				ret.add(pfd);
				}
			System.out.println("I am here3"+ret);
			return ret;	
		} 
		catch (RemoteException re) {
	    	re.printStackTrace();
			return new Vector();
		} 
		catch (FinderException fe) {
	    	System.err.println("Row not found - "+fe);
			return new Vector();
		}
	}
	
	public Collection buys(String userid)
	{
		try
		{
			Vector v = new Vector(dhome.findByBuyerId(userid));
			return v;
			
		}
		catch (RemoteException re)
		{
			System.err.println("RemoteException : "+re);
			return new Vector();
		}
		catch (FinderException fe) 
		{
	    	System.err.println("Row not found - "+fe);
			return new Vector();
		}
	}
	
	public Collection sales(String userid)
	{
		try
		{
			Vector v = new Vector(dhome.findBySellerId(userid));
			return v;
			
		}
		catch (RemoteException re)
		{
			System.err.println("RemoteException : "+re);
			return new Vector();
		}
		catch (FinderException fe) 
		{
	    	System.err.println("Row not found - "+fe);
			return new Vector();
		}
	}
} // PortfolioDescriptorEJB