/*
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */
package com.parsec.ejbs.portfolio;

import java.sql.*;
import javax.sql.*;
import java.util.*;
import javax.ejb.*;
import javax.naming.*;
import com.parsec.utils.*;
 
public class PortfolioEJB implements EntityBean
{

	private String customerId;
	private String shareId;
	private int holding;
	private float avgBuyingPrice;

	private EntityContext context;
	private Connection con;


	public String getCustomerId()
	{
		return customerId;
	}

	public String getShareId()  
	{
		return shareId;
	}
	public int getHolding()
	{
		return holding;
	}
    
        public float getAvgBuyingPrice()
        {
	    return avgBuyingPrice;
	}
//Set methods

	public void setCustomerId(String a)
	{
		customerId = a;
	}

	public void setShareId(String a)  
	{
		shareId = a;
	}
	public void setHolding(int a)
	{
		holding = a;
	}
	public void setAvgBuyingPrice(float a)
	{
		avgBuyingPrice = a;
	}
//End of set methods


	public ItemKey ejbCreate(String customerId, 
				 String shareId,
				 int holding,
				 float avgBuyingPrice
				 )
	throws CreateException
	{
	    if (customerId == null || shareId == null) {
		throw new CreateException("customerId and shareId are required.");
	    }
		try
		{
			insertRow(customerId,shareId,holding,avgBuyingPrice);
		} catch (Exception ex)
		{
			throw new EJBException("ejbCreate: " + 
				ex.getMessage());
		}

		this.customerId = customerId;
		this.shareId = shareId;
		this.holding = holding;
		this.avgBuyingPrice = avgBuyingPrice;

		return new ItemKey(customerId,shareId);
	}

	public ItemKey ejbFindByPrimaryKey(ItemKey primaryKey) throws FinderException
	{

		boolean result;

		try
		{
			result = selectByPrimaryKey(primaryKey);
		} catch (Exception ex)
		{
			throw new EJBException("ejbFindByPrimaryKey: " + 
				ex.getMessage());
		}
		if (result)
		{
			return primaryKey;
		}
		else
		{
			throw new ObjectNotFoundException
				("Row for id " + primaryKey + " not found.");
		}
	}

    public Collection ejbFindByCustomerId(String customerId)
	    throws FinderException {

	    Collection result;
	    
	    try {
			System.out.println("find1");
		result = selectByCustomerId(customerId);
		System.out.println("find2");
	    } catch (Exception ex) {
		throw new EJBException("ejbFindByLastName " + 
				       ex.getMessage());
	    }
	    
	    if (result.isEmpty()) {
		throw new ObjectNotFoundException("No rows found.");
	    }
	    else {
		return result;
	    }
	}

	public void ejbRemove()
	{

		try
		{
			deleteRow(customerId,shareId);
		} catch (Exception ex)
		{
			throw new EJBException("ejbRemove: " + 
				ex.getMessage());
		}
	} 

	public void setEntityContext(EntityContext context)
	{

		this.context = context;
//      try {
//         makeConnection();
//			} catch (Exception ex) {
//          throw new EJBException("Unable to connect to database. " +
//             ex.getMessage());
//			}
   	}

	public void unsetEntityContext()
	{

//		try
//		{
//			con.close();
//		} catch (SQLException ex)
//		{
//			throw new EJBException("unsetEntityContext: " + ex.getMessage());
//		}
	}

	public void ejbActivate()
	{
	    ItemKey temp= (ItemKey) context.getPrimaryKey();
	    customerId = temp.getCustomerId();
	    shareId = temp.getShareId();
	}

	public void ejbPassivate()
	{

	    customerId = null;
	    shareId = null;
	}

	public void ejbLoad()
	{

		try
		{
			loadRow();
		} catch (Exception ex)
		{
			throw new EJBException("ejbLoad: " + 
				ex.getMessage());
		}
	}

	public void ejbStore()
	{

		try
		{
			storeRow();
		} catch (Exception ex)
		{
			throw new EJBException("ejbStore: " + 
				ex.getMessage());
		}
	}


	public void ejbPostCreate(String customerId, 
				 String shareId,
				 int holding,
				 float avgBuyingPrice
				  )
	{ 
	}


	/*********************** Database Routines *************************/

	private void makeConnection() throws NamingException, SQLException
	{

		DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());
		con = DriverManager.getConnection("jdbc:oracle:thin:@everest:1521:GEN","sarvjeet","sarv");
	}

	private void insertRow (String customerId, 
				String shareId,
				int holding,
				float avgBuyingPrice
				)
	throws SQLException
	{

		con=ParsecUtils.getDBConnection();
		String insertStatement =
			"insert into portfolio values (?,?,?,?)";
		PreparedStatement prepStmt = 
			con.prepareStatement(insertStatement);

		prepStmt.setString(1, customerId);
		prepStmt.setString(2, shareId);
		prepStmt.setInt(3, holding);
		prepStmt.setFloat(4, avgBuyingPrice);

		prepStmt.executeUpdate();
		prepStmt.close();con.close();
	}

	private void deleteRow(String a,String b) throws SQLException
	{

		con=ParsecUtils.getDBConnection();
		String deleteStatement =
			"delete from portfolio where (customer_id = ?) and (share_id = ?)";
		PreparedStatement prepStmt =
			con.prepareStatement(deleteStatement);

		prepStmt.setString(1, a);
		prepStmt.setString(2, b);
		prepStmt.executeUpdate();
		prepStmt.close();con.close();
	}

	private boolean selectByPrimaryKey(ItemKey primaryKey) 
	throws SQLException
	{
		con=ParsecUtils.getDBConnection();
		String selectStatement =
			"select customer_id " +
			"from portfolio where (customer_id = ?) and (share_id = ?) ";
		PreparedStatement prepStmt =
			con.prepareStatement(selectStatement);
		prepStmt.setString(1, primaryKey.getCustomerId());
		prepStmt.setString(2, primaryKey.getShareId());

		ResultSet rs = prepStmt.executeQuery();
		boolean result = rs.next();
		prepStmt.close();con.close();
		return result;
	}

    private Collection selectByCustomerId(String customerId) 
	    throws SQLException {
	    
		con=ParsecUtils.getDBConnection();
	    String selectStatement =
		"select share_id " +
		"from portfolio where customer_id = ? ";
	    PreparedStatement prepStmt = 
		con.prepareStatement(selectStatement);
	    
	    prepStmt.setString(1, customerId);
	    ResultSet rs = prepStmt.executeQuery();
	    Vector a = new Vector();
	    
	    while (rs.next()) {
		ItemKey key = new ItemKey(customerId,rs.getString(1));
		a.add(key);
	    }
	    
	    prepStmt.close();con.close();
	    return a;
	}

	private void loadRow() throws SQLException
	{
		con=ParsecUtils.getDBConnection();
		String selectStatement =
			"select holding, avg_buying_price " +
			"from portfolio where (customer_id = ?) and (share_id = ?) ";
		PreparedStatement prepStmt = 
			con.prepareStatement(selectStatement);

		prepStmt.setString(1, this.customerId);
		prepStmt.setString(2, this.shareId);

		ResultSet rs = prepStmt.executeQuery();

		if (rs.next())
		{

			this.holding = rs.getInt(1);
			this.avgBuyingPrice = rs.getFloat(2);
			prepStmt.close();con.close();
		}
		else
		{
			prepStmt.close();con.close();
			throw new NoSuchEntityException("Row for primary key not found in table portfolio");
		}
	}


	private void storeRow() throws SQLException
	{
		con=ParsecUtils.getDBConnection();
		String updateStatement =
			"update portfolio set holding =  ? , " +
			"avg_buying_price = ? " +
			"where (customer_id = ?) and (share_id = ?) ";
		PreparedStatement prepStmt = 
			con.prepareStatement(updateStatement);

		prepStmt.setInt(1, holding);
		prepStmt.setFloat(2, avgBuyingPrice);
		prepStmt.setString(3, customerId);
		prepStmt.setString(4, shareId);

		int rowCount = prepStmt.executeUpdate();
		prepStmt.close();con.close();

		if (rowCount == 0)
		{
			throw new EJBException("Storing failed.in table portfolio");
		}
	}

} // PortfolioEJB
