package com.parsec.ejbs.share;

import java.sql.*;
import javax.sql.*;
import java.util.*;
import javax.ejb.*;
import javax.naming.*;
import com.parsec.utils.*;
 
public class CurrentShareStateEJB implements EntityBean
{

        private String shareId;
        private float currentPrice;
        private float todaysHigh;
        private float todaysLow;

	private EntityContext context;
	private Connection con;


	public String getShareId()
	{
		return shareId;
	}
	public float getCurrentPrice()  
	{
		return currentPrice;
	}
        public float getTodaysHigh()
	{
		return todaysHigh;
	}
        public float getTodaysLow()
	{
		return todaysLow;
	}

//Set methods

	public void setShareId(String a)
	{
		shareId = a;
	}

	public void setCurrentPrice(float a)  
	{
		currentPrice = a;
	}
	public void setTodaysHigh(float a)
	{
		todaysHigh = a;
	}
	public void setTodaysLow (float a)
	{
		todaysLow = a;
	}
//End of set methods

	public String ejbCreate(String shareId, 
				float currentPrice,
				float todaysHigh,
				float todaysLow
				)
	throws CreateException
	{

		try
		{
		    insertRow(shareId,currentPrice,todaysHigh,todaysLow);
		} catch (Exception ex)
		{
			throw new EJBException("ejbCreate: " + 
				ex.getMessage());
		}

		this.shareId = shareId;
		this.currentPrice = currentPrice;
		this.todaysHigh = todaysHigh;
		this.todaysLow = todaysLow;

		return shareId;
	}

	public String ejbFindByPrimaryKey(String primaryKey) 
	throws FinderException
	{

		boolean result;

		try
		{
			result = selectByPrimaryKey(primaryKey);
		} catch (Exception ex)
		{
			throw new EJBException("ejbFindByPrimaryKey: " + 
				ex.getMessage());
		}
		if (result)
		{
			return primaryKey;
		}
		else
		{
			throw new ObjectNotFoundException
				("Row for id " + primaryKey + " not found.");
		}
	}

	public void ejbRemove()
	{

		try
		{
			deleteRow(shareId);
		} catch (Exception ex)
		{
			throw new EJBException("ejbRemove: " + 
				ex.getMessage());
		}
	} 

        public void setEntityContext(EntityContext context)
	{

		this.context = context;
//		try {
//		    makeConnection();
//		} catch (Exception ex) {
//		    throw new EJBException("Unable to connect to database. " +
//					   ex.getMessage());
//		}
   	}

	public void unsetEntityContext()
	{

//		try
//		{
//			con.close();
//		} catch (SQLException ex)
//		{
//			throw new EJBException("unsetEntityContext: " + ex.getMessage());
//		}
	}

	public void ejbActivate()
	{

		shareId = (String)context.getPrimaryKey();
	}

	public void ejbPassivate()
	{

		shareId = null;
	}

	public void ejbLoad()
	{

		try
		{
			loadRow();
		} catch (Exception ex)
		{
			throw new EJBException("ejbLoad: " + 
				ex.getMessage());
		}
	}

	public void ejbStore()
	{

		try
		{
			storeRow();
		} catch (Exception ex)
		{
			throw new EJBException("ejbStore: " + 
				ex.getMessage());
		}
	}


	public void ejbPostCreate(String shareId, 
				  float currentPrice,
				  float todaysHigh,
				  float todaysLow
				  )
       { 
       }


	/*********************** Database Routines *************************/

	private void makeConnection() throws NamingException, SQLException
	{

		DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());
		con = DriverManager.getConnection("jdbc:oracle:thin:@everest:1521:GEN","sarvjeet","sarv");
	}

	private void insertRow (String shareId, 
				float currentPrice,
				float todaysHigh,
				float todaysLow
				)
	throws SQLException
	{

		con=ParsecUtils.getDBConnection();
		String insertStatement =
			"insert into current_share_state values (?,?,?,?)";
		PreparedStatement prepStmt = 
			con.prepareStatement(insertStatement);

		prepStmt.setString(1, shareId);
		prepStmt.setFloat(2,currentPrice);
		prepStmt.setFloat(3, todaysHigh);
		prepStmt.setFloat(4, todaysLow);
	}

	private void deleteRow(String shareId) throws SQLException
	{

		con=ParsecUtils.getDBConnection();
		String deleteStatement =
			"delete from current_share_state where share_id = ? ";
		PreparedStatement prepStmt =
			con.prepareStatement(deleteStatement);

		prepStmt.setString(1, shareId);
		prepStmt.executeUpdate();
		prepStmt.close();con.close();
	}

	private boolean selectByPrimaryKey(String primaryKey) 
	throws SQLException
	{
		con=ParsecUtils.getDBConnection();
		String selectStatement =
			"select share_id " +
			"from current_share_state where share_id = ? ";
		PreparedStatement prepStmt =
			con.prepareStatement(selectStatement);
		prepStmt.setString(1, primaryKey);

		ResultSet rs = prepStmt.executeQuery();
		boolean result = rs.next();
		prepStmt.close();con.close();
		return result;
	}



	private void loadRow() throws SQLException
	{
	
		con=ParsecUtils.getDBConnection();
		String selectStatement =
			"select current_price,todays_high,todays_low " +
			"from current_share_state where share_id = ? ";
		PreparedStatement prepStmt = 
			con.prepareStatement(selectStatement);

		prepStmt.setString(1, this.shareId);

		ResultSet rs = prepStmt.executeQuery();

		if (rs.next())
		{
		        this.currentPrice = rs.getFloat(1);
			this.todaysHigh = rs.getFloat(2);
			this.todaysLow = rs.getFloat(3);
			prepStmt.close();con.close();
		}
		else
		{
			prepStmt.close();con.close();
			throw new NoSuchEntityException("Row for primary key not found in table current_share_state.");
		}
	}


	private void storeRow() throws SQLException
	{
		con=ParsecUtils.getDBConnection();
		String updateStatement =
			"update current_share_state set current_price =  ? , " +
			"todays_high = ? , todays_low = ? " +
			"where share_id = ?";
		PreparedStatement prepStmt = 
			con.prepareStatement(updateStatement);

		prepStmt.setFloat(1, currentPrice);
		prepStmt.setFloat(2, todaysHigh);
		prepStmt.setFloat(3, todaysLow);
		prepStmt.setString(4, shareId);

		int rowCount = prepStmt.executeUpdate();
		prepStmt.close();con.close();

		if (rowCount == 0)
		{
			throw new EJBException("Storing row for primary key failed in current_share_state.");
		}
	}

} // CurrentShareStateEJB 

