/*
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */
package com.parsec.ejbs.share;

import java.sql.*;
import javax.sql.*;
import java.util.*;
import javax.ejb.*;
import javax.naming.*;
import com.parsec.utils.*;

 
public class SharePerformanceEJB implements EntityBean
{
	private String shareId;
	private java.util.Date assessDate;
    private float opening;
        private float closing;
        private float daysHigh;
        private float daysLow;

	private EntityContext context;
	private Connection con;


    public String getShareId() {
	return shareId;
    }
        
    public java.util.Date getAssessDate() {
	return assessDate;
    }
        
    public float getOpening() {
	return opening;
    }
       
    public float getClosing() {
	return closing;
    }

    public float getDaysHigh() {
	return daysHigh;
    }

    public float getDaysLow() {
	return daysLow;
    }

    //Set methods

    public void setShareId(String a) {
	shareId = a;
    }
        
    public void setAssessDate(java.util.Date a) {
	assessDate = a ;
    }
        
    public void setOpening(float a) {
	opening = a;
    }
       
    public void setClosing(float a) {
	closing = a;
    }
       
    public void setDaysHigh(float a) {
	daysHigh = a;
    }
       
    public void setDaysLow(float a) {
	daysLow = a;
    }
//End of set methods


	public SharePerformancePrimaryKey ejbCreate(String shareId,
						    java.util.Date assessDate,
						    float opening,
						    float closing,
						    float daysHigh,
						    float daysLow
						    )
	throws CreateException
	{
	    if (shareId == null || assessDate == null) {
		throw new CreateException("All Primary keys are required.");
	    }
		try
		{
			insertRow(shareId,assessDate,opening,closing,daysHigh,daysLow);
		} catch (Exception ex)
		{
			throw new EJBException("ejbCreate: " + 
				ex.getMessage());
		}

		this.shareId = shareId;
		this.assessDate = assessDate;
		this.opening = opening;
		this.closing = closing;
		this.daysHigh = daysHigh;
		this.daysLow = daysLow;

		return new SharePerformancePrimaryKey(shareId,assessDate);
	}

	public SharePerformancePrimaryKey ejbFindByPrimaryKey(SharePerformancePrimaryKey primaryKey) throws FinderException
	{

		boolean result;

		try
		{
			result = selectByPrimaryKey(primaryKey);
		} catch (Exception ex)
		{
			throw new EJBException("ejbFindByPrimaryKey: " + 
				ex.getMessage());
		}
		if (result)
		{
			return primaryKey;
		}
		else
		{
			throw new ObjectNotFoundException
				("Row for id " + primaryKey + " not found.");
		}
	}

        public Collection ejbFindByShareId(String id)
	    throws FinderException {

	    Collection result;
	    
	    try {
		result = selectByShareId(id);
	    } catch (Exception ex) {
		throw new EJBException("ejbFindAll " + 
				       ex.getMessage());
	    }
	    
	    if (result.isEmpty()) {
		throw new ObjectNotFoundException("No rows found.");
	    }
	    else {
		return result;
	    }
	}

	public void ejbRemove()
	{

		try
		{
			deleteRow(shareId,assessDate);
		} catch (Exception ex)
		{
			throw new EJBException("ejbRemove: " + 
				ex.getMessage());
		}
	} 

	public void setEntityContext(EntityContext context)
	{

		this.context = context;
//      try {
//         makeConnection();
//			} catch (Exception ex) {
//          throw new EJBException("Unable to connect to database. " +
//             ex.getMessage());
//			}
   	}

	public void unsetEntityContext()
	{

//		try
//		{
//			con.close();
//		} catch (SQLException ex)
//		{
//			throw new EJBException("unsetEntityContext: " + ex.getMessage());
//		}
	}

	public void ejbActivate()
	{
	    SharePerformancePrimaryKey temp= (SharePerformancePrimaryKey) context.getPrimaryKey();
	    shareId = temp.getShareId();
	    assessDate = temp.getAssessDate();
	}

	public void ejbPassivate()
	{

	    shareId = null;
	    assessDate = null;
	}

	public void ejbLoad()
	{

		try
		{
			loadRow();
		} catch (Exception ex)
		{
			throw new EJBException("ejbLoad: " + 
				ex.getMessage());
		}
	}

	public void ejbStore()
	{

		try
		{
			storeRow();
		} catch (Exception ex)
		{
			throw new EJBException("ejbStore: " + 
				ex.getMessage());
		}
	}


	public void ejbPostCreate(String shareId,
				  java.util.Date assessDate,
				  float opening,
				  float closing,
				  float daysHigh,
				  float daysLow
				  )
	{ 
	}


	/*********************** Database Routines *************************/

	private void makeConnection() throws NamingException, SQLException
	{

		DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());
		con = DriverManager.getConnection("jdbc:oracle:thin:@everest:1521:GEN","sarvjeet","sarv");
	}

	private void insertRow (String shareId,
				java.util.Date assessDate,
				float opening,
				float closing,
				float daysHigh,
				float daysLow
				)
	throws SQLException
	{

		con=ParsecUtils.getDBConnection();
		String insertStatement =
			"insert into share_performance values (?,?,?,?,?,?)";
		PreparedStatement prepStmt = 
			con.prepareStatement(insertStatement);

		prepStmt.setString(1, shareId);
		prepStmt.setDate(2, new java.sql.Date(assessDate.getTime()));
		prepStmt.setFloat(3, opening);
		prepStmt.setFloat(4, closing);
		prepStmt.setFloat(5, daysHigh);
		prepStmt.setFloat(6, daysLow);

		prepStmt.executeUpdate();
		prepStmt.close();con.close();
	}

	private void deleteRow(String a,java.util.Date b) throws SQLException
	{
		con=ParsecUtils.getDBConnection();
		String deleteStatement =
			"delete from share_performance where (share_id = ?) and (assess_date = ?)";
		PreparedStatement prepStmt =
			con.prepareStatement(deleteStatement);

		prepStmt.setString(1, a);
		prepStmt.setDate(2, new java.sql.Date(b.getTime()));
		prepStmt.executeUpdate();
		prepStmt.close();con.close();
	}

	private boolean selectByPrimaryKey(SharePerformancePrimaryKey primaryKey) 
	throws SQLException
	{
		con=ParsecUtils.getDBConnection();
		String selectStatement =
			"select share_id " +
			"from share_performance where (share_id = ?) and (assess_date = ?)";
		PreparedStatement prepStmt =
			con.prepareStatement(selectStatement);
		prepStmt.setString(1, primaryKey.getShareId());
		prepStmt.setDate(2,new java.sql.Date(primaryKey.getAssessDate().getTime()));

		ResultSet rs = prepStmt.executeQuery();
		boolean result = rs.next();
		prepStmt.close();con.close();
		return result;
	}

        private Collection selectByShareId(String id) 
	    throws SQLException {
	    con=ParsecUtils.getDBConnection();
	    String selectStatement =
		"select assess_date " +
		"from share_performance "+
		"where share_id = ?";

	    PreparedStatement prepStmt = 
		con.prepareStatement(selectStatement);

	    prepStmt.setString(1,id);
	    
	    ResultSet rs = prepStmt.executeQuery();
	    Vector a = new Vector();
	    
	    while (rs.next()) {
		SharePerformancePrimaryKey temp=new SharePerformancePrimaryKey(id,new java.util.Date(rs.getDate(1).getTime()));
		a.add(temp);
	    }
	    
	    prepStmt.close();con.close();
	    return a;
	}

	private void loadRow() throws SQLException
	{
	
		con=ParsecUtils.getDBConnection();
		String selectStatement =
			"select opening, closing, days_high, days_low " +
			"from share_performance where (share_id = ?) and (assess_date = ?)";
		PreparedStatement prepStmt = 
			con.prepareStatement(selectStatement);

		prepStmt.setString(1, this.shareId);
		prepStmt.setDate(2, new java.sql.Date(this.assessDate.getTime()));

		ResultSet rs = prepStmt.executeQuery();

		if (rs.next())
		{

			this.opening = rs.getFloat(1);
			this.closing = rs.getFloat(2);
			this.daysHigh = rs.getFloat(3);
			this.daysLow = rs.getFloat(4);
			prepStmt.close();con.close();
		}
		else
		{
			prepStmt.close();con.close();
			throw new NoSuchEntityException("Row for primary key not found in table share_performance");
		}
	}


	private void storeRow() throws SQLException
	{

		con=ParsecUtils.getDBConnection();
		String updateStatement =
			"update share_performance set opening =  ? , " +
			"closing = ? , days_high = ? , days_low = ? " +
			"where (share_id = ?) and (assess_date = ?)";
		PreparedStatement prepStmt = 
			con.prepareStatement(updateStatement);

		prepStmt.setFloat(1, opening);
		prepStmt.setFloat(2, closing);
		prepStmt.setFloat(3, daysHigh);
		prepStmt.setFloat(4, daysLow);
		prepStmt.setString(5,shareId);
		prepStmt.setDate(6,new java.sql.Date(assessDate.getTime()));

		int rowCount = prepStmt.executeUpdate();
		prepStmt.close();con.close();

		if (rowCount == 0)
		{
			throw new EJBException("Storing failed in table share_performance");
		}
	}

} // SharePerformanceEJB
