/*
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */
package com.parsec.ejbs.share;

import java.sql.*;
import javax.sql.*;
import java.util.*;
import javax.ejb.*;
import javax.naming.*;
import com.parsec.utils.*;
 
public class ShareUnitEJB implements EntityBean
{

	private String shareId;
	private String companyId;
	private String name;
	private java.util.Date launchDate;
	private int volume;
	private float faceValue;

	private EntityContext context;
	private Connection con;


	public String getShareId()
	{
		return shareId;
	}

	public String getCompanyId()  
	{
		return companyId;
	}
	public String getName()
	{
		return name;
	}
	public java.util.Date getLaunchDate()
	{
		return launchDate;
	}
	public float getFaceValue()
	{
		return faceValue;
	}
	public int getVolume()
	{
		return volume;
	}

//Set methods

	public void setShareId(String a)
	{
		shareId = a;
	}

	public void setCompanyId(String a)  
	{
		companyId = a;
	}
	public void setName(String a)
	{
		name = a;
	}
	public void setLaunchDate (java.util.Date a)
	{
		launchDate = a;
	}
	public void setVolume(int a)
	{
		volume = a;
	}
	public void setFaceValue(float a)
	{
		faceValue = a;
	}
//End of set methods


	public String ejbCreate(String shareId, 
				String companyId,
				String name,
				java.util.Date launchDate,
				int volume,
				float faceValue
				)
	throws CreateException
	{

		try
		{
			insertRow(shareId,companyId,name,launchDate,volume,faceValue);
		} catch (Exception ex)
		{
			throw new EJBException("ejbCreate: " + 
				ex.getMessage());
		}

		this.shareId = shareId;
		this.companyId = companyId;
		this.name = name;
		this.launchDate = launchDate;
		this.volume = volume;
		this.faceValue = faceValue;

		return shareId;
	}

	public String ejbFindByPrimaryKey(String primaryKey) 
	throws FinderException
	{

		boolean result;

		try
		{
			result = selectByPrimaryKey(primaryKey);
		} catch (Exception ex)
		{
			throw new EJBException("ejbFindByPrimaryKey: " + 
				ex.getMessage());
		}
		if (result)
		{
			return primaryKey;
		}
		else
		{
			throw new ObjectNotFoundException
				("Row for id " + primaryKey + " not found.");
		}
	}


        public Collection ejbFindAll()
	    throws FinderException {

	    Collection result;
	    
	    try {
		result = selectAll();
	    } catch (Exception ex) {
		throw new EJBException("ejbFindAll " + 
				       ex.getMessage());
	    }
	    
	    if (result.isEmpty()) {
		throw new ObjectNotFoundException("No rows found.");
	    }
	    else {
		return result;
	    }
	}


	public void ejbRemove()
	{

		try
		{
			deleteRow(shareId);
		} catch (Exception ex)
		{
			throw new EJBException("ejbRemove: " + 
				ex.getMessage());
		}
	} 

        public void setEntityContext(EntityContext context)
	{

		this.context = context;
//		try {
//		    makeConnection();
//		} catch (Exception ex) {
//		    throw new EJBException("Unable to connect to database. " +
//					   ex.getMessage());
//		}
   	}

	public void unsetEntityContext()
	{

//		try
//		{
//			con.close();
//		} catch (SQLException ex)
//		{
//			throw new EJBException("unsetEntityContext: " + ex.getMessage());
//		}
	}

	public void ejbActivate()
	{
		System.out.println("in activate of shareunit"+shareId);
		shareId = (String)context.getPrimaryKey();
	}

	public void ejbPassivate()
	{
		System.out.println("in passivate of shareunit");
		shareId = null;
	}

	public void ejbLoad()
	{

		try
		{
			loadRow();
		} catch (Exception ex)
		{
			throw new EJBException("ejbLoad: " + 
				ex.getMessage());
		}
	}

	public void ejbStore()
	{

		try
		{
			storeRow();
		} catch (Exception ex)
		{
			throw new EJBException("ejbStore: " + 
				ex.getMessage());
		}
	}


	public void ejbPostCreate(String shareId, 
				  String companyId,
				  String name,
				  java.util.Date launchDate,
				  int volume,
				  float faceValue
				  )
       { 
       }


	/*********************** Database Routines *************************/

	private void makeConnection() throws NamingException, SQLException
	{
		
		
		if (con == null)
		{
			System.out.println("in makecon of shareunit"+shareId);
			DriverManager.registerDriver(new oracle.jdbc.driver.OracleDriver());
			con = DriverManager.getConnection("jdbc:oracle:thin:@everest:1521:GEN","sarvjeet","sarv");
		}
	}

	private void insertRow (String shareId, 
				String companyId,
				String name,
				java.util.Date launchDate,
				int volume,
				float faceValue
				) 
	throws SQLException
	{

		con=ParsecUtils.getDBConnection();
		String insertStatement =
			"insert into share_unit values (?,?,?,?,?,?)";
		PreparedStatement prepStmt = 
			con.prepareStatement(insertStatement);

		prepStmt.setString(1, shareId);
		prepStmt.setString(2,companyId);
		prepStmt.setString(3, name);
		prepStmt.setTimestamp(4, new java.sql.Timestamp(launchDate.getTime()));
		prepStmt.setInt(5, volume);
		prepStmt.setFloat(6, faceValue);
	}

	private void deleteRow(String shareId) throws SQLException
	{

		con=ParsecUtils.getDBConnection();
		String deleteStatement =
			"delete from share_unit where share_id = ? ";
		PreparedStatement prepStmt =
			con.prepareStatement(deleteStatement);

		prepStmt.setString(1, shareId);
		prepStmt.executeUpdate();
		prepStmt.close();con.close();
	}

	private boolean selectByPrimaryKey(String primaryKey) 
	throws SQLException
	{

		con=ParsecUtils.getDBConnection();
		String selectStatement =
			"select share_id " +
			"from share_unit where share_id = ? ";
		PreparedStatement prepStmt =
			con.prepareStatement(selectStatement);
		prepStmt.setString(1, primaryKey);

		ResultSet rs = prepStmt.executeQuery();
		boolean result = rs.next();
		prepStmt.close();con.close();
		return result;
	}

    private Collection selectAll() 
	    throws SQLException {
		
		con=ParsecUtils.getDBConnection();
	    
	    String selectStatement =
		"select share_id " +
		"from share_unit";
	    PreparedStatement prepStmt = 
		con.prepareStatement(selectStatement);
	    
	    ResultSet rs = prepStmt.executeQuery();
	    Vector a = new Vector();
	    
	    while (rs.next()) {
		a.add(rs.getString(1));
	    }
	    
	    prepStmt.close();con.close();
	    return a;
	}

	private void loadRow() throws SQLException
	{
	
		con=ParsecUtils.getDBConnection();
		String selectStatement =
			"select company_id,name,launch_date,volume,face_value " +
			"from share_unit where share_id = ? ";
		PreparedStatement prepStmt = 
			con.prepareStatement(selectStatement);

		prepStmt.setString(1, this.shareId);

		ResultSet rs = prepStmt.executeQuery();

		if (rs.next())
		{
		        this.companyId = rs.getString(1);
			this.name = rs.getString(2);
			this.launchDate = new java.util.Date(rs.getTimestamp(3).getTime());
			this.volume = rs.getInt(4);
			this.faceValue = rs.getFloat(5);
			prepStmt.close();con.close();
		}
		else
		{
			prepStmt.close();con.close();
			throw new NoSuchEntityException("Row for primary key not found in table share_unit.");
		}
	}


	private void storeRow() throws SQLException
	{

		con=ParsecUtils.getDBConnection();
		String updateStatement =
			"update share_unit set company_id =  ? , " +
			"name = ? , launch_date = ? , " +
			"volume = ? , face_value = ? " +
			"where share_id = ? ";
		PreparedStatement prepStmt = 
			con.prepareStatement(updateStatement);

		prepStmt.setString(1, companyId);
		prepStmt.setString(2, name);
		prepStmt.setTimestamp(3, new java.sql.Timestamp(launchDate.getTime()));
		prepStmt.setInt(4, volume);
		prepStmt.setFloat(5, faceValue);
		prepStmt.setString(6, shareId);

		int rowCount = prepStmt.executeUpdate();
		prepStmt.close();con.close();

		if (rowCount == 0)
		{
			throw new EJBException("Storing row for primary key failed in share_unit.");
		}
	}

} // CustomerEJB 
