package com.parsec.servlets;

import java.io.*;
import java.rmi.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import javax.rmi.PortableRemoteObject;
import javax.naming.InitialContext;
import javax.ejb.*;

import com.parsec.ejbs.bidbuy.*;
import com.parsec.utils.*;

public class AdminInterface extends HttpServlet
{	 

	public void doGet(HttpServletRequest req, HttpServletResponse res)
	throws ServletException, IOException
	{ 
		res.setContentType("text/html");
		PrintWriter out=res.getWriter();
		HttpSession session=req.getSession(false);
		if (session==null)
		{
			out.println(ContentTemplate.invalidPage);
			return;
		}
		if (session.getAttribute("com.parsec.servlets.admin.dontPost")==null)
		{
			out.println("Admin page for administrator only");
		}
		session.setAttribute("com.parsec.servlets.admin.dontPost","false");
	 	out.println(ContentTemplate.adminPage());
		out.close();		
	}

	public void doPost(HttpServletRequest req, HttpServletResponse res)
	throws ServletException, IOException
	{ 
		PrintWriter out=res.getWriter();
		HttpSession session=req.getSession(false);
		if (session==null)
		{
			out.println(ContentTemplate.invalidPage);
			return;
		}
		if (((String)session.getAttribute("com.parsec.servlets.admin.dontPost")).equals("true"))
		{
			doGet(req,res);
			return;
		}
		if (session.getAttribute("com.parsec.servlets.admin.dontPost")==null)
		{
			out.println("Admin page for administrator only");
			out.close();
			return;
		}
		res.setContentType("text/html");
 			    
		ParsecUtils.setRefreshRate(Integer.parseInt(req.getParameter("Refresh_Rate")));
	 	ParsecUtils.setLookbackTime(Integer.parseInt(req.getParameter("Lookback_Time")));
	 	ParsecUtils.setAdminPassword(req.getParameter("Admin_Passwd"));
	 	ParsecUtils.setDealAffectorHour(Integer.parseInt(req.getParameter("DealAffector_Hour")));
	 	ParsecUtils.setDealAffectorMinute(Integer.parseInt(req.getParameter("DealAffector_Minute")));
	 	ParsecUtils.setStartHour(Integer.parseInt(req.getParameter("DealBreaker_Start_Hour")));
	 	ParsecUtils.setStartMinute(Integer.parseInt(req.getParameter("DealBreaker_Start_Minute")));
	 	ParsecUtils.setStopHour(Integer.parseInt(req.getParameter("DealBreaker_Stop_Hour")));
	 	ParsecUtils.setStopMinute(Integer.parseInt(req.getParameter("DealBreaker_Stop_Minute")));
	 	ParsecUtils.setSwingMargin(Integer.parseInt(req.getParameter("Swing_Limit")));
		   
		doGet(req,res);
 		out.close();
		
	}
	
} 