package com.parsec.servlets;

import java.io.*;
import java.util.*;
import javax.ejb.*;
import javax.servlet.*;
import javax.servlet.http.*;
import javax.rmi.PortableRemoteObject;
import javax.naming.InitialContext;

import com.parsec.ejbs.authenticator.*;
import com.parsec.ejbs.customer.*;
import com.parsec.ejbs.company.*;

public class AuthenticatorInterface extends HttpServlet
{	 
	Authentication pd;
	UserRegistrationHome urhome;
 	 
	public void init() throws ServletException
	{
		System.out.println("in init of AuthenticatorInterface");
		try
		{
			InitialContext ic = new InitialContext();
			Object objref = ic.lookup("java:comp/env/ejb/Authentication");

			AuthenticationHome home = (AuthenticationHome)PortableRemoteObject.narrow(objref,AuthenticationHome.class);

			pd = home.create();
			
			objref = ic.lookup("java:comp/env/ejb/UserRegistration");
			urhome = (UserRegistrationHome)PortableRemoteObject.narrow(objref,UserRegistrationHome.class);

			 

			System.out.println("out of init");
			
		} catch(Exception e)
		{
			e.printStackTrace();
		}

	} 

	public void doGet(HttpServletRequest req, HttpServletResponse res)
	throws ServletException, IOException
	{
		PrintWriter out=res.getWriter();
		HttpSession session=req.getSession(false);
		if (session==null)//new user
		{
			System.out.println("here in get");
			out.println(ContentTemplate.invalidPage);
			out.close();
			return;	
		}else if (session.getAttribute("com.parsec.servlets.auth.valid")==null)
		{
			out.println("Auth page for Authenticator only");
			out.close();
			return;
		}else
		{
			session.setAttribute("com.parsec.servlets.admin.dontPost","false");
			out.println(ContentTemplate.authenticatorStart);
			Vector v=new Vector();
			try
			{
				v=new Vector(urhome.findAll());
			}catch(FinderException e)
			{
				e.printStackTrace();
			}
			for(int i=0;i<v.size();i++)
			{
				com.parsec.ejbs.customer.UserRegistration ur=(com.parsec.ejbs.customer.UserRegistration)v.elementAt(i);
				out.println(ContentTemplate.generateAuthRow(ur.getLogin(),
															ur.getName(),
															ur.getBankName(),
															ur.getBankAcc(),
															ur.getMarginMoney(),
															ur.getStreet(),
															ur.getCity(),
															ur.getState(),
															ur.getPinCode(),
															ur.getEmail(),
															ur.getTelephone()));
			}		
			out.println(ContentTemplate.authenticatorEnd);
		}
 		out.close();	
	}	

	public void doPost(HttpServletRequest req, HttpServletResponse res)
	throws ServletException, IOException
	{ 
		res.setContentType("text/html");
		PrintWriter out=res.getWriter();
		HttpSession session=req.getSession(false);
		if (session==null)
		{
			out.println(ContentTemplate.invalidPage);
			return;
		}
		if (((String)session.getAttribute("com.parsec.servlets.admin.dontPost")).equals("true"))
		{
			doGet(req,res);
			return;
		}
		if (session.getAttribute("com.parsec.servlets.admin.dontPost")==null)
		{
			out.println("Admin page for administrator only");
			out.close();
			return;
		}
		System.out.println("alap is here");
		String[] checks=req.getParameterValues("approve");
 		if (req.getParameter("Accept")!=null)
	  		for(int i=0;i<checks.length;i++)
				pd.userApprove(checks[i],"auth1");
		else
    		for(int i=0;i<checks.length;i++)
				pd.userReject(checks[i]);
		
		doGet(req,res);
	}
  
	
} 

