package com.parsec.servlets;

import java.io.*;
import java.rmi.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import javax.rmi.PortableRemoteObject;
import javax.naming.InitialContext;

import com.parsec.ejbs.bidbuy.*;
import com.parsec.utils.*;

public class BuyShares extends HttpServlet
{	 

	PlaceBid pbid;
	  
	public void init() throws ServletException
	{
		try
		{
			InitialContext ic = new InitialContext();
			Object objref = ic.lookup("java:comp/env/ejb/PlaceBid");
	 		PlaceBidHome home = (PlaceBidHome)PortableRemoteObject.narrow(objref,PlaceBidHome.class);
	 		pbid = home.create();
			System.out.println("muummy main yahan hun");
	 	} catch(Exception e)
		{
			e.printStackTrace();
		}
	 } 


	public void doGet(HttpServletRequest req, HttpServletResponse res)
	throws ServletException, IOException
	{ 
		res.setContentType("text/html");
		PrintWriter out=res.getWriter();
		HttpSession session=req.getSession(false);
		if (session==null)
		{
			out.println(ContentTemplate.invalidPage);
			
		}else
		{
		 	out.println(ContentTemplate.buySharesPage);
		}
		out.close();		
	}

	public void doPost(HttpServletRequest req, HttpServletResponse res)
	throws ServletException, IOException
	{ 
		res.setContentType("text/html");
		PrintWriter out=res.getWriter();
		HttpSession session=req.getSession(false);
		if (session==null)
		{
			out.println(ContentTemplate.invalidPage);
			return;
		}
		String uid=(String)session.getAttribute("com.parsec.servlets.login");
		if (!ParsecUtils.checkValidTime())
		{
			out.println(ContentTemplate.tradingStopped);
			out.close();
			return;
		}
		String cid=req.getParameter("scripCode");
		int numShares=Integer.parseInt(req.getParameter("orderQuantity"));
		float price=Float.parseFloat(req.getParameter("stopLoss"));
		int hrs=Integer.parseInt(req.getParameter("hours"));
		int min=Integer.parseInt(req.getParameter("minutes"));
		int sec=Integer.parseInt(req.getParameter("seconds"));
		Date exp=new Date(System.currentTimeMillis()+hrs*60*60*1000+min*60*1000+sec*1000);
		
		
		try
		{
			System.out.println("pbid is : "+pbid);
			if (pbid.doBuy(uid,cid,exp,numShares,price))
			{
				System.out.println("buy ok");
				out.println(ContentTemplate.tradePlaced);
			}else
			{
				System.out.println("no");
				out.println(ContentTemplate.errorInTrade);
			}
		}catch(RemoteException e)
		{
			out.println(ContentTemplate.header+ 
			            ContentTemplate.bodyStart+ 
						e.getMessage()+
						ContentTemplate.bodyEnd+
						ContentTemplate.footnote);
		}catch(IllegalArgumentException e)
		{
		out.println(ContentTemplate.header+ 
		            ContentTemplate.bodyStart+ 
					e.getMessage()+
					ContentTemplate.bodyEnd+
					ContentTemplate.footnote);
		
		}
	
		out.close();
	}
	
} 

