package com.parsec.servlets;

import java.io.*;
import java.rmi.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import javax.rmi.PortableRemoteObject;
import javax.naming.InitialContext;
import javax.ejb.*;

import com.parsec.ejbs.bidbuy.*;
import com.parsec.utils.*;

public class CancelBid extends HttpServlet
{	 
	com.parsec.ejbs.bidbuy.CancelBid cb;
	BuyingCallHome bch;
	SellingCallHome sch;

		public void init() throws ServletException
	{
		try
		{
			InitialContext ic = new InitialContext();
			Object objref = ic.lookup("java:comp/env/ejb/CancelBid");
			CancelBidHome home = (CancelBidHome)PortableRemoteObject.narrow(objref,CancelBidHome.class);
			cb = home.create();
			objref = ic.lookup("java:comp/env/ejb/BuyingCall");
			bch = (BuyingCallHome)PortableRemoteObject.narrow(objref,BuyingCallHome.class);
			objref = ic.lookup("java:comp/env/ejb/SellingCall");
			sch = (SellingCallHome)PortableRemoteObject.narrow(objref,SellingCallHome.class);
		} catch(Exception e)
		{
			e.printStackTrace();
		}
	} 


	public void doGet(HttpServletRequest req, HttpServletResponse res)
	throws ServletException, IOException
	{ 
		res.setContentType("text/html");
		PrintWriter out=res.getWriter();
		HttpSession session=req.getSession(false);
		if (session==null)
		{
			out.println(ContentTemplate.invalidPage);

		}else
		{
			out.println(ContentTemplate.cancelBidStart);//<-------------------
			String uid=(String)session.getAttribute("com.parsec.servlets.login");

			try
			{

				Vector buys=new Vector(bch.findByCustomerId(uid));


				session.setAttribute("com.parsec.servlets.BuyingCalls",buys);
				int numBuys=buys.size();
				for(int i=0;i<numBuys;i++)
				{
					BuyingCall bcall=(BuyingCall)buys.elementAt(i);
					out.println(ContentTemplate.generateBidBuyRow(bcall.getShareId(),
						bcall.getBidTime(),
						bcall.getExpiryTime(),
						bcall.getNoOfShares(),
						bcall.getPrice(),
						i,false));	   
				}
			}catch(FinderException e)
			{
				out.println(ContentTemplate.noBids);
			}
			out.println(ContentTemplate.cancelBidMid);//<------------------

			try
			{	
				Vector sells=new Vector(sch.findByCustomerId(uid));
				session.setAttribute("com.parsec.servlets.SellingCalls",sells);
				int numSells=sells.size();
				for(int i=0;i<numSells;i++)
				{
					SellingCall scall=(SellingCall)sells.elementAt(i);
					out.println(ContentTemplate.generateBidBuyRow(scall.getShareId(),
						scall.getBidTime(),
						scall.getExpiryTime(),
						scall.getNoOfShares(),
						scall.getPrice(),
						i,true));
				}
			}
			catch (FinderException fe)
			{
				out.println(ContentTemplate.noBids );
			}
			out.println(ContentTemplate.cancelBidEnd);//<---------------


		}
		out.close();		
	}

	public void doPost(HttpServletRequest req, HttpServletResponse res)
	throws ServletException, IOException
	{ 
		res.setContentType("text/html");
		PrintWriter out=res.getWriter();
		HttpSession session=req.getSession(false);
		if (session==null)
		{
			out.println(ContentTemplate.invalidPage);
			return;
		}

		String uid=(String)session.getAttribute("com.parsec.servlets.login");
		if (!ParsecUtils.checkValidTime())
		{
			out.println(ContentTemplate.tradingStopped);
			out.close();
			return;
		}
		out.println(ContentTemplate.cancellingTradesStart);
		Vector sells=(Vector)session.getAttribute("com.parsec.servlets.SellingCalls");
		Vector buys=(Vector)session.getAttribute("com.parsec.servlets.BuyingCalls");
		String[] cancelBuys=req.getParameterValues("cancelBuys");
		String[] cancelSells=req.getParameterValues("cancelSells");
		if (cancelBuys!=null)
			for(int i=0;i<cancelBuys.length;i++)
			{
				BuyingCall bcall=(BuyingCall)buys.elementAt(Integer.parseInt(cancelBuys[i]));
				try
				{
					cb.cancelBuy(uid,
						bcall.getShareId(),
						bcall.getBidTime(),
						bcall.getExpiryTime(),
						bcall.getNoOfShares(),
						bcall.getPrice());
				}catch(RemoteException e)
				{
					out.println("<tr>The trade"+
						bcall.getShareId()+":"+
						bcall.getBidTime()+":"+
						bcall.getExpiryTime()+":"+
						bcall.getNoOfShares()+":"+
						bcall.getPrice()+":"+
						" could not be cancelled<br> error: "+e.getMessage()+"</tr>");//<<<<<<<<<<< WHAT TO DO HERE IN ERROR?
				}	 
			}
			if (cancelSells!=null)
				for(int i=0;i<cancelSells.length;i++)
				{
					SellingCall scall=(SellingCall)sells.elementAt(Integer.parseInt(cancelSells[i]));
					try
					{
						cb.cancelSell(uid,
							scall.getShareId(),
							scall.getBidTime(),
							scall.getExpiryTime(),
							scall.getNoOfShares(),
							scall.getPrice());
					}catch(RemoteException e)
					{
						out.println("<tr>The trade"+
							scall.getShareId()+":"+
							scall.getBidTime()+":"+
							scall.getExpiryTime()+":"+
							scall.getNoOfShares()+":"+
							scall.getPrice()+":"+
							" could not be cancelled<br> error: "+e.getMessage()+"</tr>");//
					}	 
				}
				out.println(ContentTemplate.cancellingTradesEnd);
				out.close();
	}

} 


