package com.parsec.servlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import javax.rmi.PortableRemoteObject;
import javax.naming.InitialContext;
import java.util.*;
import com.parsec.ejbs.login.*;

public class LoginServlet extends HttpServlet
{

	Login loginVerifier; 
	
	public void init() throws ServletException
	{
		System.out.println("in init of LoginServlet");
		try
		{	
			ServletContext sc=getServletContext();
			InitialContext ic = new InitialContext();
			Object objref = ic.lookup("java:comp/env/ejb/Login");
			System.out.println("lookup ok");
			LoginHome home = (LoginHome)PortableRemoteObject.narrow(objref,LoginHome.class);
			System.out.println("narrow ok");
			loginVerifier = home.create();
			System.out.println("create ok");
			//since login is the first proper logic page that will be called, file parsing is done here
			
        } catch(Exception e)
       {
	     e.printStackTrace();
       }
	
    } 
	

	public void doGet(HttpServletRequest req, HttpServletResponse res)
	throws ServletException, IOException
	{
		PrintWriter out=res.getWriter();
		HttpSession session=req.getSession(false);
		if (session==null)//new user
		{
			out.println(ContentTemplate.loginPage);
		}
		else
			forwardRequestToPortfolio(req,res);
		out.close();	
		return;	
	}	


	public void doPost(HttpServletRequest req, HttpServletResponse res)
	throws ServletException, IOException
	{
		//obtain session object
		HttpSession session=req.getSession(true);
		//get the form params
		String uid = req.getParameter("loginField");
		String passwd = req.getParameter("passwordField");
		//check login password from my bean
		boolean result = loginVerifier.checkCustomerLogin(uid,passwd);
		boolean auresult = loginVerifier.checkAuthenticatorLogin(uid,passwd);
		boolean adresult = loginVerifier.checkAdministratorLogin(uid,passwd);
		//set response type
		res.setContentType("text/html");
		PrintWriter out = res.getWriter();
		//generate page

		if (result)
		{
			System.out.println("here in customer");
			session.setAttribute("com.parsec.servlets.login",uid);
			forwardRequestToPortfolio(req,res);
		}else if(adresult)
		{
			System.out.println("here in admin");
			session.setAttribute("com.parsec.servlets.admin.dontPost","true");
			forwardRequestToAdmin(req,res);
		}else if(auresult)
		{
			System.out.println("here in auth");
			session.setAttribute("com.parsec.servlets.admin.dontPost","true");
			session.setAttribute("com.parsec.servlets.auth.valid","true");
			forwardRequestToAuth(req,res);
		}else
		{

			session.invalidate();
			out.println(ContentTemplate.invalidPage);
		}
 
	}


	private void forwardRequestToPortfolio(HttpServletRequest req, HttpServletResponse res)
	throws IOException,ServletException{
		RequestDispatcher dispatcher=getServletContext().getRequestDispatcher("/PortfolioRetriever");
		if (dispatcher == null) 
		{
			try
			{
            res.sendError(res.SC_NO_CONTENT);
			}catch(IOException e)
			{
				System.out.println(e);
			}
		}
	 	dispatcher.forward(req,res);
	}
	
	private void forwardRequestToAdmin(HttpServletRequest req, HttpServletResponse res)
	throws IOException,ServletException{
		RequestDispatcher dispatcher=getServletContext().getRequestDispatcher("/AdminInterface");
		if (dispatcher == null) 
		{
			try
			{
            res.sendError(res.SC_NO_CONTENT);
			}catch(IOException e)
			{
				System.out.println(e);
			}
		}
	 	dispatcher.forward(req,res);
	}

    private void forwardRequestToAuth(HttpServletRequest req, HttpServletResponse res)
	throws IOException,ServletException{
		RequestDispatcher dispatcher=getServletContext().getRequestDispatcher("/AuthenticatorInterface");
		if (dispatcher == null) 
		{
			try
			{
            res.sendError(res.SC_NO_CONTENT);
			}catch(IOException e)
			{
				System.out.println(e);
			}
		}
		System.out.println("error here");
	 	dispatcher.forward(req,res);
	}
 
} 

