package com.parsec.servlets;

import java.io.*;
import java.util.*;
import java.net.*;

public class ParsecUtils
{
	static int startTime=7*60;
	static int stopTime=13*60;
	static int refreshRate=30;
	
	static String configURL="http://localhost:8000/parsec/config/ConfigFile";
	static URL configFile;
	
	static
	{
		try
		{
		  configFile = new URL(configURL);
		}catch(MalformedURLException e)
		{
			System.out.println(e);
		}
	}
	static Properties settings = new Properties();

	public static boolean checkValidTime()
	{
		loadFile();
		Date now=new Date(System.currentTimeMillis());
		if (now.getHours()*60+now.getMinutes()>stopTime||
			now.getHours()*60+now.getMinutes()<startTime)
		{
			return false;
		}
		return true;
	}
	
	private static void loadFile()
	{
	  try
		{
		settings.load(configFile.openStream());
		}catch(IOException e)
		{
			e.printStackTrace();
		}

		int refreshrate = Integer.parseInt((String)settings.get("Refresh_Rate"));
		int starthour = Integer.parseInt((String)settings.get("DealBreaker_Start_Hour"));
		int startminute = Integer.parseInt((String)settings.get("DealBreaker_Start_Minute"));
		int stophour = Integer.parseInt((String)settings.get("DealBreaker_Stop_Hour"));
		int stopminute = Integer.parseInt((String)settings.get("DealBreaker_Stop_Minute"));
		
		startTime=starthour*60+startminute;
		stopTime=stophour*60+stopminute;
	}	
}
